---
generated_at: 2026-01-15 10:36:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-OnOpen通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdWebSocket.cls` 行43（OnOpenイベント宣言）
- E-02: `src/stdWebSocket.cls` 行155（RaiseEvent OnOpen呼び出し）
- E-03: `src/stdWebSocket.cls` 行41-42（イベントコメント・パラメータ説明）
- E-04: `src/stdWebSocket.cls` 行152-167（handleEventメソッド全体）
- E-05: `src/stdWebSocket.cls` 行111-118（JavaScriptイベントハンドラ設定）
- E-06: `src/stdWebSocket.cls` 行113（ws.onopen設定）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行5（OnOpen通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OnOpenイベントはstdWebSocket.cls行43で宣言されている | E-01 | ○ |
| C-02 | イベントはhandleEventメソッド内行155で発火する | E-02 | ○ |
| C-03 | eventData引数はJavaScriptイベントオブジェクト | E-01, E-03 | ○ |
| C-04 | JavaScriptのonopenハンドラでhandleEventが呼ばれる | E-05, E-06 | ○ |
| C-05 | EventRaisedの後にOnOpenが発火する | E-04（行153, 155の順序） | ○ |
| C-06 | sEventNameが"Open"の場合にOnOpenが発火 | E-04（行155） | ○ |
| C-07 | handleEventはvb_obj.handleEventとして呼ばれる | E-06 | ○ |
| C-08 | WebSocketはnew WebSocket(websocket_url)で作成される | E-05（行112） | ○ |
| C-09 | 通知一覧.csvに記載がある | E-07 | ○ |
| C-10 | イベントはByValで渡される | E-01 | ○ |
| C-11 | onopenはfunction(event)形式で設定される | E-06 | ○ |
| C-12 | 接続確立成功時のみOnOpenが発火する | E-04, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行43）の引数型が正しいか確認
- [ ] JavaScript側のonopenハンドラ設定（行113）を確認
- [ ] handleEventでの分岐処理（行155）を確認
