---
generated_at: 2026-01-15 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-OnError通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdWebSocket.cls` 行51（OnErrorイベント宣言）
- E-02: `src/stdWebSocket.cls` 行157（RaiseEvent OnError呼び出し）
- E-03: `src/stdWebSocket.cls` 行49-50（イベントコメント・パラメータ説明）
- E-04: `src/stdWebSocket.cls` 行152-167（handleEventメソッド全体）
- E-05: `src/stdWebSocket.cls` 行115（ws.onerror設定）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行7（OnError通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OnErrorイベントはstdWebSocket.cls行51で宣言されている | E-01 | ○ |
| C-02 | イベントはhandleEventメソッド内行157で発火する | E-02 | ○ |
| C-03 | eventData引数はJavaScript ErrorEventオブジェクト | E-01, E-03 | ○ |
| C-04 | JavaScriptのonerrorハンドラでhandleEventが呼ばれる | E-05 | ○ |
| C-05 | EventRaisedの後にOnErrorが発火する | E-04（行153, 157の順序） | ○ |
| C-06 | sEventNameが"Error"の場合にOnErrorが発火 | E-04（行157） | ○ |
| C-07 | onerrorはfunction(event)形式で設定される | E-05 | ○ |
| C-08 | handleEventにはvb_obj経由でアクセスされる | E-05 | ○ |
| C-09 | 通知一覧.csvに記載がある | E-06 | ○ |
| C-10 | イベントはByValで渡される | E-01 | ○ |
| C-11 | エラー発生時に必ずOnErrorが発火する | E-04, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行51）の引数型が正しいか確認
- [ ] JavaScript側のonerrorハンドラ設定（行115）を確認
- [ ] handleEventでの分岐処理（行157）を確認
