---
generated_at: 2026-01-15 10:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-Tick通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **MsgBox/InputBox動作確認**：モーダルダイアログ中の動作は実行テストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdTimer.cls` 行45（Tickイベント宣言）
- E-02: `src/stdTimer.cls` 行180（RaiseEvent Tick呼び出し）
- E-03: `src/stdTimer.cls` 行11-38（アーキテクチャコメント）
- E-04: `src/stdTimer.cls` 行56-59（Createメソッド）
- E-05: `src/stdTimer.cls` 行65-72（protInitメソッド）
- E-06: `src/stdTimer.cls` 行76-90（createRemoteWorkbookメソッド）
- E-07: `src/stdTimer.cls` 行136-168（getTimerCodeメソッド）
- E-08: `src/stdTimer.cls` 行179-182（xlRemoteWorkbook_SheetChangeイベントハンドラ）
- E-09: `src/stdTimer.cls` 行171-174（Class_Terminateメソッド）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行9（Tick通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TickイベントはstdTimer.cls行45で宣言されている | E-01 | ○ |
| C-02 | イベントはxlRemoteWorkbook_SheetChange内行180で発火する | E-02 | ○ |
| C-03 | リモートワークブックのSheetChangeを利用している | E-03, E-08 | ○ |
| C-04 | Createメソッドでミリ秒とコールバックを指定する | E-04 | ○ |
| C-05 | protInitでリモートワークブックを作成する | E-05 | ○ |
| C-06 | CreateObject("Excel.Application")で別プロセスを作成 | E-06（行78） | ○ |
| C-07 | タイマーコードが動的に注入される | E-05（行70）, E-07 | ○ |
| C-08 | MainLoopでSheets(1).Range("A1")を変更してイベント発火 | E-07（行154） | ○ |
| C-09 | pCallbackがあればcallback.Runが呼ばれる | E-08（行181） | ○ |
| C-10 | Class_TerminateでStopTimerが呼ばれる | E-09（行172） | ○ |
| C-11 | VBOMの有効化チェックと設定が行われる | E-05（行67） | ○ |
| C-12 | setVBOMでレジストリ設定が変更される | `src/stdTimer.cls` 行116-131 | ○ |
| C-13 | 通知一覧.csvに記載がある | E-10 | ○ |
| C-14 | イベントは引数を持たない | E-01 | ○ |
| C-15 | SafeTimersから着想を得ている | E-03（行11-12） | ○ |
| C-16 | Edit/Pointモード中もTickが発火する | E-03（行20） | ○ |
| C-17 | デバッグ中はTickが発火しない | E-03（行25） | ○ |
| C-18 | MsgBox/InputBox中はTickが発火しない | E-03（行19） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について、MsgBox/InputBox中の動作はコメントに記載されているが、実際の動作テストが必要
  - 候補：実行環境でのテスト / SafeTimersとの比較検証

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - VBOMアクセスのためにレジストリを変更するため、セキュリティポリシーに抵触する可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行45）を確認
- [ ] SheetChangeイベントハンドラ（行179-182）の処理を確認
- [ ] getTimerCode（行136-168）の注入コードを確認
- [ ] VBOMの有効化処理（行107-131）を確認
