---
generated_at: 2026-01-15 10:46:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：9-SelectionChange通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **WIPステータスの確認**：開発中の機能のため動作の安定性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行10（SelectionChangeイベント宣言）
- E-02: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行84（RaiseEvent SelectionChange呼び出し）
- E-03: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行27-66（ESelectionType列挙型）
- E-04: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行67-76（SelectionInfo構造体）
- E-05: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行80-148（cbs_OnUpdateメソッド）
- E-06: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行23-24（WithEvents cbs変数）
- E-07: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行150-152（Class_Initialize）
- E-08: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行156-163（getSelectionメソッド）
- E-09: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行237-254（selectionsAreDifferentメソッド）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行10（SelectionChange通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SelectionChangeイベントは行10で宣言されている | E-01 | ○ |
| C-02 | イベントはcbs_OnUpdate内行84で発火する | E-02 | ○ |
| C-03 | selOld/selNewはObject型の引数 | E-01 | ○ |
| C-04 | CommandBars.OnUpdateをフックしている | E-05, E-06, E-07 | ○ |
| C-05 | ESelectionTypeで約40種類の選択タイプを定義 | E-03 | ○ |
| C-06 | SelectionInfoで選択状態を保持する | E-04 | ○ |
| C-07 | Static変数で前回選択を保持 | E-05（行81） | ○ |
| C-08 | getSelectionで現在の選択状態を取得 | E-08 | ○ |
| C-09 | selectionsAreDifferentで変更を判定 | E-09 | ○ |
| C-10 | Class_InitializeでCommandBarsへの参照を取得 | E-07（行151） | ○ |
| C-11 | 通知一覧.csvに記載がある | E-10 | ○ |
| C-12 | WIPディレクトリに配置されている | ファイルパス確認 | ○ |
| C-13 | 個別イベントの前に発火する | E-05（行84-97の順序） | ○ |
| C-14 | 選択未変更時はイベントが発火しない | E-05（行83条件分岐） | ○ |
| C-15 | 本番環境での動作安定性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15について、WIPディレクトリに配置されており、本番環境での動作安定性が未確認
  - 候補：実行環境でのテスト / ユニットテスト / ベータテスト結果

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - WIP（開発中）の機能のため、APIが変更される可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行10）の引数型を確認
- [ ] cbs_OnUpdateメソッド（行80-148）の選択変更検出ロジックを確認
- [ ] selectionsAreDifferent（行237-254）の比較ロジックを確認
- [ ] WIPステータスと本番利用の適合性を確認
