---
generated_at: 2026-01-15 20:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：運用マニュアル.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **stdHTTPの機能説明**：HOLD状態のため詳細仕様が不明確
  2. **stdWebSocketの機能説明**：IE依存の実装でWIP状態
  3. **Mac環境での制限事項**：具体的な制限範囲の詳細が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、機能一覧、インストール手順
- E-02: `docs/code-to-docs/README.md` - 技術スタック、ディレクトリ構成
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 全25機能の一覧と状態
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 36件の業務要件定義
- E-05: `docs/code-to-docs/機能設計書/1-stdArray.md` - stdArray機能設計
- E-06: `docs/code-to-docs/機能設計書/3-stdLambda.md` - stdLambda機能設計
- E-07: `docs/code-to-docs/機能設計書/9-stdRegex.md` - stdRegex機能設計
- E-08: `src/stdArray.cls` - stdArrayソースコード（README.mdで参照）
- E-09: `src/stdLambda.cls` - stdLambdaソースコード（README.mdで参照）
- E-10: `src/stdRegex.cls` - stdRegexソースコード（README.mdで参照）
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面なしの確認
- E-12: `docs/code-to-docs/画面一覧/画面遷移図.md` - ライブラリプロジェクトの確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdVBAはモダンなVBAアプリケーション開発のための共通標準ライブラリ | E-01, E-02 | ○ |
| C-02 | JavaScriptやPythonのAPIに強くインスパイアされている | E-01 | ○ |
| C-03 | stdArrayはJavaScriptライクな動的配列クラス | E-03, E-05 | ○ |
| C-04 | stdArrayはMap/Filter/Reduce等の高階関数をサポート | E-04, E-05 | ○ |
| C-05 | stdLambdaは文字列式からラムダ関数を生成するクラス | E-03, E-06 | ○ |
| C-06 | stdLambdaは$1/$2等のプレースホルダーで引数を参照 | E-04, E-06 | ○ |
| C-07 | stdRegexは名前付きキャプチャグループをサポート | E-03, E-07 | ○ |
| C-08 | stdRegexはi/g/m/x/c/sフラグをサポート | E-07 | ○ |
| C-09 | stdEnumeratorはイテレータ・列挙子クラス | E-03 | ○ |
| C-10 | stdCallbackはコールバックオブジェクト生成クラス | E-03, E-04 | ○ |
| C-11 | stdWindowはWin32ウィンドウ管理APIのラッパー | E-03 | ○ |
| C-12 | stdProcessはプロセス管理クラス | E-03, E-04 | ○ |
| C-13 | stdClipboardはクリップボード管理クラス | E-03, E-04 | ○ |
| C-14 | stdPerformanceはパフォーマンス計測クラス | E-03 | ○ |
| C-15 | stdHTTPはHTTP通信クラス（HOLD状態） | E-03 | ○ |
| C-16 | stdHTTPの詳細機能説明 | **根拠なし** | △ |
| C-17 | stdWebSocketはWebSocket通信クラス | E-03 | ○ |
| C-18 | stdWebSocketの詳細機能説明 | **根拠なし** | △ |
| C-19 | VB_PredeclaredId = Trueによるファクトリパターン | E-01, E-05, E-06 | ○ |
| C-20 | stdICallableインターフェースの実装 | E-03, E-04, E-05 | ○ |
| C-21 | 配列のインデックスは1-based | E-05 | ○ |
| C-22 | チャンキングによる配列拡張 | E-05 | ○ |
| C-23 | Map/Filter等は新しい配列を返却（不変性） | E-05 | ○ |
| C-24 | QuickSortアルゴリズムを使用 | E-04, E-05 | ○ |
| C-25 | stdLambdaの演算子優先度 | E-06 | ○ |
| C-26 | stdLambdaのパフォーマンスキャッシュ | E-06 | ○ |
| C-27 | stdRegexのキャッシュ機構 | E-07 | ○ |
| C-28 | 対応環境（Excel/Word/PowerPoint/Access） | E-01, E-02 | ○ |
| C-29 | Windows（32bit/64bit）対応 | E-02, E-04 | ○ |
| C-30 | Mac対応（一部機能に制限あり） | E-02, E-04 | ○ |
| C-31 | Mac環境での具体的な制限事項 | **根拠なし** | △ |
| C-32 | インストール手順（ドラッグ&ドロップ） | E-01 | ○ |
| C-33 | 依存ファイルの組み合わせ | E-03, E-05, E-06 | ○ |
| C-34 | エラーメッセージの一覧 | E-05, E-06, E-07 | ○ |
| C-35 | GitHub Issues/Discussionsの案内 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- stdHTTPの詳細機能説明
  - HOLD状態のため詳細な機能設計書が未作成
  - 候補：stdHTTP機能設計書の作成 / ソースコード直接参照 / 開発者への確認
- stdWebSocketの詳細機能説明
  - IE依存の実装でWIP状態のため、安定した仕様が確定していない
  - 候補：stdWebSocket機能設計書の作成 / ソースコード直接参照
- Mac環境での具体的な制限事項
  - 条件付きコンパイル分岐の詳細調査が必要
  - 候補：各ソースコードの#If Mac分岐を調査 / 開発者への確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、基本操作（C-01〜C-14, C-19〜C-29, C-32〜C-35）
  - プロジェクトREADME、機能一覧、機能設計書から十分な根拠あり
- **1: 中リスク** - Mac対応関連（C-30, C-31）
  - 対応していることは明記されているが、具体的な制限範囲が不明確
- **2: 高リスク** - HOLD/WIP状態の機能（C-16, C-18）
  - stdHTTP、stdWebSocketは開発途中のため、記載内容が実際と異なる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 主要機能（stdArray, stdLambda, stdRegex）のコード例が実際に動作することを確認
- [ ] インストール手順に従ってライブラリをインポートできることを確認
- [ ] エラーメッセージ一覧が実際のエラーと一致することを確認
- [ ] HOLD状態のstdHTTPに関する記載が実態と合っているか確認
- [ ] Mac環境での動作確認（可能であれば）
- [ ] 依存ファイルの組み合わせが正しいことを確認（stdICallable.clsの必要性等）
- [ ] バージョン情報（改訂履歴）が適切に管理されているか確認
