---
generated_at: 2026-01-15 20:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **NFT-COMPAT-003（Mac部分互換性テスト）**：Mac環境での実機テスト未実施
  2. **NFT-STRESS-001（大量配列処理性能テスト）**：具体的なベンチマーク基準なし
  3. **NFT-STRESS-002（複数タイマー並行実行テスト）**：実環境での動作確認が必要
  4. **NFT-MAINT-004（スタックトレース機能テスト）**：stdErrorがWIP（開発中）ステータス

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdHTTP.cls` - HTTP通信クラス（タイムアウト、認証、プロキシ設定）
- E-02: `src/stdPerformance.cls` - パフォーマンス計測クラス（GetTickCount API使用）
- E-03: `src/stdSentry.cls` - センチネルパターン実装（リソース自動復元）
- E-04: `src/stdProcess.cls` - プロセス管理クラス（Win32 API宣言）
- E-05: `src/stdWebSocket.cls` - WebSocket通信クラス（IE COM使用）
- E-06: `src/stdReg.cls` - レジストリアクセスクラス（advapi32.dll API）
- E-07: `src/stdTimer.cls` - タイマークラス（VBOM拡張使用）
- E-08: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件定義
- E-09: `docs/code-to-docs/セキュリティ設計書/セキュリティ設計書.md` - セキュリティ設計
- E-10: `docs/code-to-docs/インフラ設計書/インフラ設計書.md` - インフラ設計
- E-11: `docs/code-to-docs/テスト方針書/テスト方針書.md` - テスト方針
- E-12: `tests/lib/Test.cls` - テストフレームワーク
- E-13: `tests/stdHTTPTests.bas` - HTTPテスト
- E-14: `tests/stdPerformanceTests.bas` - パフォーマンステスト
- E-15: `tests/stdProcessTests.bas` - プロセステスト
- E-16: `tests/stdSentryTests.bas` - センチネルテスト
- E-17: `src/stdHTTPAuthenticators.bas` - 認証ヘルパーモジュール
- E-18: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP同期リクエスト応答時間テスト：5000ms以内 | E-01, E-08 | ○ |
| C-02 | HTTP非同期リクエスト処理継続性テスト：DoEventsで処理継続 | E-01 | ○ |
| C-03 | パフォーマンス計測精度テスト：ミリ秒単位 | E-02, E-08 | ○ |
| C-04 | タイマー精度テスト：指定ミリ秒での発火 | E-07, E-08 | ○ |
| C-05 | プロセス検索性能テスト：ミリ秒単位完了 | E-04, E-08 | ○ |
| C-06 | stdSentryオプティマイザ効果測定テスト | E-03, E-14 | ○ |
| C-07 | stdLambdaパフォーマンスキャッシュテスト | E-11 | ○ |
| C-08 | HTTPタイムアウト処理テスト：Err.Raise 10000 | E-01 | ○ |
| C-09 | プロキシフォールバックテスト：isRecoverableフラグ | E-01 | ○ |
| C-10 | プロセスハンドル自動解放テスト：CloseHandle | E-04 | ○ |
| C-11 | レジストリハンドル自動解放テスト：RegCloseKey | E-06 | ○ |
| C-12 | WebSocket接続解放テスト：ie.Quit | E-05 | ○ |
| C-13 | stdSentryリソース復元テスト：Class_Terminate | E-03, E-16 | ○ |
| C-14 | Basic認証実装テスト：SetCredentials | E-01, E-17, E-09 | ○ |
| C-15 | Windows認証実装テスト：WindowsAuthenticator | E-17, E-09 | ○ |
| C-16 | HTTPS証明書検証テスト：EnableCertificateRevocationCheck | E-01, E-09 | ○ |
| C-17 | SSL/TLSエラーハンドリングテスト：WINHTTP_ERROR | E-01 | ○ |
| C-18 | HTTPSからHTTPリダイレクト防止テスト：デフォルトFalse | E-01, E-09 | ○ |
| C-19 | WebSocket WSS対応テスト：wss://プロトコル | E-05, E-09 | ○ |
| C-20 | プロセス最小権限テスト：EProcessAccess | E-04, E-09 | ○ |
| C-21 | レジストリ読み取り専用アクセステスト：PERM_READ | E-06, E-09 | ○ |
| C-22 | JSONパースエラーハンドリングテスト | E-09 | ○ |
| C-23 | Windows 64bit互換性テスト：PtrSafe | E-01, E-02, E-04, E-06, E-08 | ○ |
| C-24 | Windows 32bit互換性テスト：LongPtr列挙型 | E-01, E-02, E-04, E-06, E-08 | ○ |
| C-25 | Mac部分互換性テスト | E-02, E-07 | △ |
| C-26 | Excel VBA互換性テスト：Application.Calculation | E-02, E-03, E-08 | ○ |
| C-27 | Word/PowerPoint互換性テスト：Application.Name分岐 | E-02, E-08 | ○ |
| C-28 | ドキュメントコメント検証テスト：@module等 | E-01, E-02, E-03, E-10 | ○ |
| C-29 | 型宣言検証テスト：ユーザー定義型 | E-01, E-02, E-03, E-04 | ○ |
| C-30 | 定数・列挙型定義テスト：Enum | E-01, E-04, E-06 | ○ |
| C-31 | スタックトレース機能テスト：stdError | E-03, E-08 | △ |
| C-32 | パフォーマンスログ出力テスト：Debug.Print | E-02, E-08 | ○ |
| C-33 | 二重初期化防止テスト：bInitialised | E-01, E-18 | ○ |
| C-34 | 単体テスト実装確認：13クラス | E-11, E-12, E-13, E-14, E-15, E-16 | ○ |
| C-35 | HTTP接続タイムアウトテスト：TimeoutMS/4 | E-01 | ○ |
| C-36 | HTTPリクエスト全体タイムアウトテスト：5000ms | E-01, E-08 | ○ |
| C-37 | ScreenUpdating自動管理テスト | E-03, E-16 | ○ |
| C-38 | EnableEvents自動管理テスト | E-03, E-16 | ○ |
| C-39 | HTTPエラーログ識別テスト：WINHTTP_ERROR | E-01 | ○ |
| C-40 | 大量配列処理性能テスト | **根拠なし** | △ |
| C-41 | 複数タイマー並行実行テスト | E-07, E-08 | △ |
| C-42 | 連続HTTPリクエスト処理テスト | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Mac実環境テスト**：Mac用API宣言は存在するが、実機での動作検証結果なし
  - 候補：Mac版Excel環境でのテスト実施 / GitHub ActionsにMacランナー追加
- **ストレステスト基準**：大量データ処理時の具体的な合格基準（件数、時間）が未定義
  - 候補：ベンチマーク環境の定義 / 許容処理時間の明示
- **stdError完成度**：stdErrorはHOLD（保留）ステータスでスタックトレース機能が未完成
  - 候補：stdErrorの実装完了待ち / stdSentry.CreateErrorStackの動作確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：性能テスト（NFT-PERF-*）- GetTickCount等の実装確認済み
- **0（低リスク）**：セキュリティテスト（NFT-SEC-*）- WinHTTP設定で制御可能
- **1（中リスク）**：可用性テスト（NFT-AVAIL-*）- リソース解放はClass_Terminate依存
- **1（中リスク）**：互換性テスト（NFT-COMPAT-*）- 32bit/64bit対応は条件付きコンパイルで実装
- **2（高リスク）**：Mac互換性 - 実機テストが不足
- **1（中リスク）**：保守性テスト（NFT-MAINT-*）- stdErrorがWIP

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-PERF-001：stdHTTP.clsのTimeoutMSデフォルト値5000が適切か確認
- [ ] NFT-SEC-003：Insecure=Falseがデフォルトでセキュリティ検証が有効か確認
- [ ] NFT-COMPAT-003：Mac環境での動作要件を明確化（一部機能は未対応でOKか）
- [ ] NFT-MAINT-004：stdErrorのステータス（HOLD）でスタックトレーステストが実施可能か確認
- [ ] NFT-STRESS-*：ストレステストの具体的な合格基準を定義
- [ ] 全体：テスト優先度（高/中/低）の妥当性を確認
