---
generated_at: 2026-01-15 20:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **稼働率目標**：具体的な数値目標がコードから特定不可
  2. **Mac対応範囲**：全機能のMac対応状況の網羅的確認が必要
  3. **セマンティックバージョニング準拠**：明示的なバージョン定義ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdHTTP.cls` - HTTP通信クラス
- E-02: `src/stdPerformance.cls` - パフォーマンス計測クラス
- E-03: `src/stdSentry.cls` - リソース管理センチネルクラス
- E-04: `src/stdProcess.cls` - プロセス管理クラス
- E-05: `src/stdWebSocket.cls` - WebSocket通信クラス
- E-06: `src/stdTimer.cls` - タイマー機能クラス
- E-07: `src/stdReg.cls` - レジストリアクセスクラス
- E-08: `src/WIP/stdError.cls` - エラーハンドリングクラス
- E-09: `src/WIP/stdCrypto/stdCrypt.cls` - 暗号化クラス
- E-10: `docs/stdHTTP.md` - HTTP仕様ドキュメント
- E-11: `README.md` - プロジェクト概要
- E-12: `changelog.md` - 変更履歴

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPデフォルトタイムアウト5000ms | E-01 (L322: `TimeoutMS As Long = 5000`) | ○ |
| C-02 | HTTP非同期モード対応 | E-01 (L79-82: `EHTTPSynchronisity` enum) | ○ |
| C-03 | タイムアウトを4分割して適用 | E-01 (L499: `SetTimeouts options("TimeoutMS") / 4`) | ○ |
| C-04 | GetTickCountによるパフォーマンス計測 | E-02 (L40: `Declare PtrSafe Function GetTickCount`) | ○ |
| C-05 | stdSentryによるリソース自動解放 | E-03 (L331-341: `Class_Terminate`でOnDestroy呼出) | ○ |
| C-06 | プロセスハンドルの自動解放 | E-04 (L362-364: `Class_Terminate`で`CloseHandle`呼出) | ○ |
| C-07 | WebSocketイベント対応（Open/Close/Error/Message） | E-05 (L39-55: Public Event宣言) | ○ |
| C-08 | タイマー精度はミリ秒単位で設定可能 | E-06 (L56: `iMilliseconds As Long`) | ○ |
| C-09 | レジストリアクセス権限の明示的指定 | E-07 (L100-113: `ERegistryAccess` enum) | ○ |
| C-10 | スタックトレース機能 | E-08 (L129-142: `GetTrace`関数) | ○ |
| C-11 | CryptProtectData APIによる暗号化 | E-09 (L23-24: API宣言) | ○ |
| C-12 | Basic認証対応 | E-01 (L30-43: HttpBasicAuthenticatorサンプル) | ○ |
| C-13 | プロキシ認証対応 | E-01 (L106-108: `SetCredentialsType.ForProxy`) | ○ |
| C-14 | Authenticatorコールバック拡張 | E-01 (L287, L536) | ○ |
| C-15 | SSL証明書検証制御（Insecureオプション） | E-01 (L516-524: `SslErrorIgnoreFlags`設定) | ○ |
| C-16 | WINHTTP_ERRORによるエラーハンドリング | E-01 (L117-170: エラーコードenum) | ○ |
| C-17 | ファクトリパターンのCreate関数 | E-01, E-02, E-03, E-04, E-05 (各クラスのCreate関数) | ○ |
| C-18 | stdICallableインターフェース | E-03 (L85: `Implements stdICallable`) | ○ |
| C-19 | 64bit互換（PtrSafe宣言） | E-01 (L196), E-02 (L39), E-04 (L36) | ○ |
| C-20 | Mac対応API宣言 | E-02 (L33-37: Mac用GetTickCount宣言) | ○ |
| C-21 | VBA7条件付きコンパイル | E-01 (L195), E-04 (L35) | ○ |
| C-22 | ドキュメントコメント（@module等） | E-01 (L11-77), E-02 (L11-29) | ○ |
| C-23 | Enum列挙型定義 | E-01 (L79-96), E-04 (L176-202), E-07 (L80-121) | ○ |
| C-24 | DEBUG_MODEコンパイル定数 | E-06 (L42: `#Const DEBUG_MODE = False`) | ○ |
| C-25 | パフォーマンス計測結果のDebug.Print出力 | E-02 (L215: `Debug.Print sKey & ": " & time & " ms"`) | ○ |
| C-26 | Protected（prot）メソッド規則 | E-01 (L489: `protInit`), E-04 (L351: `protInitFromProcessId`) | ○ |
| C-27 | シングルトンパターン | E-02 (L260-263: `Me Is stdPerformance`判定) | ○ |
| C-28 | 初期化フラグ（bInitialised） | E-11 (L200-222: README内のコード例) | ○ |
| C-29 | WinHTTP.dll依存 | E-01 (L200-237: WinHTTP API宣言) | ○ |
| C-30 | kernel32.dll依存 | E-02 (L40: GetTickCount), E-04 (L36-101) | ○ |
| C-31 | advapi32.dll依存 | E-07 (L132-148: Registry API宣言) | ○ |
| C-32 | Crypt32.dll依存 | E-09 (L23-24) | ○ |
| C-33 | oleaut32.dll依存 | E-01 (L197-198: SysAllocString等) | ○ |
| C-34 | WebSocket IE依存 | E-05 (L80: `CreateObject("InternetExplorer.Application")`) | ○ |
| C-35 | VBOMタイマー要件 | E-06 (L67-71: `setVBOM`呼出) | ○ |
| C-36 | タイマーデバッグ制限 | E-06 (L25-26: コメントで明記) | ○ |
| C-37 | CreateOptimiserによるApplication設定管理 | E-03 (L135-163) | ○ |
| C-38 | プロキシ自動検出 | E-01 (L626-643: `LoadAutoProxy`関数) | ○ |
| C-39 | HTTPリダイレクト制御 | E-01 (L525: `EnableRedirects`オプション) | ○ |
| C-40 | レジストリハンドル自動解放 | E-07 (L573-575: `Class_Terminate`で`RegCloseKey`) | ○ |
| C-41 | URIエンコード/デコード | E-01 (L566-603) | ○ |
| C-42 | プロセス優先度管理 | E-04 (L176-183: `EProcessPriority` enum) | ○ |
| C-43 | 稼働率目標（ホスト依存） | **根拠なし** | △ |
| C-44 | セマンティックバージョニング準拠 | **根拠なし** | △ |
| C-45 | 全Mac対応機能範囲 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-43 稼働率目標**: VBAライブラリとしての特性上、稼働率はホストアプリケーション依存となるが、明示的な記載がない
  - 候補：テスト自動化の整備 / 継続的インテグレーション / 品質保証プロセスの文書化
- **C-44 バージョン管理**: `changelog.md`は存在するが、セマンティックバージョニングへの準拠は明示されていない
  - 候補：package.json相当の設定ファイル / バージョン定義ファイル / リリースノートの形式化
- **C-45 Mac対応範囲**: 一部のクラスにMac用条件付きコンパイルが確認できるが、全機能の網羅的な対応状況は不明
  - 候補：Mac互換性マトリクス / プラットフォーム別テスト結果 / 互換性ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 性能要件 - タイムアウト値やパフォーマンス計測はコードから明確に確認可能
- **0（低リスク）**: セキュリティ要件 - SSL/TLS設定、認証機構はコードに実装が確認できる
- **1（中リスク）**: 拡張性要件 - Mac対応範囲の網羅性確認が必要
- **0（低リスク）**: 保守性要件 - コード規約、デバッグ機能はソースコードから確認可能
- **1（中リスク）**: バージョン管理 - 明示的なバージョニングポリシーの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPタイムアウト設定がアプリケーション要件を満たしているか確認
- [ ] Mac環境での動作要件がある場合、対応機能の範囲を確認
- [ ] セキュリティ要件（Insecureオプション使用時の影響）を理解しているか確認
- [ ] VBOMの有効化がセキュリティポリシーと矛盾しないか確認（タイマー機能使用時）
- [ ] 依存DLLが対象環境で利用可能か確認
- [ ] WebSocketのIE依存が将来的な課題となる可能性を認識
