# 非機能要件定義書

## 概要

本ドキュメントは、stdVBAライブラリの非機能要件を定義するものである。stdVBAは、VBAアプリケーション開発のための汎用ライブラリ群であり、JavaScript APIに影響を受けた現代的なプログラミングパターンを提供する。本ドキュメントでは、ライブラリの性能、可用性、セキュリティ、拡張性、保守性、および運用・監視に関する要件を明記する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| HTTP同期リクエスト | デフォルト5000ms以内 | `TimeoutMS`オプションにて設定可能（stdHTTP.CreateOptions） |
| HTTP非同期リクエスト | 処理継続可能 | `HTTPAsync`モードで非ブロッキング処理 |
| プロセス検索（CreateFromQuery） | ミリ秒単位 | Kernel32 APIによる高速スナップショット |
| パフォーマンス計測 | ミリ秒精度 | GetTickCount APIを使用 |
| タイマー精度 | 設定ミリ秒 | ユーザー指定の間隔でTickイベント発火 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時HTTP接続数 | OS/WinHTTPの制限に依存 | WinHttpRequest.5.1使用 |
| プロセス同時監視数 | 制限なし | メモリ依存 |
| タイマー並行実行 | 複数インスタンス可能 | 各インスタンスが独自のExcelアプリケーションを使用 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | ホストアプリケーション依存 | Excel/Word/PowerPoint等のVBAホストに依存 |
| 計画停止時間 | 適用なし | ライブラリとして動作 |
| 障害復旧時間（RTO） | 適用なし | ステートレスなライブラリ設計 |
| 目標復旧時点（RPO） | 適用なし | 永続化機能なし |

### 冗長構成

- **エラーハンドリング**: `stdError`クラスによるスタックトレース機能とカスタムエラークライアントの設定が可能
- **プロキシフォールバック**: stdHTTPにおいて自動プロキシ検出失敗時のフォールバック機構を実装
- **リソース解放**: `stdSentry`パターンによる確実なリソース解放（センチネルパターン）

## セキュリティ要件

### 認証・認可

| 項目 | 対応状況 | 実装詳細 |
| --- | --- | --- |
| HTTP Basic認証 | 対応 | `SetCredentials`メソッドによる実装 |
| Windows認証 | 対応 | プロキシ認証に対応 |
| カスタム認証 | 対応 | `Authenticator`コールバックにより拡張可能 |

### 通信セキュリティ

| 項目 | 対応状況 | 備考 |
| --- | --- | --- |
| HTTPS | 対応 | デフォルトで有効 |
| 証明書検証 | 設定可能 | `Insecure`オプションでバイパス可能 |
| SSL/TLSエラー処理 | 対応 | WINHTTP_ERRORによる詳細なエラーハンドリング |

### データ保護

| 項目 | 対応状況 | 実装詳細 |
| --- | --- | --- |
| データ暗号化 | 部分対応（WIP） | `stdCrypt`クラスにてCryptProtectData API使用 |
| レジストリアクセス制御 | 対応 | `stdReg`にてアクセス権限（PERM_READ, PERM_WRITE等）を明示的に指定 |
| プロセス権限管理 | 対応 | `EProcessAccess`列挙型による最小権限原則 |

### セキュリティ設定

- `stdHTTP.CreateOptions`の`Insecure`オプション（デフォルト: `False`）により、SSL証明書の検証を制御
- プロキシ認証情報は`CreateProxy`メソッドで安全に設定
- WebSocketは`wss://`（セキュア）プロトコルをサポート

## 拡張性要件

### アーキテクチャ設計

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| ファクトリパターン | 対応 | 全クラスで`Create`コンストラクタを使用 |
| コールバック機構 | 対応 | `stdICallable`インターフェースによる統一的なコールバック |
| ラムダ式 | 対応 | `stdLambda`によるインライン関数定義 |
| イベントドリブン | 対応 | WebSocket、Timer等でイベント発火 |

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
| --- | --- | --- |
| Windows 32bit | 対応 | Win32 API宣言を含む |
| Windows 64bit | 対応 | `PtrSafe`宣言による64bit互換 |
| Mac | 部分対応 | 一部機能はMac用API宣言を含む |
| VBA7 | 対応 | 条件付きコンパイルで対応 |

### モジュール設計

- プレフィックス規則: `std`（汎用）、`xl`/`wd`/`pp`/`ax`（アプリケーション固有）
- 各モジュールは独立して使用可能
- `stdEnumerator`による統一的なイテレーション

## 保守性要件

### コード品質

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| ドキュメントコメント | 対応 | `@module`, `@description`, `@example`タグを使用 |
| 型宣言 | 対応 | ユーザー定義型（Type）を活用 |
| 定数定義 | 対応 | `Enum`による列挙型定義 |
| エラーコード体系 | 対応 | WINHTTP_ERROR等の標準エラーコード |

### デバッグ・テスト

| 項目 | 対応状況 | 実装詳細 |
| --- | --- | --- |
| パフォーマンス計測 | 対応 | `stdPerformance.CreateMeasure`によるブロック計測 |
| スタックトレース | 対応 | `stdError`によるコールスタック管理 |
| 単体テスト | 部分対応 | `tests`ディレクトリにテストモジュール配置 |
| デバッグモード | 対応 | `#Const DEBUG_MODE`による切り替え |

### コード構造

- **Protected メソッド**: `prot`プレフィックスにより内部APIを明示
- **シングルトンパターン**: 静的クラスとインスタンスの使い分け
- **初期化制御**: `bInitialised`フラグによる二重初期化防止

## 運用・監視要件

### ロギング

| 項目 | 対応状況 | 実装詳細 |
| --- | --- | --- |
| パフォーマンスログ | 対応 | `stdPerformance.AddMeasurement`でDebug.Print出力 |
| エラーログ | 対応 | `stdError.Raise`による構造化エラー表示 |
| HTTPエラーログ | 対応 | WINHTTP_ERRORコードによるエラー識別 |

### リソース管理

| リソース種別 | 解放方法 | 備考 |
| --- | --- | --- |
| プロセスハンドル | `Class_Terminate` | `CloseHandle`による自動解放 |
| レジストリハンドル | `Class_Terminate` | `RegCloseKey`による自動解放 |
| HTTPセッション | 自動管理 | `WinHttpCloseHandle`による解放 |
| WebSocket接続 | `Disconnect`メソッド | IEオブジェクトの明示的解放 |

### タイムアウト設定

| 項目 | デフォルト値 | 設定方法 |
| --- | --- | --- |
| HTTP接続タイムアウト | TimeoutMS/4 | CreateOptionsで指定 |
| HTTPリクエストタイムアウト | TimeoutMS/4 | CreateOptionsで指定 |
| HTTPレスポンスタイムアウト | TimeoutMS/4 | CreateOptionsで指定 |
| HTTP全体タイムアウト | 5000ms | CreateOptionsのTimeoutMS引数 |

### 最適化設定

- **Application設定の自動管理**: `stdSentry.CreateOptimiser`により`ScreenUpdating`、`EnableEvents`、`Calculation`を一時的に変更し、処理完了後に自動復元
- **パフォーマンス計測と最適化**: `stdPerformance`による計測とDebug.Print出力

## 備考

### 制限事項

1. **タイマー精度**: VBAの制約により、デバッグモードではタイマーイベントが発火しない
2. **Mac互換性**: 一部のWin32 API機能はMacでは利用不可
3. **WebSocket**: 現在Internet Explorer依存（今後Chrome等への移行を検討）
4. **VBE Object Model**: タイマー機能使用時にVBOM拡張の有効化が必要

### 依存関係

| ライブラリ | 用途 | 必須/任意 |
| --- | --- | --- |
| WinHTTP.dll | HTTP通信 | 必須（Windows） |
| kernel32.dll | システムAPI | 必須（Windows） |
| advapi32.dll | レジストリアクセス | 必須（Windows） |
| Crypt32.dll | データ暗号化 | 任意 |
| oleaut32.dll | COM/OLE操作 | 必須 |

### バージョン管理

- セマンティックバージョニングに準拠
- 変更履歴は`changelog.md`で管理
- GitHub Projectsによるロードマップ管理
