# API設計書

## 概要

本ドキュメントは、Symfony 8.1 フレームワーク本体が提供する内部HTTPエンドポイント（ルーティング定義）のAPI設計書です。Symfonyフレームワークは、アプリケーション開発者が独自のAPIを構築するための基盤を提供するものであり、フレームワーク自体が公開するエンドポイントは主に開発支援・デバッグ用途（Web Profiler / Web Debug Toolbar）、エラープレビュー、およびWebhook受信の3カテゴリに限定されます。

## 共通仕様

### ベースURL

```
各エンドポイントのベースURLはSymfonyアプリケーションの設定に依存します。
- Profiler: /_profiler（デフォルトプレフィックス）
- Web Debug Toolbar: /_wdt（デフォルトプレフィックス）
- Error Preview: /_error（デフォルトプレフィックス）
- Webhook: /_webhook（デフォルトプレフィックス、設定依存）
```

### 認証方式

フレームワーク内部エンドポイントは、基本的にSymfonyのファイアウォール設定に依存します。開発環境（dev）では認証なしでアクセス可能な構成が一般的です。本番環境ではProfiler/WDTルートは通常無効化されます。

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Content-Type | - | レスポンスに応じてtext/html, text/css, font/woff2等が返却される |
| Accept | - | 特に指定なし（HTMLレスポンスが主） |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 302 | Found - リダイレクト |
| 404 | Not Found - プロファイラー無効時、トークン未検出時、リソース未検出時 |
| 410 | Gone - 恒久的なリダイレクト先が空の場合 |
| 500 | Internal Server Error - サーバーエラー |

## API一覧

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Profiler | /_profiler/ | GET | プロファイラーホーム（検索結果へリダイレクト） |
| Profiler | /_profiler/search | GET | プロファイル検索 |
| Profiler | /_profiler/search_bar | GET | 検索バー表示 |
| Profiler | /_profiler/phpinfo | GET | PHP情報表示 |
| Profiler | /_profiler/xdebug | GET | Xdebug情報表示 |
| Profiler | /_profiler/font/{fontName}.woff2 | GET | カスタムフォント取得 |
| Profiler | /_profiler/{token}/search/results | GET | 検索結果表示 |
| Profiler | /_profiler/open | GET | ソースファイル表示 |
| Profiler | /_profiler/{token} | GET | プロファイラーパネル表示 |
| Profiler | /_profiler/{token}/router | GET | ルーティングトレース表示 |
| Profiler | /_profiler/{token}/exception | GET | 例外パネル（スタックトレース）表示 |
| Profiler | /_profiler/{token}/exception.css | GET | 例外パネルスタイルシート |
| WDT | /_wdt/styles | GET | ツールバースタイルシート |
| WDT | /_wdt/{token} | GET | Web Debug Toolbar表示 |
| Error Preview | /_error/{code}.{_format} | GET | エラーページプレビュー |
| Webhook | /_webhook/{type} | POST | Webhook受信 |

## 各APIエンドポイント定義

### Profiler

#### 1 プロファイラーホーム

プロファイラーのホームページ。直近のプロファイル検索結果ページへリダイレクトします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/` |
| ルート名 | `_profiler_home` |
| コントローラー | `ProfilerController::homeAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

なし

**クエリパラメータ**

なし

**レスポンス（成功時）**

ステータスコード: `302 Found`

リダイレクト先: `/_profiler/{token}/search/results?limit=10&token=empty`

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（プロファイラーが無効の場合）

---

#### 2 プロファイル検索

セッションに検索条件を保存し、トークン指定時はプロファイラーパネルへ、それ以外は検索結果へリダイレクトします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/search` |
| ルート名 | `_profiler_search` |
| コントローラー | `ProfilerController::searchAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| ip | string | - | null | IPアドレスフィルタ |
| method | string | - | null | HTTPメソッドフィルタ |
| status_code | string | - | null | ステータスコードフィルタ |
| url | string | - | null | URLフィルタ |
| start | string | - | null | 開始日時フィルタ |
| end | string | - | null | 終了日時フィルタ |
| limit | string | - | null | 取得件数上限 |
| token | string | - | null | 特定トークン検索 |
| type | string | - | "request" | プロファイルタイプ |

**レスポンス（成功時）**

ステータスコード: `302 Found`

- トークン指定時: `/_profiler/{token}` へリダイレクト
- トークン未指定時: `/_profiler/{token}/search/results` へリダイレクト（検索結果の先頭トークン）

---

#### 3 検索バー表示

プロファイラーの検索バーUIをHTMLで返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/search_bar` |
| ルート名 | `_profiler_search_bar` |
| コントローラー | `ProfilerController::searchBarAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| token | string | - | セッション値 | トークン |
| ip | string | - | セッション値 | IPアドレス |
| method | string | - | セッション値 | HTTPメソッド |
| status_code | string | - | セッション値 | ステータスコード |
| url | string | - | セッション値 | URL |
| start | string | - | セッション値 | 開始日時 |
| end | string | - | セッション値 | 終了日時 |
| limit | string | - | セッション値 | 取得件数上限 |
| type | string | - | セッション値（デフォルト: "request"） | プロファイルタイプ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

HTML形式の検索バーUI

---

#### 4 PHP情報表示

PHPの設定情報（phpinfo()の出力）を表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/phpinfo` |
| ルート名 | `_profiler_phpinfo` |
| コントローラー | `ProfilerController::phpinfoAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

phpinfo()の出力HTML

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（プロファイラーが無効の場合）

---

#### 5 Xdebug情報表示

Xdebugの設定情報（xdebug_info()の出力）を表示します。Xdebug 3以降が必要です。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/xdebug` |
| ルート名 | `_profiler_xdebug` |
| コントローラー | `ProfilerController::xdebugAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

xdebug_info()の出力HTML

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（プロファイラー無効時、またはXdebug未インストール時）

---

#### 6 カスタムフォント取得

プロファイラーで使用するカスタムWebフォント（woff2形式）を返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/font/{fontName}.woff2` |
| ルート名 | `_profiler_font` |
| コントローラー | `ProfilerController::fontAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| fontName | string | ○ | フォント名（現在は "JetBrainsMono" のみ対応） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `font/woff2`

woff2形式のフォントファイルデータ（BinaryFileResponse）

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（未対応フォント名、またはファイル読み取り不可）

---

#### 7 検索結果表示

指定されたトークンおよびフィルタ条件に基づいてプロファイル検索結果を表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/{token}/search/results` |
| ルート名 | `_profiler_search_results` |
| コントローラー | `ProfilerController::searchResultsAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| token | string | ○ | プロファイルトークン |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| ip | string | - | null | IPアドレスフィルタ |
| method | string | - | null | HTTPメソッドフィルタ |
| status_code | string | - | null | ステータスコードフィルタ |
| url | string | - | null | URLフィルタ |
| start | string | - | null | 開始日時フィルタ |
| end | string | - | null | 終了日時フィルタ |
| limit | string | - | null | 取得件数上限 |
| type | string | - | "request" | プロファイルタイプ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

検索結果一覧のHTML

---

#### 8 ソースファイル表示

指定されたファイルのソースコードをHTML形式で表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/open` |
| ルート名 | `_profiler_open_file` |
| コントローラー | `ProfilerController::openAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| file | string | ○ | - | 表示するファイルの相対パス（baseDir基準） |
| line | string | - | null | ハイライトする行番号 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

ソースコード表示HTML

**レスポンス（エラー時）**

- ステータスコード: `404 Not Found`
  - baseDirが未設定の場合
  - パスに `..` が含まれる場合やファイルが読み取り不可の場合

---

#### 9 プロファイラーパネル表示

指定されたトークンのプロファイリングデータをパネル形式で表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/{token}` |
| ルート名 | `_profiler` |
| コントローラー | `ProfilerController::panelAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| token | string | ○ | プロファイルトークン（"latest" を指定すると直近のプロファイルを表示） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| panel | string | - | null（自動判定） | 表示するパネル名 |
| page | string | - | "home" | ページ名 |
| type | string | - | "request" | プロファイルタイプ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

プロファイラーパネルのHTML

**レスポンス（エラー時）**

- ステータスコード: `404 Not Found`（プロファイラー無効時、指定パネルが存在しない場合）

---

#### 10 ルーティングトレース表示

指定されたトークンのリクエストに対するルーティングマッチングのトレース情報を表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/{token}/router` |
| ルート名 | `_profiler_router` |
| コントローラー | `RouterController::panelAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| token | string | ○ | プロファイルトークン |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

ルーティングトレースのHTML

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（プロファイラー無効時）

---

#### 11 例外パネル（スタックトレース）表示

指定されたトークンのプロファイルに含まれる例外のスタックトレースをHTML形式で返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/{token}/exception` |
| ルート名 | `_profiler_exception` |
| コントローラー | `ExceptionPanelController::body` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| token | string | ○ | プロファイルトークン |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

例外スタックトレースのHTML

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（プロファイラー無効時）

---

#### 12 例外パネルスタイルシート

例外パネル用のCSSスタイルシートを返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_profiler/{token}/exception.css` |
| ルート名 | `_profiler_exception_css` |
| コントローラー | `ExceptionPanelController::stylesheet` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| token | string | ○ | プロファイルトークン（ルーティング上必要だがコントローラーでは未使用） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/css`

CSSスタイルシート

---

### Web Debug Toolbar (WDT)

#### 13 ツールバースタイルシート

Web Debug Toolbar用のCSSスタイルシートを返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_wdt/styles` |
| ルート名 | `_wdt_stylesheet` |
| コントローラー | `ProfilerController::toolbarStylesheetAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/css`

Cache-Control: `max-age=600, private`

ツールバー用CSSスタイルシート

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`（プロファイラー無効時）

---

#### 14 Web Debug Toolbar表示

指定されたトークンのプロファイリングデータに基づいてWeb Debug Toolbarをレンダリングします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_wdt/{token}` |
| ルート名 | `_wdt` |
| コントローラー | `ProfilerController::toolbarAction` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| token | string | - | プロファイルトークン（"empty"またはnullの場合は空レスポンス） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/html`

Web Debug ToolbarのHTML

**レスポンス（エラー時）**

- ステータスコード: `200 OK` - 空HTML（トークンが"empty"またはnullの場合）
- ステータスコード: `404 Not Found` - プロファイラー無効時またはプロファイル読み込み不可時

---

### Error Preview

#### 15 エラーページプレビュー

指定されたHTTPステータスコードのエラーページをプレビュー表示します。開発環境でエラーページのカスタマイズを確認するために使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /_error/{code}.{_format}` |
| ルート名 | `_preview_error` |
| コントローラー | `ErrorController::preview` |
| 認証 | 不要（開発環境のみ有効） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| code | integer | ○ | HTTPステータスコード（数値のみ、正規表現: `\d+`） |
| _format | string | - | レスポンスフォーマット（デフォルト: "html"） |

**レスポンス（成功時）**

ステータスコードおよびContent-Typeは指定されたcode, _formatに依存

サンプル例外メッセージ "This is a sample exception." を含むエラーページHTML

---

### Webhook

#### 16 Webhook受信

サードパーティプロバイダーからのWebhookペイロードを受信し、パースしてメッセージバスにディスパッチします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /_webhook/{type}` |
| ルート名 | `_webhook_controller` |
| コントローラー | `WebhookController::handle` |
| 認証 | プロバイダー固有のシークレットによる検証（RequestParser内で実施） |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| type | string | ○ | Webhookタイプ識別子（正規表現: `.+`） |

**レスポンス（成功時）**

レスポンスはRequestParserの実装に依存（`createSuccessfulResponse`メソッド）

一般的には:

ステータスコード: `200 OK`

Content-Type: `text/plain`

**レスポンス（エラー時）**

- ステータスコード: `404 Not Found` - 指定タイプに対応するパーサーが見つからない場合

```
No webhook parser found for the type given in the URL.
```

- パース失敗時: RequestParserの実装に依存（`createRejectedResponse`メソッド）

---

### FrameworkBundle ユーティリティコントローラー

以下のコントローラーはルーティング定義ファイルに直接定義されておらず、アプリケーション開発者がルーティング設定で参照することで利用するユーティリティです。

#### 17 リダイレクトコントローラー（ルート名指定）

指定されたルート名に対してリダイレクトを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コントローラー | `RedirectController::redirectAction` |
| 認証 | ルーティング設定依存 |
| 権限 | ルーティング設定依存 |

**リクエストパラメータ（ルーティング設定で指定）**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| route | string | ○ | - | リダイレクト先ルート名 |
| permanent | bool | - | false | 恒久リダイレクト（301/308）かどうか |
| ignoreAttributes | bool/array | - | false | 無視するルート属性 |
| keepRequestMethod | bool | - | false | HTTPメソッドを維持するか（307/308） |
| keepQueryParams | bool | - | false | クエリパラメータを引き継ぐか |

**レスポンス**

- 通常: `302 Found` リダイレクト
- `permanent=true`: `301 Moved Permanently` リダイレクト
- `keepRequestMethod=true`: `307 Temporary Redirect`
- `permanent=true, keepRequestMethod=true`: `308 Permanent Redirect`

---

#### 18 リダイレクトコントローラー（URL指定）

指定されたURLパスに対してリダイレクトを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コントローラー | `RedirectController::urlRedirectAction` |
| 認証 | ルーティング設定依存 |
| 権限 | ルーティング設定依存 |

**リクエストパラメータ（ルーティング設定で指定）**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| path | string | ○ | - | リダイレクト先のパスまたはURL |
| permanent | bool | - | false | 恒久リダイレクト（301/308）かどうか |
| scheme | string | - | null（リクエストのスキームを使用） | URLスキーム |
| httpPort | int | - | null | HTTPポート番号 |
| httpsPort | int | - | null | HTTPSポート番号 |
| keepRequestMethod | bool | - | false | HTTPメソッドを維持するか（307/308） |

**レスポンス**

- 通常: `302 Found` リダイレクト
- `permanent=true`: `301 Moved Permanently` リダイレクト
- `keepRequestMethod=true`: `307 Temporary Redirect`
- `permanent=true, keepRequestMethod=true`: `308 Permanent Redirect`

---

#### 19 テンプレートコントローラー

指定されたTwigテンプレートをレンダリングして返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コントローラー | `TemplateController::templateAction` |
| 認証 | ルーティング設定依存 |
| 権限 | ルーティング設定依存 |

**リクエストパラメータ（ルーティング設定で指定）**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| template | string | ○ | - | テンプレート名 |
| maxAge | int | - | null | クライアントキャッシュのmax-age（秒） |
| sharedAge | int | - | null | 共有キャッシュのs-maxage（秒） |
| private | bool | - | null | プライベートキャッシュにするか |
| context | array | - | [] | テンプレート変数 |
| statusCode | int | - | 200 | HTTPステータスコード |
| headers | array | - | [] | 追加HTTPヘッダー |

**レスポンス（成功時）**

ステータスコード: `200 OK`（またはstatusCodeで指定した値）

Content-Type: `text/html`（またはheadersで指定した値）

レンダリングされたテンプレートHTML

## 備考

- 本ドキュメントが対象とするのはSymfony 8.1フレームワーク本体が提供する内部エンドポイントです。アプリケーション開発者が独自に定義するAPIエンドポイントは含まれていません。
- Profiler/WDT関連のエンドポイントは、`WebProfilerBundle` が有効な環境（通常はdev環境）でのみ利用可能です。本番環境では無効化されることが推奨されます。
- Webhookエンドポイントのベースパスは `framework.webhook.routing` 設定で変更可能です。
- エラープレビューのベースパスは `framework.error_controller` 設定およびルーティングインポートのプレフィックスで変更可能です。
- RedirectController, TemplateControllerはアプリケーションのルーティング設定で任意のパスにマッピングして利用する汎用コントローラーであり、固定のエンドポイントパスは持ちません。
- 全てのProfilerコントローラーは `@internal` マークされており、フレームワーク内部APIです。外部からの安定的なAPI利用は保証されません。
