---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 38
  claims_with_evidence: 36
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：36 / 38、根拠なし：2
- 優先レビュー（高）
  1. **Webhookエンドポイントの認証方式の詳細**：RequestParserの実装に依存するため、具体的な認証フローは個別のパーサー実装を確認する必要がある
  2. **各エンドポイントのベースURLプレフィックス**：デフォルト値はSymfonyの慣例に基づくが、アプリケーション設定で変更可能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` - プロファイラーのルーティング定義
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` - WDTのルーティング定義
- E-03: `src/Symfony/Bundle/FrameworkBundle/Resources/config/routing/errors.php` - エラープレビューのルーティング定義
- E-04: `src/Symfony/Bundle/FrameworkBundle/Resources/config/routing/webhook.php` - Webhookのルーティング定義
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` - プロファイラーコントローラー実装
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` - ルーターコントローラー実装
- E-07: `src/Symfony/Bundle/WebProfilerBundle/Controller/ExceptionPanelController.php` - 例外パネルコントローラー実装
- E-08: `src/Symfony/Component/Webhook/Controller/WebhookController.php` - Webhookコントローラー実装
- E-09: `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php` - リダイレクトコントローラー実装
- E-10: `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` - テンプレートコントローラー実装
- E-11: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` - エラーコントローラー実装
- E-12: `src/Symfony/Component/Routing/Attribute/Route.php` - Routeアトリビュート定義
- E-13: `src/Symfony/Bundle/FrameworkBundle/Resources/config/routing.php` - ルーティングサービス設定
- E-14: `src/Symfony/Bundle/FrameworkBundle/Controller/AbstractController.php` - 抽象コントローラー基底クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロファイラーホーム(/_profiler/)は検索結果へ302リダイレクトする | E-01, E-05 (homeAction: line 53-57) | ○ |
| C-02 | プロファイル検索(/_profiler/search)はセッションに検索条件を保存する | E-01, E-05 (searchAction: line 264-309) | ○ |
| C-03 | 検索バー(/_profiler/search_bar)はHTML形式の検索バーUIを返す | E-01, E-05 (searchBarAction: line 191-218) | ○ |
| C-04 | PHP情報(/_profiler/phpinfo)はphpinfo()の出力を返す | E-01, E-05 (phpinfoAction: line 316-327) | ○ |
| C-05 | Xdebug情報(/_profiler/xdebug)はxdebug_info()の出力を返す | E-01, E-05 (xdebugAction: line 334-349) | ○ |
| C-06 | フォント取得(/_profiler/font/{fontName}.woff2)はJetBrainsMonoのみ対応 | E-01, E-05 (fontAction: line 356-371) | ○ |
| C-07 | 検索結果(/_profiler/{token}/search/results)はフィルタ条件付きの検索結果を表示 | E-01, E-05 (searchResultsAction: line 225-257) | ○ |
| C-08 | ソースファイル表示(/_profiler/open)はfile, lineパラメータを受け取る | E-01, E-05 (openAction: line 378-400) | ○ |
| C-09 | パネル表示(/_profiler/{token})はtoken, panel, page, typeパラメータを受け取る | E-01, E-05 (panelAction: line 65-117) | ○ |
| C-10 | "latest"トークン指定で直近のプロファイルを表示する | E-05 (panelAction: line 75-77) | ○ |
| C-11 | ルーティングトレース(/_profiler/{token}/router)はTraceableUrlMatcherを使用する | E-01, E-06 (panelAction, getTraces) | ○ |
| C-12 | 例外パネル(/_profiler/{token}/exception)はスタックトレースHTMLを返す | E-01, E-07 (body: line 37-48) | ○ |
| C-13 | 例外パネルCSS(/_profiler/{token}/exception.css)はCSSを返す | E-01, E-07 (stylesheet: line 54-57) | ○ |
| C-14 | WDTスタイルシート(/_wdt/styles)はCSS形式でCache-Control: max-age=600を返す | E-02, E-05 (toolbarStylesheetAction: line 170-184) | ○ |
| C-15 | WDTツールバー(/_wdt/{token})はプロファイルデータに基づきツールバーHTMLを返す | E-02, E-05 (toolbarAction: line 124-163) | ○ |
| C-16 | WDTでtokenがemptyまたはnullの場合は空のHTMLを返す | E-05 (toolbarAction: line 137-139) | ○ |
| C-17 | エラープレビュー(/_error/{code}.{_format})はcode要件が\d+ | E-03 (requirements: ['code' => '\d+']) | ○ |
| C-18 | エラープレビューのデフォルトフォーマットはhtml | E-03 (defaults: ['_format' => 'html']) | ○ |
| C-19 | ErrorController::previewはサンプル例外メッセージを使用する | E-11 (preview: line 42-56, "This is a sample exception.") | ○ |
| C-20 | Webhook(/_webhook/{type})はtype要件が.+ | E-04 (requirements: ['type' => '.+']) | ○ |
| C-21 | WebhookControllerは未知のtypeに対して404を返す | E-08 (handle: line 38-39) | ○ |
| C-22 | WebhookControllerはパース成功時にConsumeRemoteEventMessageをバスにディスパッチ | E-08 (handle: line 51-52) | ○ |
| C-23 | WebhookControllerは複数イベントの配列をサポートする | E-08 (handle: line 49) | ○ |
| C-24 | RedirectController::redirectActionは302/301/307/308ステータスコードを返す | E-09 (redirectAction: line 79-83) | ○ |
| C-25 | RedirectController::urlRedirectActionはscheme, port, pathに基づくURL構築を行う | E-09 (urlRedirectAction: line 106-167) | ○ |
| C-26 | RedirectController::__invokeはroute/path両方指定時にRuntimeExceptionを投げる | E-09 (__invoke: line 173-175) | ○ |
| C-27 | TemplateControllerはTwigテンプレートをレンダリングして返す | E-10 (templateAction: line 42-69) | ○ |
| C-28 | TemplateControllerはmaxAge, sharedAge, privateのキャッシュ制御をサポート | E-10 (templateAction: line 50-62) | ○ |
| C-29 | TemplateControllerはstatusCode, headersパラメータをサポート | E-10 (templateAction: line 42, 64-66) | ○ |
| C-30 | プロファイラー無効時は全ProfilerControllerアクションが404を投げる | E-05 (denyAccessIfProfilerDisabled: line 410-417) | ○ |
| C-31 | openActionはbaseDirが未設定の場合404を返す | E-05 (openAction: line 380-381) | ○ |
| C-32 | openActionはパスに'.'が含まれる場合404を返す | E-05 (openAction: line 391-393) | ○ |
| C-33 | searchBarActionはセッションからデフォルト値を取得する | E-05 (searchBarAction: line 197-214) | ○ |
| C-34 | ProfilerController, RouterController, ExceptionPanelControllerは@internalマークされている | E-05 (line 33), E-06 (line 30), E-07 (line 25) | ○ |
| C-35 | RedirectController, TemplateControllerはルーティングサービスとして登録されている | E-13 (line 195-209) | ○ |
| C-36 | WebhookControllerも@internalマークされている | E-08 (line 25-26) | ○ |
| C-37 | Webhookの認証はRequestParser内でシークレットベースで行われる | **根拠不足** | △ |
| C-38 | Profiler/WDTのベースURLはデフォルトで/_profiler, /_wdtである | **根拠不足（慣例に基づく推定）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-37: WebhookController自体は`$this->parsers[$type]['secret']`をパーサーに渡しているが、具体的な認証フローはRequestParserInterface実装に依存する。各プロバイダー（Stripe, GitHub等）のRequestParser実装を確認する必要がある。
  - 候補：各Webhook RequestParser実装 / Symfony Webhook Componentドキュメント / サードパーティプロバイダーのWebhook仕様
- C-38: /_profiler, /_wdtプレフィックスはSymfonyのWebProfilerBundleルーティング設定インポート時にアプリケーション側で指定される。フレームワーク本体のルーティング定義ファイル自体にはプレフィックスは含まれていない（ルート定義は相対パス）。
  - 候補：Symfonyドキュメント / WebProfilerBundleの設定ドキュメント / アプリケーション側のroutes.yaml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Profiler/WDTエンドポイントの定義（ルーティングファイルとコントローラーから直接読み取り可能）
- 0: 低リスク - ErrorController/RedirectController/TemplateControllerの仕様（ソースコードから直接確認済み）
- 1: 中リスク - WebhookControllerの認証方式の記述（RequestParserの具体実装に依存するため、一般化した記載となっている）
- 1: 中リスク - ベースURLプレフィックスの記載（アプリケーション設定依存であり、デフォルト値はSymfonyの慣例に基づく推定）
- 0: 低リスク - 各エンドポイントのHTTPメソッド（ルーティング定義に明示的な制約がない場合はGET/POST等全メソッドが許可される可能性がある）

## 6) レビュアーチェックリスト（最小）
- [ ] Profiler関連の全12エンドポイントが正しくルーティング定義ファイル（profiler.php）と一致しているか
- [ ] WDT関連の2エンドポイントがルーティング定義ファイル（wdt.php）と一致しているか
- [ ] WebhookControllerのレスポンス仕様がRequestParser実装と整合しているか
- [ ] RedirectControllerのステータスコード分岐（permanent/keepRequestMethodの組み合わせ）が正確か
- [ ] TemplateControllerのキャッシュ制御パラメータの動作が正確か
- [ ] ベースURLプレフィックス（/_profiler, /_wdt, /_error, /_webhook）がプロジェクトの実際の設定と一致しているか
- [ ] 本番環境でProfiler/WDTエンドポイントが無効化されていることの確認
