# Symfony 8.1

## 概要

Symfony は、Webアプリケーションおよびコンソールアプリケーション向けのPHPフレームワークであり、再利用可能なPHPコンポーネント群です。数千のWebアプリケーションや多くの著名なPHPプロジェクトで採用されており、セマンティックバージョニングに厳密に従ったリリースプロセスを持つ、業界標準のフルスタックPHPフレームワークです。本リポジトリは Symfony 8.1（開発ブランチ）のモノレポであり、全コンポーネント・ブリッジ・バンドルのソースコードを単一リポジトリで管理しています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| HTTPハンドリング | HttpFoundation / HttpKernel によるリクエスト・レスポンス処理、ルーティング、ミドルウェア |
| 依存性注入 | DependencyInjection コンポーネントによるサービスコンテナとオートワイヤリング |
| コンソール | Console コンポーネントによるCLIコマンド構築 |
| テンプレートエンジン | Twig統合（TwigBridge / TwigBundle）によるビューレンダリング |
| フォーム・バリデーション | Form / Validator コンポーネントによる入力処理と検証 |
| セキュリティ | Security（Core / HTTP / CSRF）/ PasswordHasher / SecurityBundle による認証・認可 |
| データベース連携 | DoctrineBridge によるORM / DBAL統合 |
| メッセージング | Messenger コンポーネントによる非同期メッセージ処理・キューイング |
| メール送信 | Mailer / Mime コンポーネントによるメール送信 |
| 通知 | Notifier コンポーネントによるマルチチャネル通知（SMS、チャットなど） |
| HTTPクライアント | HttpClient コンポーネントによる外部API呼び出し |
| キャッシュ | Cache コンポーネントによるPSR-6 / PSR-16準拠のキャッシュ管理 |
| 排他制御 | Lock / Semaphore コンポーネントによるリソースロック |
| レート制限 | RateLimiter コンポーネントによるアクセスレート制御 |
| スケジューラ | Scheduler コンポーネントによる定期タスクスケジューリング |
| ワークフロー | Workflow コンポーネントによるステートマシン・ワークフロー管理 |
| シリアライズ | Serializer / JsonStreamer / ObjectMapper によるオブジェクト変換・JSON処理 |
| アセット管理 | Asset / AssetMapper コンポーネントによるフロントエンドアセット管理 |
| 国際化 | Translation / Intl / Emoji コンポーネントによる多言語対応 |
| 開発・デバッグ | VarDumper / Stopwatch / ErrorHandler / WebProfilerBundle / DebugBundle |
| Webhook | Webhook / RemoteEvent コンポーネントによるWebhook受信・処理 |

## 技術スタック

### コア

- フレームワーク: Symfony 8.1（開発版）
- 言語: PHP >= 8.4
- テンプレートエンジン: Twig >= 3.21
- ORM/データベース: Doctrine ORM >= 3.4 / DBAL >= 4.3（開発依存）
- PSR準拠: PSR-4（オートロード）、PSR-6/PSR-16（キャッシュ）、PSR-7（HTTPメッセージ）、PSR-11（コンテナ）、PSR-14（イベントディスパッチャ）、PSR-3（ログ）、PSR-20（クロック）

### 主要ライブラリ

- symfony/contracts ^3.7 -- Symfonyの標準インターフェース群
- doctrine/persistence ^3.1|^4 -- Doctrineの永続化抽象レイヤー
- doctrine/event-manager ^2 -- Doctrineのイベント管理
- composer/semver ^3.0 -- セマンティックバージョニングユーティリティ
- symfony/polyfill-* -- 下位PHP互換ポリフィル群（mbstring、intl、uuid等）

### 開発ツール

- PHPUnit（phpunit.xml.dist）-- テストフレームワーク
- Psalm（psalm.xml）-- 静的解析ツール（errorLevel 5）
- symfony/phpunit-bridge -- Symfony向けPHPUnit拡張

## ディレクトリ構成

```
symfony-8.1/
├── src/
│   └── Symfony/
│       ├── Bridge/              # 外部ライブラリとの統合ブリッジ
│       │   ├── Doctrine/        #   Doctrine ORM/DBAL統合
│       │   ├── Monolog/         #   Monologロガー統合
│       │   ├── PsrHttpMessage/  #   PSR-7 HTTPメッセージ統合
│       │   └── Twig/            #   Twigテンプレートエンジン統合
│       ├── Bundle/              # Symfonyバンドル（アプリケーション統合層）
│       │   ├── DebugBundle/     #   デバッグ支援バンドル
│       │   ├── FrameworkBundle/  #   フレームワークコアバンドル
│       │   ├── SecurityBundle/  #   セキュリティバンドル
│       │   ├── TwigBundle/      #   Twigバンドル
│       │   └── WebProfilerBundle/ # Webプロファイラバンドル
│       ├── Component/           # 再利用可能なPHPコンポーネント群（55+）
│       │   ├── HttpFoundation/  #   HTTPリクエスト・レスポンス
│       │   ├── HttpKernel/      #   HTTPカーネル（リクエスト処理のコア）
│       │   ├── Routing/         #   URLルーティング
│       │   ├── DependencyInjection/ # サービスコンテナ
│       │   ├── Console/         #   CLIコマンド
│       │   ├── Security/        #   セキュリティ（Core / HTTP / CSRF）
│       │   ├── Messenger/       #   メッセージバス・キュー
│       │   ├── Serializer/      #   シリアライズ・デシリアライズ
│       │   └── ...              #   その他50以上のコンポーネント
│       └── Contracts/           # Symfonyインターフェース契約
├── composer.json                # Composerパッケージ定義
├── phpunit.xml.dist             # PHPUnitテスト設定
├── psalm.xml                    # Psalm静的解析設定
├── splitsh.json                 # サブツリー分割設定（読み取り専用リポジトリへの分割用）
├── CHANGELOG-8.0.md             # 8.0 変更履歴
├── UPGRADE-8.0.md               # 8.0 アップグレードガイド
├── UPGRADE-8.1.md               # 8.1 アップグレードガイド
├── CONTRIBUTING.md              # コントリビューションガイド
├── CODE_OF_CONDUCT.md           # 行動規範
├── LICENSE                      # MITライセンス
└── README.md                    # 公式README
```

## セットアップ

### 必要条件

- PHP >= 8.4
- Composer >= 2.1（composer-runtime-api）
- PHP拡張: ext-xml（必須）、ext-intl（推奨）、ext-mbstring（推奨）

### インストール手順

Symfonyフレームワークを利用する場合は、Symfony CLIまたはComposerを使用してプロジェクトを作成します。

```bash
# Symfony CLIを使用する場合
symfony new my_project --version=8.1

# Composerを使用する場合
composer create-project symfony/skeleton my_project "8.1.*"
```

本リポジトリ（モノレポ）を直接クローンして開発に参加する場合は以下のとおりです。

```bash
git clone https://github.com/symfony/symfony.git
cd symfony
git checkout 8.1
composer install
```

### 環境変数（テスト用）

テスト実行時に利用される環境変数は `phpunit.xml.dist` に定義されています。

| 変数名 | デフォルト値 | 説明 |
| --- | --- | --- |
| REDIS_HOST | localhost | Redisホスト |
| MEMCACHED_HOST | localhost | Memcachedホスト |
| MONGODB_URI | mongodb://localhost:27017 | MongoDB接続URI |
| LDAP_HOST / LDAP_PORT | localhost / 3389 | LDAPサーバ設定 |
| MESSENGER_REDIS_DSN | redis://localhost/messages | Messenger Redis DSN |

## 開発

### テストの実行

```bash
# 全テストスイートの実行
./phpunit

# 特定コンポーネントのテスト実行（例: HttpFoundation）
./phpunit src/Symfony/Component/HttpFoundation/
```

テスト設定は `phpunit.xml.dist` に定義されており、`benchmark` および `intl-data` グループはデフォルトで除外されています。

### 静的解析

```bash
# Psalmによる静的解析の実行
vendor/bin/psalm
```

Psalmはエラーレベル5で設定されており、テストディレクトリ・リソースディレクトリは解析対象から除外されています。

### コーディング規約

Symfonyのコーディング規約に従ってください。詳細は [Coding Standards](https://symfony.com/doc/current/contributing/code/standards.html) を参照してください。

### コントリビューション

コントリビューションの手順は [CONTRIBUTING.md](../../CONTRIBUTING.md) を参照してください。主なガイドラインは以下のとおりです。

- バグ報告: [Reporting a Bug](https://symfony.com/doc/current/contributing/code/bugs.html)
- パッチ提出: [Submitting a Patch](https://symfony.com/doc/current/contributing/code/patches.html)
- セキュリティ問題: [Security Issues](https://symfony.com/doc/current/contributing/code/security.html)
- テスト実行: [Running Symfony Tests](https://symfony.com/doc/current/contributing/code/tests.html)
