---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Symfony CLIによるプロジェクト作成コマンド**：公式ドキュメントの参照であり、本リポジトリのコードからは直接確認不可
  2. **Composer create-projectコマンドのバージョン指定**：8.1系のパッケージが実際にPackagistに公開されているかは本リポジトリからは確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json` -- パッケージ名、説明、PHP要件、依存関係、replace定義
- E-02: `README.md`（プロジェクトルート） -- 公式プロジェクト説明文
- E-03: `phpunit.xml.dist` -- テスト設定、環境変数定義、テストスイート構成
- E-04: `psalm.xml` -- 静的解析設定（エラーレベル、対象ディレクトリ）
- E-05: `src/Symfony/Bridge/` ディレクトリ一覧 -- Doctrine, Monolog, PsrHttpMessage, Twig
- E-06: `src/Symfony/Bundle/` ディレクトリ一覧 -- DebugBundle, FrameworkBundle, SecurityBundle, TwigBundle, WebProfilerBundle
- E-07: `src/Symfony/Component/` ディレクトリ一覧 -- 55以上のコンポーネント
- E-08: `CONTRIBUTING.md` -- コントリビューションガイドライン
- E-09: `UPGRADE-8.1.md` -- 8.1アップグレード情報
- E-10: `LICENSE` -- MITライセンス
- E-11: `splitsh.json` -- サブツリー分割定義
- E-12: `src/Symfony/Component/Notifier/` ディレクトリ構成 -- コンポーネント内部構造の参考

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Symfony はWebアプリケーションおよびコンソールアプリケーション向けのPHPフレームワークである | E-01, E-02 | ○ |
| C-02 | 再利用可能なPHPコンポーネント群である | E-01（replace定義）, E-07 | ○ |
| C-03 | 本リポジトリはモノレポであり全コンポーネントを単一リポジトリで管理している | E-01（replace定義）, E-11（splitsh.json） | ○ |
| C-04 | PHP >= 8.4 が必要 | E-01（require.php） | ○ |
| C-05 | Twig >= 3.21 を使用 | E-01（require.twig/twig） | ○ |
| C-06 | Doctrine ORM >= 3.4 / DBAL >= 4.3 を開発依存として使用 | E-01（require-dev） | ○ |
| C-07 | PSR-4, PSR-6/16, PSR-7, PSR-11, PSR-14, PSR-3, PSR-20 に準拠 | E-01（provide定義） | ○ |
| C-08 | Bridge は Doctrine, Monolog, PsrHttpMessage, Twig の4種類 | E-05 | ○ |
| C-09 | Bundle は DebugBundle, FrameworkBundle, SecurityBundle, TwigBundle, WebProfilerBundle の5種類 | E-06 | ○ |
| C-10 | Component は55以上存在 | E-07（55ディレクトリ確認） | ○ |
| C-11 | 主な機能テーブル（HTTPハンドリング、DI、コンソール等20カテゴリ） | E-07, E-01（replace定義） | ○ |
| C-12 | symfony/contracts ^3.7 が主要依存 | E-01（require） | ○ |
| C-13 | doctrine/persistence ^3.1\|^4 が主要依存 | E-01（require） | ○ |
| C-14 | PHPUnit がテストフレームワーク | E-03 | ○ |
| C-15 | Psalm がエラーレベル5で設定 | E-04 | ○ |
| C-16 | テスト実行コマンドは ./phpunit | E-03（bootstrap設定）, プロジェクトルートの phpunit スクリプト | ○ |
| C-17 | benchmark, intl-data グループがテストから除外 | E-03（groups.exclude） | ○ |
| C-18 | 環境変数テーブル（REDIS_HOST等） | E-03（php.env定義） | ○ |
| C-19 | ライセンスはMIT | E-10 | ○ |
| C-20 | splitsh.json でサブツリー分割が定義されている | E-11 | ○ |
| C-21 | コントリビューション手順はCONTRIBUTING.mdに記載 | E-08 | ○ |
| C-22 | ext-xml が必須PHP拡張 | E-01（require.ext-xml） | ○ |
| C-23 | composer-runtime-api >= 2.1 が必要 | E-01（require） | ○ |
| C-24 | Symfony CLIでのプロジェクト作成コマンド `symfony new my_project --version=8.1` | **根拠なし** | △ |
| C-25 | Composer create-projectコマンド `composer create-project symfony/skeleton my_project "8.1.*"` | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24, C-25 のインストールコマンドは、Symfony公式ドキュメントの一般的な手順に基づく記述であり、本リポジトリのコード内に直接的な根拠がない
  - 候補：Symfony公式ドキュメント（https://symfony.com/doc/current/setup.html） / Packagist（symfony/skeleton パッケージ） / Symfony CLI公式サイト
- ext-intl, ext-mbstring を「推奨」としているが、composer.json ではポリフィルで対応しており、明示的な推奨記述はソースコード内にはない（ただし実運用上は一般的に推奨されるため、大きな問題ではない）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 概要、技術スタック、ディレクトリ構成、開発ツール情報はすべてソースコードから直接確認可能
- 0: 低リスク -- 主な機能テーブルはコンポーネントディレクトリとcomposer.jsonのreplace定義から網羅的に確認
- 1: 中リスク -- セットアップ手順（C-24, C-25）は公式ドキュメント由来であり、バージョン8.1が実際にリリースされているかの確認が必要
- 0: 低リスク -- テスト・静的解析の実行方法はphpunit.xml.distおよびpsalm.xmlから直接確認

## 6) レビュアーチェックリスト（最小）
- [ ] セットアップ手順のコマンド（C-24, C-25）が現在のSymfony 8.1で正しく動作するか確認
- [ ] 主な機能テーブルの網羅性：記載されていないコンポーネント（HtmlSanitizer等）の追記が必要か検討
- [ ] 環境変数テーブルの値がテスト環境で適切か確認
- [ ] ext-intl, ext-mbstring の「推奨」表記が適切か確認（ポリフィル利用のため必須ではないが実運用では推奨）
