---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **PSR準拠の完全な一覧**：PSR-15（HTTPハンドラ）の直接的な実装宣言がコード内で確認できていない
  2. **debug:event-dispatcher等のコマンド存在**：FrameworkBundle内のコマンド定義を直接確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json` -- プロジェクト定義、PHP要件、依存関係、オートロード設定、replaceセクション
- E-02: `src/Symfony/Component/HttpKernel/Kernel.php` -- Kernelクラス定義、バージョン情報、boot/handle/shutdownメソッド
- E-03: `src/Symfony/Component/HttpKernel/HttpKernel.php` -- HttpKernelクラス定義、handle/handleRaw/terminateメソッド、コンストラクタプロモーション
- E-04: `src/Symfony/Component/HttpKernel/KernelEvents.php` -- 全カーネルイベント定数、ALIASESマッピング
- E-05: `src/Symfony/Component/HttpKernel/HttpKernelInterface.php` -- HttpKernelインターフェース定義
- E-06: `src/Symfony/Component/EventDispatcher/EventDispatcher.php` -- EventDispatcherクラス定義、dispatchメソッド
- E-07: `src/Symfony/Component/DependencyInjection/ContainerBuilder.php` -- ContainerBuilderクラス定義
- E-08: `src/Symfony/Component/Routing/Router.php` -- Routerクラス定義
- E-09: `src/Symfony/Component/Routing/Attribute/Route.php` -- Route Attribute定義
- E-10: `src/Symfony/Component/Console/Attribute/AsCommand.php` -- AsCommand Attribute定義
- E-11: `src/Symfony/Component/EventDispatcher/Attribute/AsEventListener.php` -- AsEventListener Attribute定義
- E-12: `src/Symfony/Component/Messenger/Attribute/AsMessageHandler.php` -- AsMessageHandler Attribute定義
- E-13: `src/Symfony/Component/DependencyInjection/Attribute/Autowire.php` -- Autowire Attribute定義
- E-14: `src/Symfony/Component/HttpKernel/Bundle/Bundle.php` -- Bundle抽象クラス定義
- E-15: `src/Symfony/Component/Console/Command/Command.php` -- Commandクラス定義
- E-16: `src/Symfony/Component/Messenger/MessageBus.php` -- MessageBusクラス定義、dispatchメソッド
- E-17: `src/Symfony/Component/Serializer/Serializer.php` -- Serializerクラス定義
- E-18: `src/Symfony/Component/HttpFoundation/Request.php` -- Requestクラス定義
- E-19: `src/Symfony/Component/HttpFoundation/Response.php` -- Responseクラス定義、HTTPステータスコード定数
- E-20: `src/Symfony/Bundle/FrameworkBundle/FrameworkBundle.php` -- FrameworkBundleクラス定義、コンパイラパス登録
- E-21: `src/Symfony/Component/Validator/Constraints/NotBlank.php` -- Validator Constraint例
- E-22: ディレクトリ構造の実地確認（ls コマンドによる各ディレクトリの内容確認）
- E-23: `src/Symfony/Component/DependencyInjection/Attribute/` ディレクトリの内容一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Symfony 8.1はPHP 8.4以上を要求する | E-01 (`"php": ">=8.4"`) | ○ |
| C-02 | 名前空間とディレクトリパスがPSR-4で1対1対応する | E-01 (autoload.psr-4 定義) | ○ |
| C-03 | Kernelクラスはバンドルの管理、DIコンテナ構築、リクエスト処理を統括する | E-02 (boot/handle/shutdownメソッド) | ○ |
| C-04 | Kernelバージョンは8.1.0-DEVである | E-02 (`VERSION = '8.1.0-DEV'`) | ○ |
| C-05 | HttpKernelはイベント駆動でリクエストをレスポンスに変換する | E-03 (handleRawメソッド内のイベントディスパッチ) | ○ |
| C-06 | HttpKernelのコンストラクタはコンストラクタプロモーションを使用している | E-03 (protected EventDispatcherInterface $dispatcher引数) | ○ |
| C-07 | KernelEventsにはREQUEST/CONTROLLER/VIEW/RESPONSE/TERMINATE等のイベントが定義されている | E-04 (全イベント定数の定義) | ○ |
| C-08 | KernelEvents::ALIASESでイベントクラス名からイベント名へのマッピングが提供されている | E-04 (ALIASES定数配列) | ○ |
| C-09 | HttpKernelInterfaceはhandle()メソッドとMAIN_REQUEST/SUB_REQUEST定数を持つ | E-05 | ○ |
| C-10 | EventDispatcher::dispatch()はリスナーを優先度順に呼び出す | E-06 (sortListeners/optimizeListenersの仕組み) | ○ |
| C-11 | ContainerBuilderはextensions/definitions/aliasDefinitionsを管理する | E-07 (privateプロパティの定義) | ○ |
| C-12 | Routerクラスはloader/resource/contextを受け取りURL解決を行う | E-08 (コンストラクタ定義) | ○ |
| C-13 | Route Attributeはクラスとメソッドに適用可能でIS_REPEATABLEである | E-09 (`#[\Attribute(\Attribute::IS_REPEATABLE | ...)]`) | ○ |
| C-14 | AsCommand AttributeはTARGET_CLASSとTARGET_METHODに適用可能 | E-10 | ○ |
| C-15 | AsEventListener Attributeはevent/method/priority/dispatcherパラメータを持つ | E-11 | ○ |
| C-16 | AsMessageHandler Attributeはbus/fromTransport/handles/method/priority/signパラメータを持つ | E-12 | ○ |
| C-17 | Autowire Attributeはvalue/service/expression/env/param/lazyパラメータを受け取る | E-13 | ○ |
| C-18 | Bundle抽象クラスはboot/shutdown/buildメソッドを提供する | E-14 | ○ |
| C-19 | Command基底クラスはSUCCESS=0/FAILURE=1/INVALID=2の定数を持つ | E-15 | ○ |
| C-20 | MessageBusはミドルウェアパイプラインでメッセージを処理する | E-16 (middlewareAggregate, StackMiddleware) | ○ |
| C-21 | Serializerはnormalize+encodeの2段階パイプラインを持つ | E-17 (NormalizerInterface, EncoderInterface実装) | ○ |
| C-22 | RequestクラスはHTTPメソッド定数とフォワードヘッダー定数を定義する | E-18 | ○ |
| C-23 | ResponseクラスはHTTPステータスコード定数を定義する | E-19 | ○ |
| C-24 | FrameworkBundleは多数のコンパイラパスを登録する | E-20 (use文とbuildメソッド) | ○ |
| C-25 | プロジェクトは Bridge/Bundle/Component の3層構造を持つ | E-22 (ディレクトリ確認) | ○ |
| C-26 | Bridge配下にはDoctrine/Monolog/PsrHttpMessage/Twigが存在する | E-22 | ○ |
| C-27 | Bundle配下にはDebugBundle/FrameworkBundle/SecurityBundle/TwigBundle/WebProfilerBundleが存在する | E-22 | ○ |
| C-28 | opcache.preloadの最適化のためclass_exists()がファイル冒頭で呼ばれている | E-03 (HttpKernel.php:38-48のコメント付きclass_exists呼び出し) | ○ |
| C-29 | Symfonyは複数のPSR実装を提供する（PSR-6/16, PSR-7, PSR-11, PSR-14, PSR-20） | E-01 (provide/require定義) | ○ |
| C-30 | DI Attribute配下にはAutowire/AutowireLocator/When/WhenNot等が存在する | E-23 | ○ |
| C-31 | handleRaw()メソッドはkernel.request → controller解決 → kernel.controller → 引数解決 → 実行の順で処理する | E-03 (handleRawメソッドのコード) | ○ |
| C-32 | コンポーネント数は50以上（replaceセクションから確認） | E-01 (65個のreplace定義) | ○ |
| C-33 | Kernel::handle()はHTTPキャッシュがある場合にそちらに委譲する | E-02 (handle()メソッドのhttp_cache確認処理) | ○ |
| C-34 | PSR-15（HTTPハンドラ）をSymfonyが直接実装している | **根拠なし** | △ |
| C-35 | debug:event-dispatcher/debug:container/debug:routerコマンドが存在する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-34: PSR-15のHTTPハンドラインターフェースについて、`composer.json` の `provide` セクションにPSR-15の直接的な記載がない。HttpKernelがPSR-15相当の機能を持つことは構造的に推測可能だが、厳密には「PSR-15準拠」とは言い切れない可能性がある。
  - 候補：`HttpKernelInterface.php` / PSR-15仕様書 / Symfony公式ドキュメント
- C-35: `debug:event-dispatcher` 等のコマンドはSymfonyフレームワークの一般的な機能として知られているが、今回のコード解析ではFrameworkBundle内のコマンドクラスを直接確認していない。
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Command/` ディレクトリ / Symfony公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 言語基礎セクション（PHPの一般的な構文説明）。PHP公式ドキュメントと照合可能。
- 0: 低リスク -- ディレクトリ構造セクション。実際のディレクトリ一覧（ls結果）と直接照合済み。
- 0: 低リスク -- 命名規則セクション。ソースコードのファイル名・クラス名から直接抽出。
- 0: 低リスク -- 主要コンポーネントのコード引用。ソースファイルから直接引用し行番号を付記。
- 1: 中リスク -- PSR準拠一覧。provide定義から確認できるものは正確だが、PSR-15については追加検証が望ましい。
- 1: 中リスク -- デバッグコマンドの存在。一般的な知識に基づく記述であり、FrameworkBundleのCommandディレクトリを直接確認することで検証可能。

## 6) レビュアーチェックリスト（最小）
- [ ] コード引用の行番号が最新のソースコードと一致しているか確認
- [ ] PSR準拠一覧（特にPSR-15）の正確性をSymfony公式ドキュメントで照合
- [ ] デバッグコマンド（debug:event-dispatcher等）の存在を `src/Symfony/Bundle/FrameworkBundle/Command/` で確認
- [ ] ディレクトリ構造の説明がプロジェクトの実態と一致しているか確認
- [ ] Mermaidダイアグラムがイベント処理フローを正確に表現しているか確認
- [ ] 用語集の定義が公式ドキュメントの用語と矛盾していないか確認
