# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph Client["Client"]
        Browser["Web Browser"]
        CLI["CLI / Console"]
        API["API Client"]
    end

    subgraph SymfonyFramework["Symfony Framework 8.1"]
        subgraph PresentationLayer["Presentation Layer"]
            HttpFoundation["HttpFoundation<br/>(Request/Response)"]
            HttpKernel["HttpKernel<br/>(Request Handler)"]
            Routing["Routing<br/>(URL Matching)"]
            TwigBridge["Twig Bridge<br/>(Template Rendering)"]
            Console["Console<br/>(CLI Commands)"]
        end

        subgraph ApplicationLayer["Application Layer"]
            Messenger["Messenger<br/>(Message Bus)"]
            Form["Form<br/>(Form Handling)"]
            Validator["Validator<br/>(Data Validation)"]
            Workflow["Workflow<br/>(State Machine)"]
            Scheduler["Scheduler<br/>(Task Scheduling)"]
        end

        subgraph DomainLayer["Domain Layer"]
            Serializer["Serializer<br/>(Data Transformation)"]
            ExpressionLanguage["ExpressionLanguage"]
            TypeInfo["TypeInfo"]
            PropertyAccess["PropertyAccess"]
            ObjectMapper["ObjectMapper"]
        end

        subgraph InfrastructureLayer["Infrastructure Layer"]
            Cache["Cache<br/>(PSR-6/16)"]
            HttpClient["HttpClient"]
            Mailer["Mailer"]
            Notifier["Notifier"]
            Lock["Lock"]
            Filesystem["Filesystem"]
            DoctrineBridge["Doctrine Bridge"]
        end

        subgraph CrossCutting["Cross-Cutting Concerns"]
            DI["DependencyInjection<br/>(DI Container)"]
            EventDispatcher["EventDispatcher<br/>(PSR-14)"]
            Security["Security<br/>(Auth/Authz)"]
            ErrorHandler["ErrorHandler"]
            Config["Config"]
            MonologBridge["Monolog Bridge<br/>(Logging)"]
        end

        subgraph Bundles["Bundles (Integration)"]
            FrameworkBundle["FrameworkBundle"]
            SecurityBundle["SecurityBundle"]
            TwigBundle["TwigBundle"]
            DebugBundle["DebugBundle"]
            WebProfilerBundle["WebProfilerBundle"]
        end
    end

    subgraph External["External Systems"]
        RDB["RDB<br/>(MySQL/PostgreSQL)"]
        Redis["Redis"]
        Memcached["Memcached"]
        AMQP["AMQP<br/>(RabbitMQ)"]
        SMTP["SMTP / Mail"]
        LDAP["LDAP"]
        ExternalAPI["External HTTP API"]
        NotifService["Notification Services<br/>(Slack, SMS, etc.)"]
    end

    Browser --> HttpFoundation
    CLI --> Console
    API --> HttpFoundation

    HttpFoundation --> HttpKernel
    HttpKernel --> Routing
    HttpKernel --> EventDispatcher
    HttpKernel --> DI
    HttpKernel --> ErrorHandler

    Routing --> Messenger
    Routing --> Form

    Messenger --> Lock
    Messenger --> Cache
    Form --> Validator
    Validator --> Serializer

    Cache --> Redis
    Cache --> Memcached
    DoctrineBridge --> RDB
    HttpClient --> ExternalAPI
    Mailer --> SMTP
    Notifier --> NotifService
    Security --> LDAP
    Messenger --> AMQP

    FrameworkBundle --> HttpKernel
    FrameworkBundle --> DI
    SecurityBundle --> Security
    TwigBundle --> TwigBridge
```

## HttpKernel リクエスト処理フロー

```mermaid
sequenceDiagram
    participant Client
    participant HttpKernel
    participant EventDispatcher
    participant RouterListener
    participant Firewall
    participant ControllerResolver
    participant ArgumentResolver
    participant Controller
    participant ViewListener

    Client->>HttpKernel: handle(Request)
    HttpKernel->>HttpKernel: RequestStack.push(Request)

    HttpKernel->>EventDispatcher: dispatch(kernel.request)
    EventDispatcher->>RouterListener: onKernelRequest()
    RouterListener-->>EventDispatcher: Route matched
    EventDispatcher->>Firewall: onKernelRequest()
    Firewall-->>EventDispatcher: Authentication processed

    HttpKernel->>ControllerResolver: getController(Request)
    ControllerResolver-->>HttpKernel: Controller callable

    HttpKernel->>EventDispatcher: dispatch(kernel.controller)
    HttpKernel->>ArgumentResolver: getArguments(Request, Controller)
    ArgumentResolver-->>HttpKernel: Arguments[]

    HttpKernel->>EventDispatcher: dispatch(kernel.controller_arguments)
    HttpKernel->>Controller: invoke(Arguments)
    Controller-->>HttpKernel: Response / mixed

    alt Response is not a Response object
        HttpKernel->>EventDispatcher: dispatch(kernel.view)
        EventDispatcher->>ViewListener: onKernelView()
        ViewListener-->>HttpKernel: Response
    end

    HttpKernel->>EventDispatcher: dispatch(kernel.response)
    HttpKernel-->>Client: Response

    HttpKernel->>EventDispatcher: dispatch(kernel.terminate)
```

## Messenger 非同期処理フロー

```mermaid
sequenceDiagram
    participant App as Application Code
    participant Bus as MessageBus
    participant SendMW as SendMessageMiddleware
    participant HandleMW as HandleMessageMiddleware
    participant Transport as Transport (AMQP/Redis/DB)
    participant Worker as Worker Process
    participant Handler as MessageHandler

    App->>Bus: dispatch(Message)
    Bus->>Bus: Envelope.wrap(Message)
    Bus->>SendMW: handle(Envelope, Stack)

    alt Async Transport configured
        SendMW->>Transport: send(Envelope)
        Transport-->>SendMW: SentStamp
        SendMW-->>Bus: Envelope with SentStamp

        Note over Worker,Transport: Later - Worker consumes
        Worker->>Transport: get()
        Transport-->>Worker: Envelope
        Worker->>Bus: dispatch(Envelope)
        Bus->>HandleMW: handle(Envelope, Stack)
        HandleMW->>Handler: __invoke(Message)
        Handler-->>HandleMW: Result
    else Sync processing
        SendMW->>HandleMW: handle(Envelope, Stack)
        HandleMW->>Handler: __invoke(Message)
        Handler-->>HandleMW: Result
        HandleMW-->>Bus: Envelope
    end
```

## コンポーネント依存関係図

```mermaid
graph LR
    subgraph Core["Core Components"]
        HttpKernel["HttpKernel"]
        HttpFoundation["HttpFoundation"]
        EventDispatcher["EventDispatcher"]
        DI["DependencyInjection"]
        Config["Config"]
        ErrorHandler["ErrorHandler"]
        Routing["Routing"]
    end

    subgraph AppComponents["Application Components"]
        Messenger["Messenger"]
        Form["Form"]
        Validator["Validator"]
        Serializer["Serializer"]
        Security["Security"]
        Cache["Cache"]
    end

    subgraph Bridges["Bridges"]
        DoctrineBridge["Doctrine Bridge"]
        TwigBridge["Twig Bridge"]
        MonologBridge["Monolog Bridge"]
    end

    subgraph BundleLayer["Bundles"]
        FrameworkBundle["FrameworkBundle"]
        SecurityBundle["SecurityBundle"]
        TwigBundle["TwigBundle"]
    end

    HttpKernel --> HttpFoundation
    HttpKernel --> EventDispatcher
    HttpKernel --> DI
    HttpKernel --> Config
    HttpKernel --> ErrorHandler
    Routing --> HttpFoundation

    Messenger --> EventDispatcher
    Form --> EventDispatcher
    Form --> Validator
    Validator --> PropertyAccess["PropertyAccess"]
    Security --> HttpFoundation
    Security --> EventDispatcher
    Serializer --> PropertyAccess

    DoctrineBridge --> Form
    DoctrineBridge --> Validator
    DoctrineBridge --> Security
    TwigBridge --> Form
    MonologBridge --> HttpKernel

    FrameworkBundle --> HttpKernel
    FrameworkBundle --> DI
    FrameworkBundle --> Routing
    FrameworkBundle --> Cache
    FrameworkBundle --> Messenger
    SecurityBundle --> Security
    TwigBundle --> TwigBridge
```

## レイヤー構成図

```mermaid
graph TB
    subgraph Presentation["Presentation Layer"]
        direction LR
        P1["HttpFoundation"]
        P2["HttpKernel"]
        P3["Routing"]
        P4["Twig Bridge/Bundle"]
        P5["Console"]
    end

    subgraph Application["Application Layer"]
        direction LR
        A1["Messenger"]
        A2["Form"]
        A3["Validator"]
        A4["Workflow"]
        A5["Scheduler"]
    end

    subgraph Domain["Domain Layer"]
        direction LR
        D1["Serializer"]
        D2["ExpressionLanguage"]
        D3["TypeInfo"]
        D4["PropertyAccess/Info"]
        D5["ObjectMapper"]
    end

    subgraph Infrastructure["Infrastructure Layer"]
        direction LR
        I1["Cache"]
        I2["Doctrine Bridge"]
        I3["HttpClient"]
        I4["Mailer"]
        I5["Lock/Semaphore"]
    end

    subgraph CrossCutting["Cross-Cutting Concerns"]
        direction LR
        CC1["DependencyInjection"]
        CC2["EventDispatcher"]
        CC3["Security"]
        CC4["ErrorHandler"]
        CC5["Config"]
    end

    Presentation --> Application
    Application --> Domain
    Application --> Infrastructure
    Domain --> Infrastructure
    CrossCutting -.->|supports all layers| Presentation
    CrossCutting -.->|supports all layers| Application
    CrossCutting -.->|supports all layers| Domain
    CrossCutting -.->|supports all layers| Infrastructure
```
