---
generated_at: 2026-02-04 15:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 25
  claims_without_evidence: 5
confidence_derived: 0.83
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：25 / 30、根拠なし：5
- 優先レビュー（高）
  1. **RabbitMQバージョン3.8.3の最新性**：integration-tests.ymlに記載のバージョンが古い可能性（実際の運用時のバージョンは要確認）
  2. **スケーリング設計の具体的な数値**：並列度等の数値はCI/CDに限定され、利用者側のスケーリング設計に根拠コードなし
  3. **可用性設計のフレームワーク利用者向け記述**：ChainAdapter等のフォールバック機能はコードから推測だが明示的なドキュメント根拠なし
  4. **バックアップ設計**：CI/CDアーティファクトの保持期間以外は一般的な記述
  5. **監視設計の詳細**：GitHub Actions組み込み機能に基づく一般的な記述

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json`（ルート）
- E-02: `.github/workflows/unit-tests.yml`
- E-03: `.github/workflows/integration-tests.yml`
- E-04: `.github/workflows/windows.yml`
- E-05: `.github/workflows/package-tests.yml`
- E-06: `.github/workflows/scorecards.yml`
- E-07: `phpunit.xml.dist`
- E-08: `src/Symfony/Component/HttpKernel/Kernel.php`（VERSION定数）
- E-09: `src/Symfony/Component/Cache/Adapter/`（アダプタ一覧）
- E-10: `src/Symfony/Component/Messenger/Transport/`（トランスポート一覧）
- E-11: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトはSymfony Framework v8.1.0-DEVである | E-08 | ○ |
| C-02 | PHPの最低バージョンは8.4以上 | E-01 | ○ |
| C-03 | 必須PHP拡張はext-xml | E-01 | ○ |
| C-04 | CI/CDはGitHub Actionsで実行される | E-02, E-03, E-04, E-05, E-06 | ○ |
| C-05 | 単体テストはubuntu-24.04で実行される | E-02 | ○ |
| C-06 | テスト対象PHPバージョンは8.4/8.5/8.6 | E-02 | ○ |
| C-07 | テストモードはdefault/high-deps/low-deps | E-02 | ○ |
| C-08 | 単体テストに必要なPHP拡張はamqp,apcu,brotli,igbinary,intl,mbstring,memcached,redis,relay,zstd | E-02 | ○ |
| C-09 | PostgreSQL 16が統合テストで使用される | E-03 | ○ |
| C-10 | Redis 6.2.8が複数構成（standalone, cluster, sentinel, primary/replica）で使用される | E-03 | ○ |
| C-11 | Memcached 1.6.5が統合テストで使用される | E-03 | ○ |
| C-12 | RabbitMQ 3.8.3が統合テストで使用される | E-03 | ○ |
| C-13 | MongoDB（latestイメージ）が統合テストで使用される | E-03 | ○ |
| C-14 | Couchbase 6.5.1が統合テストで使用される | E-03 | ○ |
| C-15 | LocalStack 3.0.2がAWSサービスエミュレーションに使用される | E-03 | ○ |
| C-16 | Kafka 3.7が統合テストで使用される | E-03 | ○ |
| C-17 | OpenLDAPがポート3389で統合テストに使用される | E-03 | ○ |
| C-18 | FrankenPHP 1.1.0がHTTPサーバーテストに使用される | E-03 | ○ |
| C-19 | PgBouncerがコネクションプーリングテストに使用される | E-03 | ○ |
| C-20 | Windows環境テストはwindows-2022で実行される | E-04 | ○ |
| C-21 | OpenSSF Scorecardが週次で実行される | E-06 | ○ |
| C-22 | SARIFファイルの保持期間は5日間 | E-06 | ○ |
| C-23 | コンポーネントテストはparallel -j +3で3並列以上で実行される | E-02 | ○ |
| C-24 | PHPUnit設定でfailOnDeprecation/failOnRisky/failOnWarningが有効 | E-07 | ○ |
| C-25 | プロジェクトは56以上のコンポーネントを含むモノリポジトリである | E-01 (replace), E-09, E-10 | ○ |
| C-26 | フレームワーク利用者向けにRedis Cluster/Sentinel接続をサポート | E-09 | △ |
| C-27 | ChainAdapterによる複数キャッシュバックエンドのフォールバック構成をサポート | E-09 | △ |
| C-28 | メッセンジャーがAMQP/SQS/Redis/Kafka等のトランスポートをサポート | E-10 | △ |
| C-29 | 分散ロックとしてDynamoDB Storeをサポート | E-01 (require-dev: async-aws/dynamo-db) | △ |
| C-30 | アプリケーションデプロイ用インフラ定義が含まれない | **根拠なし**（Dockerfile等の不在を確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-26/C-27/C-28**: フレームワークのコンポーネントとしてアダプタ・トランスポートクラスの存在は確認できるが、実際の利用者環境でのスケーリング挙動やフォールバック仕様の詳細ドキュメントはプロジェクト内に見つからなかった
  - 候補：Symfonyの公式ドキュメント / 各コンポーネントのREADME.md / テストコード
- **C-29**: DynamoDB Storeはcomposer.jsonのrequire-devとLock/Bridge/DynamoDbディレクトリの存在から推測。詳細な設計情報はソースコード読解が必要
  - 候補：`src/Symfony/Component/Lock/Bridge/DynamoDb/` 内のソースコード
- **C-30**: Dockerfile等のインフラ定義ファイルが存在しないことの確認は「ファイルが見つからなかった」という消極的根拠に基づく
  - 候補：プロジェクトの公式ドキュメント / CONTRIBUTING.md

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- CI/CD基盤（GitHub Actions）の構成情報はワークフローファイルから正確に読み取れている
- 0: 低リスク -- 統合テスト用サービスのバージョン・ポート情報はintegration-tests.ymlから正確に読み取れている
- 1: 中リスク -- フレームワーク利用者向けのスケーリング・可用性設計はコンポーネントの存在から推測した内容を含む
- 1: 中リスク -- RabbitMQ 3.8.3等の一部サービスバージョンがCI/CD上の固定バージョンであり、推奨バージョンとは異なる可能性がある
- 0: 低リスク -- プロジェクトがライブラリであるため、アプリケーションデプロイ用インフラ定義が不要であるという判断は妥当

## 6) レビュアーチェックリスト（最小）
- [ ] CI/CDワークフローで使用されるサービスバージョンが最新のintegration-tests.ymlと一致するか確認
- [ ] PHPバージョンマトリクス（8.4/8.5/8.6）が現在のunit-tests.ymlと一致するか確認
- [ ] フレームワーク利用者向けのスケーリング・可用性設計の記述が適切か（コンポーネント名・機能に誤りがないか）
- [ ] ネットワーク構成のポートマッピング表がintegration-tests.ymlのports設定と一致するか確認
- [ ] 「アプリケーションデプロイ用インフラ定義が含まれない」という前提が正しいか確認
