# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "GitHub Platform"
        GH_REPO["GitHub Repository<br/>symfony/symfony (8.1)"]
        GH_CS["GitHub Code Scanning"]
    end

    subgraph "CI/CD Triggers"
        PUSH["Push Event"]
        PR["Pull Request Event"]
        SCHED["Schedule<br/>(Weekly: Sat 4:34 UTC)"]
    end

    PUSH --> GH_REPO
    PR --> GH_REPO
    SCHED --> GH_REPO

    GH_REPO --> WF_UNIT
    GH_REPO --> WF_INTEG
    GH_REPO --> WF_WIN
    GH_REPO --> WF_PKG
    GH_REPO --> WF_SC

    subgraph "GitHub Actions Workflows"
        WF_UNIT["Unit Tests"]
        WF_INTEG["Integration Tests"]
        WF_WIN["Windows Tests"]
        WF_PKG["Verify Packages"]
        WF_SC["Scorecards"]
    end

    WF_SC --> GH_CS
```

## CI/CDパイプライン構成図

```mermaid
graph LR
    subgraph "Unit Tests Pipeline"
        direction TB
        UT_MATRIX["Matrix Strategy"]
        UT_84["PHP 8.4<br/>(default)"]
        UT_84H["PHP 8.4<br/>(high-deps)"]
        UT_84L["PHP 8.4<br/>(low-deps)"]
        UT_85["PHP 8.5"]
        UT_86["PHP 8.6"]

        UT_MATRIX --> UT_84
        UT_MATRIX --> UT_84H
        UT_MATRIX --> UT_84L
        UT_MATRIX --> UT_85
        UT_MATRIX --> UT_86
    end

    subgraph "Runner: ubuntu-24.04"
        RUNNER_U["GitHub-hosted Runner"]
    end

    UT_84 --> RUNNER_U
    UT_84H --> RUNNER_U
    UT_84L --> RUNNER_U
    UT_85 --> RUNNER_U
    UT_86 --> RUNNER_U
```

## 統合テスト用サービス構成図

```mermaid
graph TB
    subgraph "Integration Test Runner (ubuntu-24.04)"
        PHP["PHP 8.4<br/>+ Extensions"]
        PHPUNIT["PHPUnit"]
    end

    subgraph "Database Services"
        PG["PostgreSQL 16<br/>:5432"]
        PGBOUNCER["PgBouncer<br/>:6432"]
        MONGO["MongoDB<br/>:27017"]
        COUCH["Couchbase 6.5.1<br/>:8091-8094, :11210"]
    end

    subgraph "Cache Services"
        REDIS["Redis 6.2.8<br/>:16379"]
        REDIS_AUTH["Redis (Auth)<br/>:16380"]
        REDIS_CLUSTER["Redis Cluster 6.2.8<br/>:7000-7006"]
        REDIS_SENTINEL["Redis Sentinel 6.2.8<br/>:26379"]
        REDIS_PRIMARY["Redis Primary<br/>:16381"]
        REDIS_REPLICA["Redis Replica<br/>:16382"]
        MEMCACHED["Memcached 1.6.5<br/>:11211"]
    end

    subgraph "Message Broker Services"
        RABBIT["RabbitMQ 3.8.3<br/>:5672"]
        KAFKA["Kafka 3.7<br/>:9092"]
        ZK["ZooKeeper<br/>(internal)"]
    end

    subgraph "AWS Emulation"
        LOCALSTACK["LocalStack 3.0.2<br/>:4566"]
        LS_SQS["SQS"]
        LS_DYNAMO["DynamoDB"]
        LS_SNS["SNS"]
        LS_SES["SES"]
    end

    subgraph "Other Services"
        LDAP["OpenLDAP<br/>:3389"]
        FTP["FTP Server<br/>:21, :30000-30009"]
        FRANKEN["FrankenPHP 1.1.0<br/>:80, :8681-8684"]
    end

    PHP --> PHPUNIT
    PHPUNIT --> PG
    PHPUNIT --> PGBOUNCER
    PHPUNIT --> MONGO
    PHPUNIT --> COUCH
    PHPUNIT --> REDIS
    PHPUNIT --> REDIS_AUTH
    PHPUNIT --> REDIS_CLUSTER
    PHPUNIT --> REDIS_SENTINEL
    PHPUNIT --> MEMCACHED
    PHPUNIT --> RABBIT
    PHPUNIT --> KAFKA
    PHPUNIT --> LOCALSTACK
    PHPUNIT --> LDAP
    PHPUNIT --> FTP
    PHPUNIT --> FRANKEN

    PGBOUNCER --> PG
    KAFKA --> ZK
    REDIS_SENTINEL --> REDIS
    REDIS_REPLICA --> REDIS_PRIMARY
    LOCALSTACK --> LS_SQS
    LOCALSTACK --> LS_DYNAMO
    LOCALSTACK --> LS_SNS
    LOCALSTACK --> LS_SES
```

## Windows テスト構成図

```mermaid
graph TB
    subgraph "Windows Test Runner (windows-2022)"
        direction TB
        WIN_MIN["Job: minimal-exts<br/>(x86 / lowest-php)"]
        WIN_ALL["Job: all-extensions<br/>(x86 / all extensions)"]
    end

    subgraph "Minimal Extensions"
        MIN_EXT["xsl, mbstring,<br/>openssl, curl"]
    end

    subgraph "All Extensions"
        ALL_EXT["xsl, mbstring, opcache,<br/>openssl, apcu, igbinary,<br/>redis, intl, fileinfo,<br/>pdo_sqlite, curl, sodium"]
        MEMURAI["Memurai Developer<br/>(Redis互換)"]
    end

    WIN_MIN --> MIN_EXT
    WIN_ALL --> ALL_EXT
    WIN_ALL --> MEMURAI
```

## Symfony コンポーネント依存関係図（インフラ関連）

```mermaid
graph TB
    subgraph "Cache Layer"
        CACHE["symfony/cache"]
        CACHE_REDIS["RedisAdapter"]
        CACHE_MEMCACHED["MemcachedAdapter"]
        CACHE_PDO["PdoAdapter /<br/>DoctrineDbalAdapter"]
        CACHE_COUCH["CouchbaseCollectionAdapter"]
        CACHE_APCU["ApcuAdapter"]
        CACHE_FS["FilesystemAdapter"]
        CACHE_CHAIN["ChainAdapter"]
    end

    subgraph "Messaging Layer"
        MESSENGER["symfony/messenger"]
        MSG_AMQP["AMQP Transport"]
        MSG_REDIS["Redis Transport"]
        MSG_DOCTRINE["Doctrine Transport"]
        MSG_SQS["SQS Transport"]
        MSG_KAFKA["Kafka Transport"]
    end

    subgraph "Distributed Systems"
        LOCK["symfony/lock"]
        LOCK_DYNAMO["DynamoDB Store"]
        SEMA["symfony/semaphore"]
        RATE["symfony/rate-limiter"]
    end

    subgraph "External Communication"
        MAILER["symfony/mailer"]
        NOTIFIER["symfony/notifier"]
        HTTP_CLIENT["symfony/http-client"]
        WEBHOOK["symfony/webhook"]
    end

    CACHE --> CACHE_REDIS
    CACHE --> CACHE_MEMCACHED
    CACHE --> CACHE_PDO
    CACHE --> CACHE_COUCH
    CACHE --> CACHE_APCU
    CACHE --> CACHE_FS
    CACHE --> CACHE_CHAIN

    MESSENGER --> MSG_AMQP
    MESSENGER --> MSG_REDIS
    MESSENGER --> MSG_DOCTRINE
    MESSENGER --> MSG_SQS
    MESSENGER --> MSG_KAFKA

    LOCK --> LOCK_DYNAMO

    CACHE_CHAIN --> CACHE_REDIS
    CACHE_CHAIN --> CACHE_MEMCACHED
    CACHE_CHAIN --> CACHE_FS
```
