# インフラ設計書

## 概要

本ドキュメントは、Symfony Framework v8.1（symfony/symfony）のCI/CD基盤およびテスト・開発インフラストラクチャの設計を記述する。本プロジェクトはPHPフレームワークライブラリであり、独自のアプリケーションデプロイ用インフラ（Docker/Kubernetes/Terraform等）は含まないが、GitHub Actionsによる大規模なCI/CDパイプラインと、統合テスト用の各種ミドルウェアサービス群で構成されるインフラを有する。

## システム構成

### 全体構成

本プロジェクトのインフラストラクチャは以下の3つの層で構成される。

1. **CI/CDプラットフォーム層**: GitHub Actions上で動作するワークフロー群（Ubuntu 24.04 / Windows 2022）
2. **テスト用サービス層**: 統合テスト時にGitHub Actions servicesとして起動される各種ミドルウェアコンテナ
3. **セキュリティ解析層**: OpenSSF Scorecardによるサプライチェーンセキュリティ分析

プロジェクト自体はPHPライブラリ（`type: library`）であり、アプリケーションデプロイ用のインフラ定義（Dockerfile、docker-compose.yml、Kubernetes マニフェスト、Terraform等）は含まれていない。利用者がSymfonyを使用してアプリケーションを構築する際に、個別のインフラ環境を用意する設計である。

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| CI/CDランナー（Linux） | 単体テスト・統合テスト・パッケージ検証 | ubuntu-24.04 (GitHub-hosted) | マトリクスにより最大5並列（PHP 8.4 x 3モード + PHP 8.5 + PHP 8.6） |
| CI/CDランナー（Windows） | Windows環境テスト | windows-2022 (GitHub-hosted) | 2並列（minimal-exts / all-extensions） |
| 統合テスト用サービス群 | データベース・キャッシュ・メッセージキュー等 | GitHub Actions services（Docker コンテナ） | 最大15サービス同時起動 |

### ネットワーク構成

CI/CD環境ではGitHub Actionsのランナーネットワーク上で動作し、統合テスト用の各種サービスは`localhost`（127.0.0.1）上のポートマッピングを通じてアクセスされる。外部への通信はComposerパッケージのダウンロード、Dockerイメージのpull、Symfony Recipes APIへのアクセスに限定される。

主要なポートマッピング：

| サービス | ポート | 用途 |
| --- | --- | --- |
| PostgreSQL | 5432 | RDB統合テスト |
| PgBouncer | 6432 | コネクションプーリングテスト |
| Redis | 16379 | キャッシュ・セッション・メッセンジャー |
| Redis (認証付き) | 16380 | 認証付きRedis接続テスト |
| Redis Cluster | 7000-7006 | Redisクラスタ接続テスト |
| Redis Sentinel | 26379 | Redis Sentinel接続テスト |
| Redis Primary/Replica | 16381/16382 | レプリケーション接続テスト |
| Memcached | 11211 | キャッシュ統合テスト |
| RabbitMQ | 5672 | AMQP メッセンジャー統合テスト |
| MongoDB | 27017 | ドキュメントDB統合テスト |
| Couchbase | 8091-8094, 11210 | Couchbase統合テスト |
| LocalStack (AWS) | 4566 | SQS/DynamoDB/SNS/SES エミュレーション |
| Kafka | 9092 | メッセージストリーミング統合テスト |
| OpenLDAP | 3389 | LDAP認証統合テスト |
| FTP | 21, 30000-30009 | ファイル転送統合テスト |
| FrankenPHP | 80, 8681-8684 | HTTPサーバー統合テスト |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| PHP | 8.4 / 8.5 / 8.6 | ランタイム（テスト対象） |
| PostgreSQL | 16 (Alpine) | リレーショナルデータベース（統合テスト） |
| PgBouncer | (apt default) | PostgreSQLコネクションプーリング（統合テスト） |
| Redis | 6.2.8 | キャッシュ、セッション、メッセンジャートランスポート |
| Redis Cluster | 6.2.8 | Redisクラスタ構成テスト |
| Redis Sentinel | 6.2.8 | Redis Sentinel構成テスト |
| Memcached | 1.6.5 | キャッシュ |
| RabbitMQ | 3.8.3 | AMQPメッセージブローカー |
| MongoDB | latest | ドキュメントストア |
| Couchbase | 6.5.1 | ドキュメント/キャッシュストア |
| LocalStack | 3.0.2 | AWSサービスエミュレーション（SQS、DynamoDB、SNS、SES） |
| Apache Kafka | 3.7 | メッセージストリーミング |
| Apache ZooKeeper | latest | Kafka用コーディネーションサービス |
| OpenLDAP | latest (Bitnami) | LDAPディレクトリサービス |
| FrankenPHP | 1.1.0 | PHP対応Webサーバー（Caddy） |
| Composer | latest-stable | PHPパッケージマネージャ |
| PHPUnit | 11.3 (XSD版) | テストフレームワーク |
| Symfony PHPUnit Bridge | 7.4 / 8.0 | テスト拡張 |
| Predis | 1.x / 2.x | Redis PHPクライアント |
| Doctrine DBAL | 4.3+ | データベース抽象化レイヤー |
| Doctrine ORM | 3.4+ | オブジェクト/リレーショナルマッパー |
| Twig | 3.21+ | テンプレートエンジン |
| Monolog | 3.0+ | ロギングライブラリ |

### PHP拡張モジュール

単体テスト環境で必要な拡張：

| 拡張名 | 用途 |
| --- | --- |
| amqp | RabbitMQ接続 |
| apcu | APCuキャッシュ |
| brotli | Brotli圧縮 |
| igbinary | バイナリシリアライゼーション |
| intl | 国際化 |
| mbstring | マルチバイト文字列 |
| memcached | Memcached接続 |
| redis | Redis接続 |
| relay | Relay（Redis高速クライアント） |
| zstd | Zstandard圧縮 |
| couchbase (3.2.2) | Couchbase接続（統合テスト） |
| mongodb (1.12.0) | MongoDB接続（統合テスト） |
| rdkafka | Apache Kafka接続（統合テスト） |
| xsl | XSL変換 |
| ldap | LDAP接続 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub Actions | CI/CDパイプライン実行 | GitHub webhook / push/PR トリガー |
| GitHub Code Scanning | SARIF結果のアップロード | GitHub API |
| OpenSSF Scorecard | サプライチェーンセキュリティ分析 | GitHub Actions連携 |
| Packagist / Composer | PHPパッケージ配布 | HTTPS（composer update） |
| Docker Hub / GitHub Container Registry | コンテナイメージのpull | HTTPS（docker pull） |
| Symfony Recipes API | Flexレシピ情報取得 | HTTPS |
| AWS (via LocalStack) | SQS / DynamoDB / SNS / SES のテスト | HTTP (localhost:4566) |

## スケーリング設計

本プロジェクトはPHPフレームワークライブラリであり、アプリケーションレベルのスケーリング設計は含まない。CI/CDパイプラインにおけるスケーリングは以下の方式で実現されている。

### CI/CDパイプラインの並列化

- **マトリクス戦略**: PHPバージョン（8.4/8.5/8.6）とdepsモード（default/high-deps/low-deps）の組み合わせにより最大5並列でテストを実行
- **コンポーネント並列テスト**: `parallel -j +3` コマンドにより各コンポーネントのテストを3並列以上で実行
- **concurrency制御**: 同一ブランチ/PRに対する重複ワークフローは `cancel-in-progress: true` で自動キャンセル
- **fail-fast無効化**: `fail-fast: false` により、1つのマトリクスジョブが失敗しても他のジョブは継続

### フレームワーク利用者向けスケーリング支援コンポーネント

- **symfony/cache**: Redis Cluster、Redis Sentinel、Memcached等の分散キャッシュバックエンドをサポート
- **symfony/lock**: DynamoDB、Redis等を用いた分散ロック
- **symfony/semaphore**: 分散セマフォ
- **symfony/messenger**: AMQP (RabbitMQ)、SQS、Redis、Kafka等の複数メッセージトランスポートをサポート
- **symfony/rate-limiter**: レートリミッター

## 可用性設計

CI/CDパイプラインの可用性はGitHub Actionsプラットフォームに依存する。テスト環境固有の可用性設計として以下が実装されている。

- **Redis Sentinel構成テスト**: Sentinel経由でのフェイルオーバーを検証するテスト環境が構築されている
- **Redis Primary/Replica構成テスト**: レプリケーション構成での接続を検証するテスト環境が構築されている
- **PgBouncer経由テスト**: コネクションプーリング経由でのPostgreSQL接続テストを実行
- **マルチプラットフォーム対応**: Ubuntu 24.04 および Windows 2022 の両方でテストを実行し、クロスプラットフォーム互換性を確保

フレームワークとしては、以下の可用性パターンをコンポーネントレベルでサポートしている。

- **キャッシュのChainAdapter**: 複数キャッシュバックエンドのフォールバック構成
- **Redis Sentinel/Cluster接続**: 高可用性Redis構成への接続サポート
- **Messenger再試行機構**: メッセージ処理失敗時の自動再試行

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Gitリポジトリ（GitHub） | push毎 | 無期限 |
| CI/CDアーティファクト（SARIF等） | GitHub Actions Artifacts | ワークフロー実行毎 | 5日間（Scorecards） |
| テストデータ | テスト実行時に動的生成 | テスト実行毎 | テスト完了時に破棄 |

本プロジェクトはライブラリであるため、永続データのバックアップ対象は存在しない。テスト用の各種サービス（PostgreSQL、Redis等）のデータはCI/CD実行ごとに初期化される一時的なものである。

## 監視設計

CI/CDパイプラインの監視は以下の方式で実現されている。

### GitHub Actions組み込み監視

- **ワークフロー実行結果**: GitHub UIおよびステータスバッジで確認可能
- **concurrency管理**: 同一ブランチの重複実行を自動抑制
- **fail-fast制御**: テスト失敗時の挙動を制御（無効化済み＝全マトリクス完走）

### セキュリティ監視

- **OpenSSF Scorecards**: 週次（毎週土曜4:34 UTC）でサプライチェーンセキュリティスコアを算出
- **SARIF出力**: セキュリティ分析結果をGitHub Code Scanningダッシュボードにアップロード
- **依存関係整合性チェック**: `deprecation-contracts`要件の自動検証ワークフロー

### テスト品質監視

- **PHPUnit設定**: `failOnDeprecation`, `failOnRisky`, `failOnWarning` を有効化し、品質劣化を早期検知
- **マルチPHPバージョンテスト**: PHP 8.4 / 8.5 / 8.6 での互換性を継続監視
- **依存関係バージョンテスト**: high-deps / low-deps モードでの互換性を継続監視

## 備考

### プロジェクト特性

本プロジェクトはSymfony PHPフレームワーク（v8.1.0-DEV）のモノリポジトリであり、以下の特性を持つ。

- **ライブラリプロジェクト**: アプリケーションデプロイ用のインフラ定義は含まれない
- **モノリポ構成**: 56以上のコンポーネント、5つのBundle、4つのBridgeを単一リポジトリで管理
- **splitsh.json**: 各コンポーネントを個別リポジトリに分割配布するための設定を含む

### 環境要件

- **PHP最低バージョン**: 8.4以上（`"php": ">=8.4"`）
- **必須PHP拡張**: ext-xml
- **Composer**: Runtime API 2.1以上

### CI/CDワークフロー一覧

| ワークフロー | トリガー | 目的 |
| --- | --- | --- |
| Unit Tests | push / pull_request | 単体テスト（PHP 8.4-8.6、3モード） |
| Integration | push / pull_request | 統合テスト（外部サービス連携） |
| Windows | push / pull_request | Windows環境互換性テスト |
| Verify Packages | pull_request (src/**) | パッケージメタファイル整合性検証 |
| Scorecards | push (8.1) / schedule / branch_protection_rule | サプライチェーンセキュリティ分析 |
| PHPUnit Bridge | push / pull_request | PHPUnit Bridge テスト |
| Psalm | push / pull_request | 静的解析 |
| Twig CS Fixer | push / pull_request | Twigコードスタイル検証 |
| Intl Data Tests | push / pull_request | 国際化データテスト |
| Fabbot | push / pull_request | コード品質チェック |
