---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 39
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：39 / 42、根拠なし：3
- 優先レビュー（高）
  1. **Twigの自動出力エスケープ**：Twigテンプレートエンジンのオートエスケープ設定はTwig側の設定であり、Symfonyブリッジのコードからは直接確認できなかった
  2. **HSTSヘッダー設定**：フレームワーク設定やWebサーバー設定に依存する部分であり、ソースコードからの直接的な根拠が不十分
  3. **監査ログの保持期間**：PSR-3ロガー設定に依存するため、フレームワークコードからは保持期間の具体値を確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Security/Http/Authenticator/AuthenticatorInterface.php`
- E-02: `src/Symfony/Component/Security/Http/Authenticator/FormLoginAuthenticator.php`
- E-03: `src/Symfony/Component/Security/Http/Authenticator/HttpBasicAuthenticator.php`
- E-04: `src/Symfony/Component/Security/Http/Authenticator/JsonLoginAuthenticator.php`
- E-05: `src/Symfony/Component/Security/Http/Authenticator/AccessTokenAuthenticator.php`
- E-06: `src/Symfony/Component/Security/Http/Authenticator/RememberMeAuthenticator.php`
- E-07: `src/Symfony/Component/Security/Http/Authenticator/Passport/Passport.php`
- E-08: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/CsrfTokenBadge.php`
- E-09: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/RememberMeBadge.php`
- E-10: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/PasswordUpgradeBadge.php`
- E-11: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/UserBadge.php`
- E-12: `src/Symfony/Component/Security/Http/Authenticator/Passport/Credentials/PasswordCredentials.php`
- E-13: `src/Symfony/Component/Security/Http/Session/SessionAuthenticationStrategy.php`
- E-14: `src/Symfony/Component/Security/Csrf/CsrfTokenManager.php`
- E-15: `src/Symfony/Component/Security/Csrf/SameOriginCsrfTokenManager.php`
- E-16: `src/Symfony/Component/PasswordHasher/Hasher/NativePasswordHasher.php`
- E-17: `src/Symfony/Component/PasswordHasher/Hasher/SodiumPasswordHasher.php`
- E-18: `src/Symfony/Component/PasswordHasher/Hasher/PasswordHasherFactory.php`
- E-19: `src/Symfony/Component/Security/Core/Signature/SignatureHasher.php`
- E-20: `src/Symfony/Component/Security/Core/Authorization/AccessDecisionManager.php`
- E-21: `src/Symfony/Component/Security/Core/Authorization/Voter/VoterInterface.php`
- E-22: `src/Symfony/Component/Security/Core/Authorization/Voter/RoleVoter.php`
- E-23: `src/Symfony/Component/Security/Core/Authorization/Voter/AuthenticatedVoter.php`
- E-24: `src/Symfony/Component/Security/Http/Firewall.php`
- E-25: `src/Symfony/Component/Security/Http/AccessMap.php`
- E-26: `src/Symfony/Component/Security/Http/EventListener/LoginThrottlingListener.php`
- E-27: `src/Symfony/Component/Security/Http/EventListener/CsrfProtectionListener.php`
- E-28: `src/Symfony/Component/Security/Http/EventListener/CheckCredentialsListener.php`
- E-29: `src/Symfony/Component/Security/Http/EventListener/ClearSiteDataLogoutListener.php`
- E-30: `src/Symfony/Component/Security/Http/RateLimiter/DefaultLoginRateLimiter.php`
- E-31: `src/Symfony/Component/Security/Http/RememberMe/AbstractRememberMeHandler.php`
- E-32: `src/Symfony/Component/Security/Http/RememberMe/SignatureRememberMeHandler.php`
- E-33: `src/Symfony/Component/Security/Http/AccessToken/HeaderAccessTokenExtractor.php`
- E-34: `src/Symfony/Component/Security/Http/AccessToken/Oidc/OidcTokenHandler.php`
- E-35: `src/Symfony/Component/Security/Http/Attribute/IsGranted.php`
- E-36: `src/Symfony/Component/Security/Http/Attribute/IsCsrfTokenValid.php`
- E-37: `src/Symfony/Bundle/WebProfilerBundle/Csp/ContentSecurityPolicyHandler.php`
- E-38: `src/Symfony/Component/Security/Core/Authorization/Strategy/AffirmativeStrategy.php`
- E-39: `composer.json`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AuthenticatorInterfaceに基づく統一的な認証システムを採用 | E-01 | ○ |
| C-02 | FormLoginAuthenticatorがHTMLフォーム認証を提供、CSRF保護オプション付き | E-02 | ○ |
| C-03 | HttpBasicAuthenticatorがRFC7617 Basic認証を提供 | E-03 | ○ |
| C-04 | JsonLoginAuthenticatorがJSONベースのステートレス認証を提供 | E-04 | ○ |
| C-05 | AccessTokenAuthenticatorがRFC6750 Bearer認証を提供 | E-05 | ○ |
| C-06 | RememberMeAuthenticatorがCookieベースの再認証を提供 | E-06 | ○ |
| C-07 | Passportオブジェクト中心の認証フロー設計 | E-07, E-12 | ○ |
| C-08 | CsrfTokenBadge、RememberMeBadge、PasswordUpgradeBadge等のBadge一覧 | E-08, E-09, E-10, E-11 | ○ |
| C-09 | SessionAuthenticationStrategyがnone/migrate/invalidate戦略をサポート | E-13 | ○ |
| C-10 | migrate戦略時にCSRFトークンストレージを自動クリア | E-13 | ○ |
| C-11 | Remember Meクッキーのデフォルト設定（httponly=true、lifetime=31536000等） | E-31 | ○ |
| C-12 | RoleVoterがROLE_プレフィックスの属性を評価 | E-22 | ○ |
| C-13 | AuthenticatedVoterがIS_AUTHENTICATED_FULLY等の認証レベルを評価 | E-23 | ○ |
| C-14 | AccessDecisionManagerがAffirmativeStrategy（デフォルト）を使用 | E-20, E-38 | ○ |
| C-15 | Affirmative/Consensus/Unanimous/Priority戦略が利用可能 | E-20 | ○ |
| C-16 | FirewallがHTTPカーネルイベントをリッスンしセキュリティリスナーを登録 | E-24 | ○ |
| C-17 | AccessMapがURLパターンベースのアクセス制御ルールを定義 | E-25 | ○ |
| C-18 | #[IsGranted]アトリビュートによる宣言的認可チェック | E-35 | ○ |
| C-19 | SameOriginCsrfTokenManagerがHTTPS時に__Host-プレフィックスを付与 | E-15 | ○ |
| C-20 | ClearSiteDataLogoutListenerがログアウト時にClear-Site-Dataヘッダーを設定 | E-29 | ○ |
| C-21 | NativePasswordHasherがbcrypt（cost=13デフォルト）、Argon2i、Argon2idをサポート | E-16 | ○ |
| C-22 | bcryptの72バイト制限をSHA-512 Base64エンコードで回避 | E-16 | ○ |
| C-23 | SodiumPasswordHasherがlibsodiumを使用、opsLimit >= 3、memLimit >= 10KB | E-17 | ○ |
| C-24 | MigratingPasswordHasherによるパスワードハッシュの自動マイグレーション | E-18 | ○ |
| C-25 | SignatureHasherがHMAC-SHA256を使用、hash_equals()でタイミング攻撃対策 | E-19 | ○ |
| C-26 | CsrfTokenManagerがXOR + 32バイトランダムキーでトークンをランダム化 | E-14 | ○ |
| C-27 | OidcTokenHandlerがJWS署名検証、JWE復号、クレーム検証を実施 | E-34 | ○ |
| C-28 | CheckPasswordLengthTraitによる最大4096バイトのパスワード長制限 | E-16, E-17 | ○ |
| C-29 | #[\SensitiveParameter]によるスタックトレースからの機密情報隠蔽 | E-16, E-17, E-19, E-30 | ○ |
| C-30 | DefaultLoginRateLimiterがIPとユーザー名+IPの二層レート制限を提供 | E-30 | ○ |
| C-31 | LoginThrottlingListenerがCheckPassportEventでレート制限チェックを実施 | E-26 | ○ |
| C-32 | CsrfProtectionListenerがPassportのCsrfTokenBadgeを検証 | E-27 | ○ |
| C-33 | CheckCredentialsListenerがPasswordHasherFactoryを使用してパスワード検証 | E-28 | ○ |
| C-34 | SameOriginCsrfTokenManagerがSec-Fetch-Site/Origin/Refererによるオリジン検証を実施 | E-15 | ○ |
| C-35 | SameOriginCsrfTokenManagerがダブルサブミットクッキーによるCSRF保護を提供 | E-15 | ○ |
| C-36 | SameOriginCsrfTokenManagerの検証方式ダウングレード防止機能 | E-15 | ○ |
| C-37 | HeaderAccessTokenExtractorがAuthorizationヘッダーからBearerトークンを抽出 | E-33 | ○ |
| C-38 | #[IsCsrfTokenValid]アトリビュートによる宣言的CSRF保護 | E-36 | ○ |
| C-39 | ContentSecurityPolicyHandlerがCSPヘッダーにnonce値を自動挿入 | E-37 | ○ |
| C-40 | Twigテンプレートエンジンによる自動出力エスケープ（XSS対策） | **根拠なし** | △ |
| C-41 | HSTSヘッダー設定の対応 | **根拠なし** | △ |
| C-42 | 監査ログの保持期間がPSR-3ロガー設定に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-40（Twig自動エスケープ）**：Twig自体の設定（`autoescape`オプション）はTwigライブラリ側で管理されており、Symfonyフレームワークソースからは直接的な設定値を確認できなかった。SymfonyはTwig Bundleの`framework.twig`設定でデフォルトの自動エスケープを有効にしているが、そのDI設定ファイル自体の確認が不足している
  - 候補：`src/Symfony/Bundle/TwigBundle/DependencyInjection/Configuration.php` / `src/Symfony/Bundle/TwigBundle/Resources/config/twig.php` / Twig本体のドキュメント
- **C-41（HSTS）**：Symfonyフレームワーク自体にはHSTSヘッダーを直接設定する専用コンポーネントは存在しない。一般的にはWebサーバー（nginx, Apache）またはミドルウェア/イベントリスナーで設定される
  - 候補：Webサーバー設定 / `framework.yaml`のheaders設定 / カスタムEventListener
- **C-42（ログ保持期間）**：ログの保持期間はPSR-3ロガー実装（Monolog等）の設定に依存する。Symfonyフレームワーク自体はログの保持期間を制御しない
  - 候補：`monolog.yaml`設定 / ログローテーション設定 / インフラ設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証方式一覧（C-01〜C-06）：ソースコードから直接確認でき、クラス構造と一致
- **0: 低リスク** - CSRF保護（C-26, C-32, C-34〜C-36）：詳細なソースコード分析に基づく
- **0: 低リスク** - パスワードハッシュ（C-21〜C-24）：ソースコードのアルゴリズム設定とデフォルト値を直接確認
- **1: 中リスク** - XSS対策（C-40）：Twig自動エスケープはSymfonyの標準機能だが、本分析ではTwigBundle DI設定の直接確認が不足
- **1: 中リスク** - HSTS（C-41）：フレームワーク外の設定に依存するため、プロジェクト固有の確認が必要
- **0: 低リスク** - 監査ログ（C-42）：ロガーの存在と使用パターンはソースコードで確認済みだが、保持期間は運用設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] TwigBundleのDI設定でautoescapeがデフォルト有効になっていることを確認する
- [ ] プロジェクトのsecurity.yaml設定とここに記載された認証・認可方式が一致することを確認する
- [ ] Remember Meクッキーのsecure/samesiteオプションが本番環境で適切に設定されていることを確認する
- [ ] LoginThrottlingのレート制限値（globalFactory/localFactory）がプロジェクト要件に合致することを確認する
- [ ] HSTSヘッダーがWebサーバーまたはアプリケーション設定で適切に設定されていることを確認する
- [ ] SameOriginCsrfTokenManager非推奨メソッドのSameOriginCsrfListenerへの移行状況を確認する
- [ ] OIDCトークンハンドラーのissuer/audience設定が正しいことを確認する
- [ ] パスワードハッシュアルゴリズム（auto/bcrypt/argon2id等）がプロジェクトのセキュリティ要件を満たすことを確認する
