---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標の明示的数値未設定の主張**：プロジェクト方針ドキュメントが未確認のため根拠不足
  2. **不具合管理における GitHub Issues 使用の主張**：リポジトリ設定の直接確認ができないため根拠不足
  3. **各パッケージが独自の phpunit.xml.dist を持つ主張**：ローカル環境で Tests ディレクトリ・phpunit.xml.dist が存在しないため直接確認不可（CI 設定では参照あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `phpunit.xml.dist`（プロジェクトルート）
- E-02: `composer.json`（プロジェクトルート）
- E-03: `.github/workflows/unit-tests.yml`
- E-04: `.github/workflows/integration-tests.yml`
- E-05: `.github/workflows/windows.yml`
- E-06: `.github/workflows/intl-data-tests.yml`
- E-07: `.github/workflows/package-tests.yml`
- E-08: `.github/workflows/psalm.yml`
- E-09: `.github/workflows/phpunit-bridge.yml`
- E-10: `.github/workflows/fabbot.yml`
- E-11: `.github/workflows/twig-cs-fixer.yml`
- E-12: `.github/workflows/scorecards.yml`
- E-13: `psalm.xml`
- E-14: `.php-cs-fixer.dist.php`
- E-15: `.twig-cs-fixer.dist.php`（ファイル存在を確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PHPUnit 11.3 以上をテストフレームワークとして使用 | E-01（schema URL に 11.3 を参照） | ○ |
| C-02 | テストスイートは Bridge/Component/Contracts/Bundle の Tests/ ディレクトリを対象 | E-01（testsuites 定義） | ○ |
| C-03 | benchmark, intl-data グループを通常テストから除外 | E-01（groups/exclude 定義） | ○ |
| C-04 | failOnDeprecation, failOnRisky, failOnWarning を true に設定 | E-01（属性定義） | ○ |
| C-05 | SymfonyExtension を PHPUnit 拡張として登録し、クロックモックを提供 | E-01（extensions 定義） | ○ |
| C-06 | PHP >= 8.4 が必須要件 | E-02（require.php: ">=8.4"） | ○ |
| C-07 | Symfony PHPUnit Bridge を開発依存として使用 | E-02（require-dev: symfony/phpunit-bridge） | ○ |
| C-08 | 単体テストは PHP 8.4 / 8.5 / 8.6 のマトリクスで実行 | E-03（strategy.matrix.include） | ○ |
| C-09 | high-deps / low-deps / default の3モードでテスト実行 | E-03（matrix.mode 定義） | ○ |
| C-10 | テスト実行環境は Ubuntu 24.04 | E-03（runs-on: ubuntu-24.04） | ○ |
| C-11 | 拡張は amqp, apcu, brotli, igbinary, intl, mbstring, memcached, redis, relay, zstd | E-03（env.extensions） | ○ |
| C-12 | GNU parallel でコンポーネント単位の並列テスト実行 | E-03（parallel -j +3 コマンド） | ○ |
| C-13 | TTY テストは script コマンド経由で別途実行 | E-03（Run TTY tests ステップ） | ○ |
| C-14 | SIGCHLD 対応テストを PHP 8.4 で実行 | E-03（Run tests with SIGCHLD enabled PHP ステップ） | ○ |
| C-15 | PHPUnit Bridge の PHPUnit 9.6 後方互換性テストを実行 | E-03（Run PhpUnitBridge tests with PHPUnit 9.6 ステップ） | ○ |
| C-16 | 結合テストで PostgreSQL 16, Redis, Memcached, RabbitMQ, MongoDB, Couchbase, LocalStack, Kafka, Zookeeper, OpenLDAP, FTP, FrankenPHP を使用 | E-04（services 定義） | ○ |
| C-17 | 結合テストは --group integration で実行 | E-04（Run tests ステップ） | ○ |
| C-18 | pgbouncer を結合テスト環境でインストール・設定 | E-04（Install pgbouncer ステップ） | ○ |
| C-19 | Windows x86 環境で最小拡張・全拡張の2構成でテスト | E-05（2つの jobs 定義） | ○ |
| C-20 | Intl/Emoji データテストは対象パス変更時にトリガー | E-06（on.push.paths / on.pull_request.paths） | ○ |
| C-21 | 圧縮前後の両方で Intl/Emoji テストを実行 | E-06（compress スクリプト実行後の再テスト） | ○ |
| C-22 | パッケージメタデータ（LICENSE, CHANGELOG.md, README.md 等）の検証 | E-07（Verify meta files ステップ） | ○ |
| C-23 | Psalm による静的型解析を PR 時に実行 | E-08（on: pull_request） | ○ |
| C-24 | Psalm の errorLevel は 5 | E-13（errorLevel="5"） | ○ |
| C-25 | Psalm ベースラインを .github/psalm/psalm.baseline.xml で管理 | E-13（errorBaseline 属性） | ○ |
| C-26 | PHP-CS-Fixer で @Symfony / @Symfony:risky ルールセットを適用 | E-14（setRules メソッド） | ○ |
| C-27 | Twig CS Fixer ^3.9.0 による Twig テンプレートの lint | E-11（composer require 内のバージョン指定） | ○ |
| C-28 | Fabbot による PR 上でのコーディング規約チェック | E-10（uses: symfony-tools/fabbot） | ○ |
| C-29 | OpenSSF Scorecard v2.4.1 による supply-chain セキュリティ分析 | E-12（uses: ossf/scorecard-action） | ○ |
| C-30 | concurrency 設定で同一ワークフロー・同一ブランチの重複実行を防止 | E-03, E-04, E-05 等（concurrency 設定） | ○ |
| C-31 | memory_limit=-1 でテスト実行 | E-01（ini name="memory_limit" value="-1"）, E-03（ini-values） | ○ |
| C-32 | error_reporting=-1 で全エラー検出 | E-01（ini name="error_reporting" value="-1"） | ○ |
| C-33 | カバレッジ計測は通常の CI 実行では無効化（coverage: "none"） | E-03（coverage: "none"） | ○ |
| C-34 | 明示的なカバレッジ数値目標は設定されていない | **根拠なし** | △ |
| C-35 | 不具合管理に GitHub Issues を使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-34: カバレッジ目標の未設定について、プロジェクトの方針ドキュメント・CONTRIBUTING.md 等に明示的な記載があるか確認が必要。CI 設定（coverage: "none"）からカバレッジ計測を行っていないことは確認できるが、「目標がない」という主張の直接的な根拠は存在しない。
  - 候補：CONTRIBUTING.md / プロジェクト Wiki / 公式ドキュメント
- C-35: GitHub Issues の使用について、リポジトリ設定やイシューテンプレートの直接確認ができなかった。Symfony が GitHub Issues を使用していることは一般的に知られているが、本プロジェクトのローカルファイルからの直接的な根拠がない。
  - 候補：.github/ISSUE_TEMPLATE/ / リポジトリ設定 / CONTRIBUTING.md
- 各パッケージの Tests/ ディレクトリと phpunit.xml.dist の実在について、ローカル環境では Git の sparse checkout またはパッケージ未展開のため直接確認できなかった。CI ワークフロー内の find コマンドで phpunit.xml.dist の存在を前提とした処理が確認できるため、間接的な根拠としている。
  - 候補：完全な Git クローン / パッケージの個別確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストフレームワーク・ツール・CI/CD 設定の記載はすべて設定ファイルから直接確認可能
- 0: 低リスク - テスト環境の構成情報は GitHub Actions ワークフローから正確に読み取れる
- 1: 中リスク - カバレッジ目標に関する記載は、「目標がない」という否定的主張であり、見落としている可能性がある
- 0: 低リスク - CI/CD ワークフローの一覧と構成は yml ファイルから網羅的に確認済み
- 1: 中リスク - テストデータの記載は CI ワークフロー内のコマンドから推察した部分があり、実際のファイル構成との差異がある可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標について、プロジェクトの公式方針ドキュメントを確認し、数値目標の有無を検証する
- [ ] GitHub Issues / イシューテンプレートの存在を確認し、不具合管理セクションの記載を検証する
- [ ] 完全な Git クローンで各パッケージの Tests/ ディレクトリと phpunit.xml.dist の存在を確認する
- [ ] テストデータセクションの Fixtures ディレクトリ構成が実際のプロジェクト構造と一致するか検証する
- [ ] CI/CD ワークフローの記載が最新の .github/workflows/ の内容と一致するか確認する
