# ER図

## 概要

Symfony 8.1フレームワークが内部的に使用するデータベーステーブルのER図を以下に示す。これらのテーブルはそれぞれ独立した基盤機能（認証、キャッシュ、セッション、ロック）に属しており、テーブル間のリレーションシップは存在しない。各テーブルは個別の機能コンポーネントによって管理され、アプリケーションのユーザーテーブル等との外部キー制約もフレームワーク側では定義していない。

## ER図（Mermaid形式）

```mermaid
erDiagram
    rememberme_token {
        char(88) series PK "トークンシリーズID"
        char(88) value "トークン値"
        datetime lastUsed "最終使用日時"
        varchar(100) class "ユーザークラス名（BC用、デフォルト空文字）"
        varchar(200) username "ユーザー識別子"
    }

    cache_items {
        varbinary(255) item_id PK "キャッシュアイテムID"
        mediumblob item_data "キャッシュデータ"
        integer_unsigned item_lifetime "有効期間（秒、NULLで無期限）"
        integer_unsigned item_time "保存時刻（UNIXタイムスタンプ）"
    }

    sessions {
        varbinary(128) sess_id PK "セッションID"
        blob sess_data "セッションデータ"
        integer sess_lifetime "有効期限（UNIXタイムスタンプ）"
        integer sess_time "最終更新時刻（UNIXタイムスタンプ）"
    }

    lock_keys {
        varchar(64) key_id PK "ロックキーSHA-256ハッシュ"
        varchar(44) key_token "ロックトークン"
        integer_unsigned key_expiration "有効期限（UNIXタイムスタンプ）"
    }
```

## 補足

- 上記4テーブルはすべて独立しており、テーブル間のリレーションシップは存在しない
- 各テーブルはSymfonyの異なるコンポーネントが個別に管理する
- テーブル名およびカラム名はコンフィグレーションオプションにより変更可能であるため、実際の環境では異なる名称が使用される場合がある
- `rememberme_token.username` はアプリケーション側のユーザーテーブルと論理的に関連するが、外部キー制約はフレームワーク側では定義しない
- データ型はMySQL基準で記載している。プラットフォーム別の差異はデータベース設計書の備考を参照
