---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **MessengerトランスポートのDoctrine テーブル定義**：本リポジトリ内にテーブル定義が存在せず、外部パッケージ参照のみ
  2. **DynamoDB属性の完全な定義**：createTable()でidAttrのみKeySchemaに含まれ、token/expirationの型定義はDynamoDB側の動的スキーマに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bridge/Doctrine/Security/RememberMe/DoctrineTokenProvider.php` - rememberme_tokenテーブルのスキーマ定義（addTableToSchema, CREATE TABLE コメント）
- E-02: `src/Symfony/Component/Cache/Adapter/DoctrineDbalAdapter.php` - cache_itemsテーブルのスキーマ定義（addTableToSchema）
- E-03: `src/Symfony/Component/Cache/Adapter/PdoAdapter.php` - cache_itemsテーブルのCREATE TABLE SQL（createTable）
- E-04: `src/Symfony/Component/HttpFoundation/Session/Storage/Handler/PdoSessionHandler.php` - sessionsテーブルのスキーマ定義（configureSchema, createTable）
- E-05: `src/Symfony/Component/Lock/Store/DoctrineDbalStore.php` - lock_keysテーブルのスキーマ定義（configureSchema）
- E-06: `src/Symfony/Component/Lock/Store/PdoStore.php` - lock_keysテーブルのCREATE TABLE SQL（createTable）
- E-07: `src/Symfony/Component/Lock/Store/DatabaseTableTrait.php` - lock_keysテーブルのデフォルトカラム名定義
- E-08: `src/Symfony/Component/Lock/Bridge/DynamoDb/Store/DynamoDbStore.php` - DynamoDBテーブルの属性定義
- E-09: `src/Symfony/Component/Lock/Store/DoctrineDbalPostgreSqlStore.php` - PostgreSQLアドバイザリーロック（テーブル不使用）
- E-10: `src/Symfony/Bridge/Doctrine/SchemaListener/PdoSessionHandlerSchemaListener.php` - sessionsスキーマリスナー
- E-11: `src/Symfony/Bridge/Doctrine/SchemaListener/DoctrineDbalCacheAdapterSchemaListener.php` - cache_itemsスキーマリスナー
- E-12: `src/Symfony/Bridge/Doctrine/SchemaListener/LockStoreSchemaListener.php` - lock_keysスキーマリスナー
- E-13: `src/Symfony/Bridge/Doctrine/SchemaListener/RememberMeTokenProviderDoctrineSchemaListener.php` - rememberme_tokenスキーマリスナー
- E-14: `src/Symfony/Bridge/Doctrine/SchemaListener/MessengerTransportDoctrineSchemaListener.php` - MessengerトランスポートDoctrineスキーマリスナー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rememberme_tokenテーブルはseriesカラム（CHAR(88)）を主キーとして持つ | E-01 | ○ |
| C-02 | rememberme_tokenテーブルのvalue, lastUsed, class, usernameカラムの型とNULL制約 | E-01 | ○ |
| C-03 | classカラムはSymfony 8以前との後方互換性のためにデフォルト空文字で保持される | E-01 | ○ |
| C-04 | cache_itemsテーブルはitem_idカラムを主キーとし、最大255文字 | E-02, E-03 | ○ |
| C-05 | cache_itemsのitem_dataはMEDIUMBLOB（MySQL）で最大16MB | E-02 | ○ |
| C-06 | cache_itemsのitem_lifetimeはNULL許容（NULLで無期限キャッシュ） | E-02, E-03 | ○ |
| C-07 | cache_itemsのテーブル名・カラム名はオプションで変更可能 | E-02, E-03 | ○ |
| C-08 | sessionsテーブルはsess_idカラム（最大128文字）を主キーとする | E-04 | ○ |
| C-09 | sessionsテーブルにsess_lifetime_idxインデックスが存在する | E-04 | ○ |
| C-10 | sessionsテーブルのsess_dataはBLOB/BYTEA型でバイナリデータを格納 | E-04 | ○ |
| C-11 | sessionsのテーブル名・カラム名はオプションで変更可能 | E-04 | ○ |
| C-12 | lock_keysテーブルはkey_idカラム（VARCHAR(64)）を主キーとする | E-05, E-06, E-07 | ○ |
| C-13 | lock_keysのkey_tokenはDoctrineDbalStoreでVARCHAR(44)、PdoStore(pgsql)でVARCHAR(64) | E-05, E-06 | ○ |
| C-14 | lock_keysのGC確率デフォルトは0.01 | E-07 | ○ |
| C-15 | lock_keysのテーブル名・カラム名はオプションで変更可能 | E-07 | ○ |
| C-16 | MySQLではcache_items.item_idにVARBINARYを使用する理由（文字セット変換防止等） | E-03 | ○ |
| C-17 | MySQLではsessions.sess_idにVARBINARYを使用する理由（文字セット変換防止等） | E-04 | ○ |
| C-18 | DynamoDbStoreはkey_id（パーティションキー）、key_token、key_expirationの属性を使用 | E-08 | ○ |
| C-19 | DoctrineDbalPostgreSqlStoreはテーブルを使用せずpg_advisory_lockを使用 | E-09 | ○ |
| C-20 | Doctrineスキーマリスナーによりマイグレーションにテーブルが自動含有される | E-10, E-11, E-12, E-13, E-14 | ○ |
| C-21 | 4テーブル間にリレーションシップは存在しない | E-01, E-02, E-04, E-05 | ○ |
| C-22 | rememberme_token.usernameはアプリケーション側ユーザーテーブルと論理的に関連する | E-01 | ○ |
| C-23 | Messengerトランスポートテーブルは外部パッケージで定義される | **根拠なし**（リポジトリ内にテーブル定義が存在しない） | △ |
| C-24 | DynamoDBのtoken, expiration属性の型はS, N型である | **根拠なし**（createTableにはidAttrのみ定義、他はPutItemの動的属性） | △ |

## 4) 不足情報（Unknown / Missing）
- Messengerトランスポート用Doctrineテーブルの定義がリポジトリ内に存在しない
  - 候補：`symfony/doctrine-messenger` パッケージ / Symfony公式ドキュメント / `DoctrineTransport` クラス
- DynamoDBのtoken_attr, expiration_attr属性の正確なDynamoDB型定義
  - 候補：`DynamoDbStore::save()` メソッド内のPutItemInputの `AttributeValue` 定義 / AWS DynamoDB公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル定義はソースコード内のCREATE TABLE文およびconfigureSchema()メソッドから直接抽出しており、高い信頼性がある
- 1: 中リスク - プラットフォーム別データ型差異の一覧は複数ソースからの統合であり、一部のプラットフォーム（Oracle, SQL Server）は実際のテスト環境での検証が推奨される
- 1: 中リスク - MessengerトランスポートのDoctrineテーブル定義は本リポジトリの範囲外であるため、実際の利用時には別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] rememberme_tokenテーブルの各カラムのデータ型とNULL制約がソースコードのCREATE TABLE文と一致しているか
- [ ] cache_itemsテーブルのデフォルトテーブル名・カラム名がソースコードのプロパティ定義と一致しているか
- [ ] sessionsテーブルのインデックス定義（sess_lifetime_idx）がソースコードのcreateTable()と一致しているか
- [ ] lock_keysテーブルのkey_tokenカラムのサイズがDoctrineDbalStore（44）とPdoStore（64）で異なる点が正しいか
- [ ] プラットフォーム別データ型差異表がソースコードのswitch/match文の分岐と一致しているか
- [ ] Messengerトランスポートテーブルに関する記述が「外部パッケージ」としての言及にとどまっていることが適切か
