---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 69
  claims_with_evidence: 69
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：69 / 69、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全コマンドの名前・説明は `#[AsCommand]` アトリビュートから直接抽出しており、根拠不足の項目はありません
  2. **カテゴリ分類の妥当性**：カテゴリはソースコードのディレクトリ構造（Bundle/Component）に基づいて分類。レビュアーによる確認を推奨
  3. **重複コマンドの取り扱い**：`lint:twig`, `lint:xliff`, `lint:yaml`, `server:dump` は Bundle 側とComponent/Bridge 側の両方に実装が存在。Bundle側をメインとして採用

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/CacheClearCommand.php` - `#[AsCommand(name: 'cache:clear', description: 'Clear the cache')]`
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/CacheWarmupCommand.php` - `#[AsCommand(name: 'cache:warmup', description: 'Warm up an empty cache')]`
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolClearCommand.php` - `#[AsCommand(name: 'cache:pool:clear', description: 'Clear cache pools')]`
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolDeleteCommand.php` - `#[AsCommand(name: 'cache:pool:delete', description: 'Delete an item from a cache pool')]`
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolListCommand.php` - `#[AsCommand(name: 'cache:pool:list', description: 'List available cache pools')]`
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolPruneCommand.php` - `#[AsCommand(name: 'cache:pool:prune', description: 'Prune cache pools')]`
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolInvalidateTagsCommand.php` - `#[AsCommand(name: 'cache:pool:invalidate-tags', ...)]`
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsSetCommand.php` - `#[AsCommand(name: 'secrets:set', ...)]`
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRemoveCommand.php` - `#[AsCommand(name: 'secrets:remove', ...)]`
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsListCommand.php` - `#[AsCommand(name: 'secrets:list', ...)]`
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` - `#[AsCommand(name: 'secrets:reveal', ...)]`
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` - `#[AsCommand(name: 'secrets:generate-keys', ...)]`
- E-13: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` - `#[AsCommand(name: 'secrets:decrypt-to-local', ...)]`
- E-14: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` - `#[AsCommand(name: 'secrets:encrypt-from-local', ...)]`
- E-15: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` - `#[AsCommand(name: 'debug:config', ...)]`
- E-16: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` - `#[AsCommand(name: 'debug:container', ...)]`
- E-17: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` - `#[AsCommand(name: 'debug:autowiring', ...)]`
- E-18: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` - `#[AsCommand(name: 'debug:event-dispatcher', ...)]`
- E-19: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` - `#[AsCommand(name: 'debug:router', ...)]`
- E-20: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` - `#[AsCommand(name: 'debug:translation', ...)]`
- E-21: `src/Symfony/Bundle/FrameworkBundle/Command/RouterMatchCommand.php` - `#[AsCommand(name: 'router:match', ...)]`
- E-22: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDumpReferenceCommand.php` - `#[AsCommand(name: 'config:dump-reference', ...)]`
- E-23: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` - `#[AsCommand(name: 'assets:install', ...)]`
- E-24: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` - `#[AsCommand(name: 'translation:extract', ...)]`
- E-25: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerLintCommand.php` - `#[AsCommand(name: 'lint:container', ...)]`
- E-26: `src/Symfony/Bundle/FrameworkBundle/Command/XliffLintCommand.php` - `#[AsCommand(name: 'lint:xliff', ...)]`
- E-27: `src/Symfony/Bundle/FrameworkBundle/Command/YamlLintCommand.php` - `#[AsCommand(name: 'lint:yaml', ...)]`
- E-28: `src/Symfony/Bundle/FrameworkBundle/Command/AboutCommand.php` - `#[AsCommand(name: 'about', ...)]`
- E-29: `src/Symfony/Bundle/SecurityBundle/Command/DebugFirewallCommand.php` - `#[AsCommand(name: 'debug:firewall', ...)]`
- E-30: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php` - `#[AsCommand(name: 'debug:security:role-hierarchy', ...)]`
- E-31: `src/Symfony/Bundle/TwigBundle/Command/LintCommand.php` - `#[AsCommand(name: 'lint:twig', ...)]`
- E-32: `src/Symfony/Bundle/DebugBundle/Command/ServerDumpPlaceholderCommand.php` - `#[AsCommand(name: 'server:dump', ...)]`
- E-33: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:twig', ...)]`
- E-34: `src/Symfony/Bridge/Monolog/Command/ServerLogCommand.php` - `#[AsCommand(name: 'server:log', ...)]`
- E-35: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` - `#[AsCommand(name: 'messenger:consume', ...)]`
- E-36: `src/Symfony/Component/Messenger/Command/SetupTransportsCommand.php` - `#[AsCommand(name: 'messenger:setup-transports', ...)]`
- E-37: `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` - `#[AsCommand(name: 'messenger:stop-workers', ...)]`
- E-38: `src/Symfony/Component/Messenger/Command/StatsCommand.php` - `#[AsCommand(name: 'messenger:stats', ...)]`
- E-39: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` - `#[AsCommand(name: 'messenger:failed:show', ...)]`
- E-40: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` - `#[AsCommand(name: 'messenger:failed:retry', ...)]`
- E-41: `src/Symfony/Component/Messenger/Command/FailedMessagesRemoveCommand.php` - `#[AsCommand(name: 'messenger:failed:remove', ...)]`
- E-42: `src/Symfony/Component/Messenger/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:messenger', ...)]`
- E-43: `src/Symfony/Component/Translation/Command/TranslationPushCommand.php` - `#[AsCommand(name: 'translation:push', ...)]`
- E-44: `src/Symfony/Component/Translation/Command/TranslationPullCommand.php` - `#[AsCommand(name: 'translation:pull', ...)]`
- E-45: `src/Symfony/Component/Translation/Command/TranslationLintCommand.php` - `#[AsCommand(name: 'lint:translations', ...)]`
- E-46: `src/Symfony/Component/AssetMapper/Command/AssetMapperCompileCommand.php` - `#[AsCommand(name: 'asset-map:compile', ...)]`
- E-47: `src/Symfony/Component/AssetMapper/Command/CompressAssetsCommand.php` - `#[AsCommand(name: 'assets:compress', ...)]`
- E-48: `src/Symfony/Component/AssetMapper/Command/DebugAssetMapperCommand.php` - `#[AsCommand(name: 'debug:asset-map', ...)]`
- E-49: `src/Symfony/Component/AssetMapper/Command/ImportMapRequireCommand.php` - `#[AsCommand(name: 'importmap:require', ...)]`
- E-50: `src/Symfony/Component/AssetMapper/Command/ImportMapRemoveCommand.php` - `#[AsCommand(name: 'importmap:remove', ...)]`
- E-51: `src/Symfony/Component/AssetMapper/Command/ImportMapInstallCommand.php` - `#[AsCommand(name: 'importmap:install', ...)]`
- E-52: `src/Symfony/Component/AssetMapper/Command/ImportMapUpdateCommand.php` - `#[AsCommand(name: 'importmap:update', ...)]`
- E-53: `src/Symfony/Component/AssetMapper/Command/ImportMapOutdatedCommand.php` - `#[AsCommand(name: 'importmap:outdated', ...)]`
- E-54: `src/Symfony/Component/AssetMapper/Command/ImportMapAuditCommand.php` - `#[AsCommand(name: 'importmap:audit', ...)]`
- E-55: `src/Symfony/Component/Dotenv/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:dotenv', ...)]`
- E-56: `src/Symfony/Component/Dotenv/Command/DotenvDumpCommand.php` - `#[AsCommand(name: 'dotenv:dump', ...)]`
- E-57: `src/Symfony/Component/ErrorHandler/Command/ErrorDumpCommand.php` - `#[AsCommand(name: 'error:dump', ...)]`
- E-58: `src/Symfony/Component/Form/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:form', ...)]`
- E-59: `src/Symfony/Component/Mailer/Command/MailerTestCommand.php` - `#[AsCommand(name: 'mailer:test', ...)]`
- E-60: `src/Symfony/Component/PasswordHasher/Command/UserPasswordHashCommand.php` - `#[AsCommand(name: 'security:hash-password', ...)]`
- E-61: `src/Symfony/Component/Scheduler/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:scheduler', ...)]`
- E-62: `src/Symfony/Component/Security/Http/Command/OidcTokenGenerateCommand.php` - `#[AsCommand(name: 'security:oidc:generate-token', ...)]`
- E-63: `src/Symfony/Component/Serializer/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:serializer', ...)]`
- E-64: `src/Symfony/Component/Uid/Command/GenerateUuidCommand.php` - `#[AsCommand(name: 'uuid:generate', ...)]`
- E-65: `src/Symfony/Component/Uid/Command/InspectUuidCommand.php` - `#[AsCommand(name: 'uuid:inspect', ...)]`
- E-66: `src/Symfony/Component/Uid/Command/GenerateUlidCommand.php` - `#[AsCommand(name: 'ulid:generate', ...)]`
- E-67: `src/Symfony/Component/Uid/Command/InspectUlidCommand.php` - `#[AsCommand(name: 'ulid:inspect', ...)]`
- E-68: `src/Symfony/Component/Validator/Command/DebugCommand.php` - `#[AsCommand(name: 'debug:validator', ...)]`
- E-69: `src/Symfony/Component/Workflow/Command/WorkflowDumpCommand.php` - `#[AsCommand(name: 'workflow:dump', ...)]`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cache:clear - キャッシュをクリアする | E-01 | ○ |
| C-02 | cache:warmup - 空のキャッシュをウォームアップする | E-02 | ○ |
| C-03 | cache:pool:clear - キャッシュプールをクリアする | E-03 | ○ |
| C-04 | cache:pool:delete - キャッシュプールからアイテムを削除する | E-04 | ○ |
| C-05 | cache:pool:list - 利用可能なキャッシュプールを一覧表示する | E-05 | ○ |
| C-06 | cache:pool:prune - キャッシュプールを剪定する | E-06 | ○ |
| C-07 | cache:pool:invalidate-tags - 全てまたは特定プールのキャッシュタグを無効化する | E-07 | ○ |
| C-08 | secrets:set - Vaultにシークレットを設定する | E-08 | ○ |
| C-09 | secrets:remove - Vaultからシークレットを削除する | E-09 | ○ |
| C-10 | secrets:list - 全シークレットを一覧表示する | E-10 | ○ |
| C-11 | secrets:reveal - シークレットの値を表示する | E-11 | ○ |
| C-12 | secrets:generate-keys - 新しい暗号化キーを生成する | E-12 | ○ |
| C-13 | secrets:decrypt-to-local - 全シークレットを復号してローカルVaultに保存する | E-13 | ○ |
| C-14 | secrets:encrypt-from-local - 全ローカルシークレットをVaultに暗号化する | E-14 | ○ |
| C-15 | debug:config - 拡張機能の現在の設定をダンプする | E-15 | ○ |
| C-16 | debug:container - アプリケーションの現在のサービスを表示する | E-16 | ○ |
| C-17 | debug:autowiring - オートワイヤリングで使用可能なクラス/インタフェースを一覧表示する | E-17 | ○ |
| C-18 | debug:event-dispatcher - アプリケーションに設定されたリスナーを表示する | E-18 | ○ |
| C-19 | debug:router - アプリケーションの現在のルートを表示する | E-19 | ○ |
| C-20 | debug:translation - 翻訳メッセージ情報を表示する | E-20 | ○ |
| C-21 | router:match - パス情報のマッチングをシミュレートしてルートをデバッグする | E-21 | ○ |
| C-22 | config:dump-reference - 拡張機能のデフォルト設定をダンプする | E-22 | ○ |
| C-23 | assets:install - バンドルのWebアセットをpublicディレクトリにインストールする | E-23 | ○ |
| C-24 | translation:extract - コードから未翻訳キーを翻訳ファイルに抽出する | E-24 | ○ |
| C-25 | lint:container - サービスに注入された引数が型宣言と一致することを確認する | E-25 | ○ |
| C-26 | lint:xliff - XLIFFファイルをリントしてエラーを出力する | E-26 | ○ |
| C-27 | lint:yaml - YAMLファイルをリントしてエラーを出力する | E-27 | ○ |
| C-28 | about - 現在のプロジェクトの情報を表示する | E-28 | ○ |
| C-29 | debug:firewall - セキュリティファイアウォールの情報を表示する | E-29 | ○ |
| C-30 | debug:security:role-hierarchy - ロール階層をMermaidフローチャートとしてダンプする | E-30 | ○ |
| C-31 | lint:twig - Twigテンプレートをリントしてエラーを出力する | E-31 | ○ |
| C-32 | server:dump - ダンプを収集・表示するダンプサーバーを起動する | E-32 | ○ |
| C-33 | debug:twig - Twigの関数・フィルタ・グローバル変数・テストを一覧表示する | E-33 | ○ |
| C-34 | server:log - リアルタイムでログを表示するログサーバーを起動する | E-34 | ○ |
| C-35 | messenger:consume - メッセージを消費（処理）する | E-35 | ○ |
| C-36 | messenger:setup-transports - トランスポートに必要なインフラストラクチャを準備する | E-36 | ○ |
| C-37 | messenger:stop-workers - 現在のメッセージ処理後にワーカーを停止する | E-37 | ○ |
| C-38 | messenger:stats - 1つ以上のトランスポートのメッセージ数を表示する | E-38 | ○ |
| C-39 | messenger:failed:show - 失敗トランスポートから1つ以上のメッセージを表示する | E-39 | ○ |
| C-40 | messenger:failed:retry - 失敗トランスポートから1つ以上のメッセージをリトライする | E-40 | ○ |
| C-41 | messenger:failed:remove - 失敗トランスポートから指定メッセージを削除する | E-41 | ○ |
| C-42 | debug:messenger - メッセージバスでディスパッチ可能なメッセージを一覧表示する | E-42 | ○ |
| C-43 | translation:push - 指定プロバイダーに翻訳をプッシュする | E-43 | ○ |
| C-44 | translation:pull - 指定プロバイダーから翻訳をプルする | E-44 | ○ |
| C-45 | lint:translations - 翻訳ファイルの構文をリントしてエラーを出力する | E-45 | ○ |
| C-46 | asset-map:compile - 全マップ済みアセットをコンパイルして最終出力ディレクトリに書き込む | E-46 | ○ |
| C-47 | assets:compress - Webサーバー経由で配信するファイルを事前圧縮する | E-47 | ○ |
| C-48 | debug:asset-map - 全マップ済みアセットを出力する | E-48 | ○ |
| C-49 | importmap:require - JavaScriptパッケージを要求する | E-49 | ○ |
| C-50 | importmap:remove - JavaScriptパッケージを削除する | E-50 | ○ |
| C-51 | importmap:install - ダウンロードすべき全アセットをダウンロードする | E-51 | ○ |
| C-52 | importmap:update - JavaScriptパッケージを最新バージョンに更新する | E-52 | ○ |
| C-53 | importmap:outdated - 古くなったJavaScriptパッケージとその最新バージョンを一覧表示する | E-53 | ○ |
| C-54 | importmap:audit - 依存パッケージのセキュリティ脆弱性アドバイザリをチェックする | E-54 | ○ |
| C-55 | debug:dotenv - 全dotenvファイルの変数と値を一覧表示する | E-55 | ○ |
| C-56 | dotenv:dump - .envファイルを.env.local.phpにコンパイルする | E-56 | ○ |
| C-57 | error:dump - エラーページをプレーンHTMLファイルにダンプする | E-57 | ○ |
| C-58 | debug:form - フォームタイプの情報を表示する | E-58 | ○ |
| C-59 | mailer:test - メール送信によりMailerトランスポートをテストする | E-59 | ○ |
| C-60 | security:hash-password - ユーザーパスワードをハッシュ化する | E-60 | ○ |
| C-61 | debug:scheduler - スケジュールと定期メッセージを一覧表示する | E-61 | ○ |
| C-62 | security:oidc:generate-token - 指定ユーザーのOIDCトークンを生成する | E-62 | ○ |
| C-63 | debug:serializer - クラスのシリアライズ情報を表示する | E-63 | ○ |
| C-64 | uuid:generate - UUIDを生成する | E-64 | ○ |
| C-65 | uuid:inspect - UUIDを検査する | E-65 | ○ |
| C-66 | ulid:generate - ULIDを生成する | E-66 | ○ |
| C-67 | ulid:inspect - ULIDを検査する | E-67 | ○ |
| C-68 | debug:validator - クラスのバリデーション制約を表示する | E-68 | ○ |
| C-69 | workflow:dump - ワークフローをダンプする | E-69 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全コマンドのバッチ名と説明は `#[AsCommand]` PHP属性から直接抽出しており、根拠なしの項目はありません
- 説明文は英語の原文を日本語に翻訳したものであり、翻訳の正確性についてはレビュアーの確認を推奨します
- Consoleコンポーネントの内部コマンド（`help`, `list`, `completion`, `|_complete`）は、フレームワーク内部コマンドのため一覧から除外しています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド名と説明はすべてソースコードの `#[AsCommand]` 属性から直接取得
- 0: 低リスク - カテゴリ分類はディレクトリ構造（Bundle/Component/Bridge）に基づく
- 1: 中リスク - 説明文の日本語翻訳は自動翻訳であり、ニュアンスの差異がある可能性
- 1: 中リスク - 重複コマンド（`lint:twig`, `lint:xliff`, `lint:yaml`, `server:dump`）はBundle側をメインとして採用。Component/Bridge側の基盤実装は備考に記載

## 6) レビュアーチェックリスト（最小）
- [ ] 全69件のコマンドが実際のソースコードに存在するか
- [ ] カテゴリ分類がプロジェクトの慣例に合致しているか
- [ ] 日本語の説明文が英語の原文の意味を正確に反映しているか
- [ ] 除外したConsole内部コマンド（help, list, completion, |_complete）の除外が妥当か
- [ ] 重複コマンドの取り扱い（Bundle側をメインとする判断）が妥当か
- [ ] 抽象クラス（AbstractFailedMessagesCommand, AbstractConfigCommand）やTrait/Interfaceの除外が妥当か
