# バッチ設計書 1-cache:clear

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:clear` コンソールコマンドのバッチ設計書である。アプリケーションキャッシュの完全クリアおよびウォームアップ処理の仕様を定義する。

### 本バッチの処理概要

`cache:clear` コマンドは、Symfonyアプリケーションのキャッシュディレクトリを安全にクリアし、必要に応じて新しいキャッシュをウォームアップする処理を行う。

**業務上の目的・背景**：アプリケーションの設定変更、テンプレート更新、ルーティング変更などを反映するために、古いキャッシュを完全にクリアして新しいキャッシュを再生成する必要がある。デプロイ時やコンフィグ変更後に実行され、アプリケーションが最新の状態で動作することを保証する。キャッシュの不整合に起因する障害を防止する重要なメンテナンスコマンドである。

**バッチの実行タイミング**：アプリケーションのデプロイ時、設定ファイル変更後、テンプレート変更後など、随時手動またはデプロイスクリプトから実行される。CI/CDパイプラインの一環として自動実行されるケースが多い。

**主要な処理内容**：
1. 現在のキャッシュディレクトリとビルドディレクトリのパスを取得
2. 古いキャッシュディレクトリのクリーンアップ（前回のキャッシュクリア残存分の削除）
3. キャッシュディレクトリの書き込み権限チェック
4. ビルドディレクトリが分離されている場合のNFS判定と適切なリネーム/削除処理
5. CacheClearerInterface を通じたキャッシュのクリア
6. EventDispatcherの再初期化（古いディスパッチャの無効化）
7. ウォームアップ用一時ディレクトリの作成とカーネルリブートによるキャッシュ再生成
8. オプショナルウォーマーによる追加キャッシュの生成
9. ウォームアップディレクトリ内のファイルパス参照の修正（一時パスから本番パスへの置換）
10. ディレクトリのアトミックなリネームによるキャッシュ切り替え
11. 古いキャッシュ/ビルドディレクトリの削除

**前後の処理との関連**：`cache:warmup` コマンドと密接に関連しており、`cache:clear` 内部でウォームアップ処理が呼び出される。デプロイパイプラインでは `composer install` の後、アプリケーション起動前に実行されることが一般的である。

**影響範囲**：アプリケーション全体のキャッシュファイル（コンテナ設定、ルーティング、テンプレート、メタデータキャッシュなど）に影響する。実行中は一時的にアプリケーションのレスポンスが遅延する可能性がある。

## バッチ種別

キャッシュ管理 / メンテナンスコマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / デプロイスクリプト / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| キャッシュディレクトリの書き込み権限 | `kernel.cache_dir` パラメータで指定されるディレクトリに書き込み権限が必要 |
| ビルドディレクトリの書き込み権限 | `kernel.build_dir` が分離されている場合、そのディレクトリにも書き込み権限が必要 |
| RebootableInterface実装 | ウォームアップ実行時、カーネルが `RebootableInterface` を実装している必要がある |

### 実行可否判定

キャッシュディレクトリが書き込み可能であることを `is_writable()` で確認する。書き込み不可の場合は `RuntimeException` をスローして処理を中断する。ビルドディレクトリが分離されている場合は、そちらの書き込み権限も同様にチェックする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --no-warmup | bool | No | false | キャッシュクリア後のウォームアップを実行しない |
| --no-optional-warmers | bool | No | false | オプショナルキャッシュウォーマーをスキップする（高速化） |
| --env | string | No | dev | 対象環境（dev/prod/test等） |
| --no-debug | bool | No | false | デバッグモードを無効にする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| kernel.cache_dir | ファイルシステム | アプリケーションのキャッシュディレクトリ |
| kernel.build_dir | ファイルシステム | アプリケーションのビルドディレクトリ（キャッシュディレクトリと同一の場合あり） |
| /proc/mounts | テキストファイル | NFSマウント判定用（Linux環境のみ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| kernel.cache_dir | ファイルシステム | 再生成されたキャッシュファイル群 |
| kernel.build_dir | ファイルシステム | 再生成されたビルドファイル群 |
| stdout | テキスト | 処理進捗メッセージおよび成功メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | コンテナクラス名に基づくPHPファイル群、preload.php等 |
| 出力先 | kernel.cache_dir / kernel.build_dir |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（PHPファイル） |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ キャッシュディレクトリ・ビルドディレクトリのパスを取得
2. 古いキャッシュディレクトリの削除
   └─ 前回のクリア処理で残った一時ディレクトリを削除
3. 書き込み権限チェック
   └─ キャッシュディレクトリ・ビルドディレクトリの書き込み可能性を確認
4. ビルドディレクトリ分離時のキャッシュディレクトリ処理
   └─ NFS判定を行い、削除またはリネームを実施
5. キャッシュクリア実行
   └─ CacheClearerInterfaceを通じてキャッシュを削除
6. EventDispatcher再初期化
   └─ 古いイベントディスパッチャを新しい空のインスタンスに置換
7. キャッシュ鮮度判定
   └─ コンテナファイルのタイムスタンプを確認し、再構築が必要か判定
8. ウォームアップ処理（--no-warmupでない場合）
   └─ 一時ディレクトリにカーネルリブートで新しいキャッシュを生成
9. オプショナルウォーマー実行（--no-optional-warmersでない場合）
   └─ オプショナルなキャッシュウォーマーを実行しプリロードファイルを更新
10. パス参照の修正
    └─ ウォームアップディレクトリ内のファイルパスを本番パスに置換
11. ディレクトリ切り替え
    └─ アトミックなリネーム操作でキャッシュを切り替え
12. クリーンアップ
    └─ 古いキャッシュ・ビルドディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[キャッシュ/ビルドディレクトリパス取得]
    B --> C[古い一時ディレクトリ削除]
    C --> D{書き込み権限チェック}
    D -->|権限なし| E[RuntimeException]
    D -->|権限あり| F{ビルドディレクトリ分離?}
    F -->|Yes| G[キャッシュディレクトリをリネーム/削除]
    F -->|No| H[キャッシュクリア実行]
    G --> H
    H --> I[EventDispatcher再初期化]
    I --> J{キャッシュ鮮度判定}
    J -->|新鮮| K{no-warmup?}
    J -->|古い| L[ウォームアップ用一時ディレクトリ作成]
    K -->|Yes| M[完了メッセージ出力]
    K -->|No| N[オプショナルウォーマー実行]
    N --> M
    L --> O{no-warmup?}
    O -->|Yes| P[ディレクトリ切り替え]
    O -->|No| Q[カーネルリブートでウォームアップ]
    Q --> R{no-optional-warmers?}
    R -->|Yes| S[パス参照修正]
    R -->|No| T[オプショナルウォーマー実行]
    T --> S
    S --> P
    P --> U[古いディレクトリ削除]
    U --> M
    M --> V[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースに対する直接的な操作を行わない。ただし、キャッシュウォーマーの中にはデータベースメタデータをキャッシュとして再生成するものが含まれる可能性がある。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RuntimeException | 権限エラー | キャッシュディレクトリに書き込み権限がない | ディレクトリの所有者・権限を確認し修正する |
| RuntimeException | 権限エラー | ビルドディレクトリに書き込み権限がない | ディレクトリの所有者・権限を確認し修正する |
| LogicException | 実装エラー | カーネルがRebootableInterfaceを実装していない | カーネルクラスの実装を確認する |
| IOException | ファイル操作エラー | 古いビルド/キャッシュディレクトリの削除に失敗 | 手動でディレクトリを削除する（警告として出力、処理は継続） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. キャッシュクリア中に失敗した場合、一時ディレクトリ（末尾が `~` または `+` のディレクトリ）が残存する可能性がある。手動で削除してからコマンドを再実行する。
2. ウォームアップ中に失敗した場合、`--no-warmup` オプションを付けて `cache:clear` を再実行し、その後 `cache:warmup` を個別に実行する。
3. NFS環境では `/proc/mounts` の情報を参照してNFS判定が行われ、NFS上のディレクトリはリネームではなく直接削除される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（ディレクトリのアトミックリネームにより擬似的な整合性を確保） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | アプリケーション全体のキャッシュファイル（数百〜数千ファイル） |
| 目標処理時間 | 環境依存（通常数秒〜数十秒） |
| メモリ使用量上限 | カーネルリブートのため、アプリケーション全体のメモリ使用量に依存 |

## 排他制御

同時実行は推奨されない。複数プロセスから同時に `cache:clear` を実行した場合、ディレクトリのリネーム操作が競合し、予期しないエラーが発生する可能性がある。デプロイスクリプトやCI/CDパイプラインにおいて、排他的に実行されるよう設計する必要がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | `Clearing the cache for the {env} environment with debug {debug}` |
| 進捗ログ | 各処理ステップ | `Clearing outdated warmup directory...`, `Cache is fresh.`, `Warming up cache...`, `Warming up optional cache...` |
| 終了ログ | バッチ終了時 | `Cache for the "{env}" environment (debug={debug}) was successfully cleared.` |
| エラーログ | ディレクトリ削除失敗時 | IOException のメッセージ（verboseモード時のみ） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 環境依存（通常60秒以上で警告） | デプロイ監視システム |
| 終了コード | 0以外 | デプロイ監視システム |

## 備考

- NFS環境ではパフォーマンスに関する注意メッセージが出力される（キャッシュ・ログディレクトリを非共有フォルダに移動することを推奨）。
- ウォームアップ処理中、一時ディレクトリ名は本番ディレクトリと同じ長さに保たれる。これは、シリアライズされたリソースファイル内のパス参照の整合性を維持するためである。
- `--env` オプションと `--no-debug` オプションはSymfony Consoleの共通オプションとして提供される。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CacheClearCommand.php`
