# バッチ設計書 10-secrets:list

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `secrets:list` コンソールコマンドのバッチ設計書である。Vaultに保存された全シークレットを一覧表示する処理の仕様を定義する。

### 本バッチの処理概要

`secrets:list` コマンドは、メインVaultおよびローカルVaultに保存されたシークレットの一覧をテーブル形式で表示する。オプションにより復号した値の表示も可能である。

**業務上の目的・背景**：アプリケーションで管理されているシークレットの一覧を確認するために使用する。どのようなシークレットが設定されているか、ローカルVaultでオーバーライドされているシークレットはどれかを把握し、シークレット管理の現状を可視化する。セキュリティ監査時やデプロイ前のチェック、トラブルシューティング時にシークレットの存在確認・値の検証に利用される。`--reveal` オプションを使用することで復号化された値を確認でき、設定値の正当性を検証できる。

**バッチの実行タイミング**：シークレットの設定確認時、デバッグ時、セキュリティ監査時など随時実行される。

**主要な処理内容**：
1. `--reveal` オプションの有無に応じて、復号化の要否を決定
2. メインVaultから全シークレット名（および値）を取得
3. ローカルVaultが存在する場合、ローカルシークレットも取得
4. メインVaultとローカルVaultの情報を統合してテーブルデータを構築
5. Console Dumperを使用して値をフォーマットし、テーブル形式で出力
6. ローカルVaultの利用方法についてのガイダンスメッセージを出力

**前後の処理との関連**：`secrets:set` でシークレットを設定した後の確認用として使用される。`secrets:remove` で削除するシークレットを特定するためにも使用される。

**影響範囲**：読み取り専用のコマンドであり、Vaultの状態に一切影響を与えない。ただし `--reveal` オプション使用時は復号化された機密情報が画面に表示されるため、セキュリティ上の注意が必要。

## バッチ種別

情報表示 / シークレット管理コマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Vault設定 | シークレット管理（Vault）が設定済みであること |
| 復号化キー（--reveal時） | `--reveal` オプション使用時は復号化キーが利用可能であること |

### 実行可否判定

特別な実行可否判定は行わない。Vaultが空の場合は空のテーブルが表示される。復号化キーがない場合でも `--reveal` 無しで実行可能（シークレット名のみ表示）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --reveal / -r | bool | No | false | 復号化された値を表示する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| AbstractVault (vault) | サービス | メインVault |
| AbstractVault (localVault) | サービス | ローカルVault（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テーブル形式テキスト | シークレット名、値、ローカル値のテーブル |
| stderr | テキスト | ガイダンスメッセージ（SymfonyStyleはstderrに出力） |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ --revealオプションの有無を確認
2. ガイダンスメッセージ出力
   └─ シークレット参照方法の説明を出力
   └─ --reveal未指定時は、revealの使い方を案内
3. メインVaultシークレット取得
   └─ vault.list(reveal)で全シークレットを取得
4. ローカルVaultシークレット取得
   └─ localVaultが存在する場合、localVault.list(reveal)で取得
5. テーブルデータ構築
   └─ メインVaultの各シークレットを行として追加
   └─ Console Dumperで値をフォーマット（非reveal時は"******"）
   └─ ローカルVaultの値を対応する行に追加
6. Vaultメッセージ出力
   └─ 各Vaultからのメッセージ（getLastMessage）があれば出力
7. テーブル出力
   └─ "Secret", "Value"（+ "Local Value"）ヘッダのテーブルを出力
8. ガイダンスメッセージ出力
   └─ ローカル値のオーバーライドに関する説明を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[--revealオプション確認]
    B --> C[参照方法ガイダンス出力]
    C --> D{--reveal指定?}
    D -->|No| E[reveal使い方案内出力]
    D -->|Yes| F[メインVault.list reveal=true]
    E --> G[メインVault.list reveal=false]
    F --> H{ローカルVault存在?}
    G --> H
    H -->|Yes| I[ローカルVault.list]
    H -->|No| J[テーブルデータ構築]
    I --> J
    J --> K[Console Dumperで値フォーマット]
    K --> L{Vaultメッセージあり?}
    L -->|Yes| M[Vaultメッセージ出力]
    L -->|No| N[テーブル出力]
    M --> N
    N --> O[ローカルオーバーライド説明出力]
    O --> P[バッチ終了 コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | - | - | 読み取り専用コマンドのため、重大なエラーケースは想定されない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 復号化キーがない状態で `--reveal` を使用した場合、Vaultの実装によりエラーメッセージが出力される可能性がある。復号化キーファイルの存在を確認する。
2. Vault設定に問題がある場合は、`framework.secrets` の設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | Vault内のシークレット数（通常数個〜数十個） |
| 目標処理時間 | ミリ秒単位（即座に完了） |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用であるため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ガイダンス | コマンド開始時 | `Use "%env(<name>)%" to reference a secret in a config file.` |
| ガイダンス | --reveal未指定時 | `To reveal the secrets run php {command} secrets:list --reveal` |
| 情報ログ | Vaultメッセージ時 | Vaultからのメッセージ（getLastMessage） |
| ガイダンス | コマンド終了時 | `Local values override secret values. Use secrets:set --local to define them.` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- `--reveal` オプション未指定時、シークレットの値は `******` としてマスクされる。
- テーブルのカラム構成は、ローカルVaultが存在する場合に "Local Value" 列が追加される動的構成。
- Console Dumperコンポーネントを使用して値のフォーマットが行われる。nullの場合は `******` が表示される。
- メインVault・ローカルVaultそれぞれの `getLastMessage()` が出力される（復号化キーの状態等に関するメッセージ）。
- SymfonyStyleのメッセージ出力（comment等）はstderrに送信されるが、テーブル自体はstdoutに出力される（L94で新しいSymfonyStyleインスタンスを$outputで作成）。
- 本コマンドは `@internal` マーク付きであり、フレームワーク内部使用を前提としている。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsListCommand.php`
