# バッチ設計書 11-secrets:reveal

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `secrets:reveal` コマンドのバッチ設計書である。このコマンドは、Vaultに保存されたシークレットの値を復号して表示するためのCLIツールである。

### 本バッチの処理概要

`secrets:reveal` コマンドは、暗号化されてVaultに保存されているシークレットの実際の値を復号し、標準出力に表示する処理を行う。

**業務上の目的・背景**：Symfonyアプリケーションでは、データベースパスワードやAPIキーなどの機密情報をVaultに暗号化して保存する。開発・運用時にシークレットの現在の値を確認する必要がある場合、このコマンドを使用して安全に復号・表示を行う。これにより、暗号化されたシークレットの中身を確認でき、設定の検証やデバッグが可能となる。

**バッチの実行タイミング**：随時実行（手動）。開発者や運用者がシークレットの値を確認したいときに任意のタイミングで実行する。

**主要な処理内容**：
1. 引数として指定されたシークレット名を取得する
2. ローカルVaultが存在し、指定されたシークレットがローカルVaultに含まれる場合はローカルVaultから値を取得して表示する
3. ローカルVaultに存在しない場合は、メインVaultからシークレットを復号して表示する
4. シークレットが存在しない場合、または復号に失敗した場合はエラーメッセージを出力する

**前後の処理との関連**：`secrets:set` コマンドで設定されたシークレットの値を確認するために使用する。`secrets:list` コマンドでシークレットの一覧を確認した後、個別の値を確認する用途で利用される。`secrets:decrypt-to-local` コマンドでローカルVaultに展開された値も参照可能。

**影響範囲**：読み取り専用の操作であり、Vaultのデータを変更しない。ただし、復号した秘密情報が標準出力に表示されるため、セキュリティ上の注意が必要である。

## バッチ種別

シークレット管理 / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Vaultの初期化 | AbstractVaultの実装がDIコンテナに登録されていること |
| 暗号化キーの存在 | Vaultの復号キーがアクセス可能であること |
| シークレットの存在 | 参照対象のシークレットがVaultに登録済みであること |

### 実行可否判定

コマンド実行時にAbstractVaultインスタンスがコンストラクタで注入されている必要がある。Vaultが利用不可能な場合はDIコンテナレベルでエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | Yes | なし | 表示するシークレットの名前。Vaultに登録されたシークレット名を指定する。シェル補完でVault内のシークレット名一覧が候補として表示される。 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| AbstractVault（メインVault） | 暗号化ファイル | メインの暗号化シークレットストア |
| AbstractVault（ローカルVault） | 暗号化ファイル | ローカル環境用のシークレットストア（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 復号されたシークレットの値 |
| 標準エラー出力 | テキスト | エラーメッセージ（シークレットが存在しない場合や復号失敗時） |

### 出力ファイル仕様

ファイル出力はなし。標準出力にシークレットの値がプレーンテキストで出力される。

## 処理フロー

### 処理シーケンス

```
1. 入力引数の取得
   └─ 引数 "name" からシークレット名を取得
2. Vault一覧の取得
   └─ メインVaultから全シークレットを復号付きでリスト取得（vault->list(true)）
   └─ ローカルVaultが存在する場合、ローカルVaultからも復号付きでリスト取得
3. シークレット値の解決
   └─ ローカルVaultに指定名のシークレットが存在する場合はローカル値を使用
   └─ ローカルVaultに存在しない場合はメインVaultの値を使用
4. 結果の出力
   └─ 値が取得できた場合：標準出力にシークレット値を出力（SUCCESS）
   └─ シークレットが存在しない場合：エラーメッセージを出力（INVALID）
   └─ 復号に失敗した場合（値がnull）：エラーメッセージを出力（INVALID）
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B[引数 name を取得]
    B --> C[メインVaultのシークレット一覧を復号付きで取得]
    C --> D[ローカルVaultのシークレット一覧を復号付きで取得]
    D --> E{ローカルVaultに該当シークレットが存在?}
    E -->|はい| F[ローカルVaultの値を標準出力に表示]
    E -->|いいえ| G{メインVaultに該当シークレットが存在?}
    G -->|いいえ| H[エラー: シークレットが存在しない]
    G -->|はい| I{復号に成功?}
    I -->|いいえ| J[エラー: 復号に失敗]
    I -->|はい| K[メインVaultの値を標準出力に表示]
    F --> L[SUCCESS で終了]
    H --> M[INVALID で終了]
    J --> M
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。本コマンドはファイルシステム上のVaultストレージを読み取り専用でアクセスする。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| INVALID (2) | シークレット未登録 | 指定されたシークレット名がVaultに存在しない | 正しいシークレット名を指定する。`secrets:list` で一覧を確認する |
| INVALID (2) | 復号失敗 | シークレットの復号に失敗した（復号キーがない等） | 復号キーが正しく配置されているか確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

復号キーが利用できない場合は、キーファイルの配置を確認する。シークレットが存在しない場合は `secrets:list` で登録済みシークレットを確認し、正しい名前を指定して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（指定された1つのシークレット） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンド範囲（数十MB以内） |

## 排他制御

同時実行に関する制約はない。読み取り専用操作のため排他制御は不要である。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | シークレット未登録時 | `The secret "{name}" does not exist.` |
| エラーログ | 復号失敗時 | `The secret "{name}" could not be decrypted.` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- ローカルVaultはオプションであり、設定されていない場合（nullの場合）はメインVaultのみを参照する
- ローカルVaultが優先され、ローカルVaultに該当シークレットが存在する場合はメインVaultの値は参照されない
- 出力先はSymfonyStyleを使用しており、ConsoleOutputInterfaceの場合はErrorOutputに対してIO操作が行われる
- シークレット名の補完機能があり、引数指定時にVault内のシークレット名が候補として表示される
