# バッチ設計書 12-secrets:generate-keys

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `secrets:generate-keys` コマンドのバッチ設計書である。このコマンドは、シークレットVaultの暗号化・復号に使用する新しい暗号化キーを生成するためのCLIツールである。

### 本バッチの処理概要

`secrets:generate-keys` コマンドは、シークレットの暗号化・復号に必要な鍵ペアを新規生成する。既存のキーが存在する場合は `--rotate` オプションを使用してキーのローテーション（再暗号化）を行うことも可能である。

**業務上の目的・背景**：Symfonyのシークレット管理システムでは、公開鍵暗号方式を使用してシークレットを安全に保管する。初期セットアップ時にキーペアの生成が必要であり、セキュリティポリシーに基づく定期的なキーローテーションにも対応する。これにより、シークレット管理基盤の暗号化インフラストラクチャを構築・更新できる。

**バッチの実行タイミング**：随時実行（手動）。プロジェクト初期セットアップ時、またはセキュリティポリシーに基づくキーローテーション時に実行する。

**主要な処理内容**：
1. `--local` オプションが指定された場合はローカルVaultを対象とし、それ以外はメインVaultを対象とする
2. `--rotate` オプションが未指定の場合、新規キーペアの生成を試みる
3. `--rotate` オプションが指定された場合、既存シークレットを全て読み出し、新しいキーを生成し、全シークレットを新しいキーで再暗号化する
4. メインVaultの場合は復号キーをコミットしないよう警告メッセージを表示する

**前後の処理との関連**：Vault初期セットアップの最初のステップとして実行される。本コマンド実行後に `secrets:set` でシークレットの設定が可能となる。キーローテーション時は既存シークレットの再暗号化も同時に行われる。

**影響範囲**：暗号化キーファイルの生成・上書きが行われるため、既存キーが失われる可能性がある。`--rotate` 使用時は全シークレットの再暗号化が実施される。

## バッチ種別

シークレット管理 / 暗号化キー管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Vaultの初期化 | AbstractVaultの実装がDIコンテナに登録されていること |
| --rotate時の復号キー | ローテーション実行時は既存シークレットの復号キーが必要 |

### 実行可否判定

- `--local` オプション指定時にlocalVaultがnullの場合はエラーとなる
- `--rotate` なしで既にキーが存在する場合はwarningを表示して終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --local (-l) | bool | No | false | ローカルVaultを対象としてキーを生成する |
| --rotate (-r) | bool | No | false | 既存キーを上書きし、既存シークレットを新しいキーで再暗号化する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| AbstractVault（メインVault） | 暗号化ファイル | メインの暗号化シークレットストア（--rotate時に全シークレットを読み出し） |
| AbstractVault（ローカルVault） | 暗号化ファイル | ローカル環境用シークレットストア（--local指定時） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 暗号化キーファイル | バイナリ | 新しく生成された暗号化キーペア |
| 再暗号化シークレット | 暗号化ファイル | --rotate時に新しいキーで再暗号化されたシークレット |
| 標準エラー出力 | テキスト | 成功メッセージ、警告メッセージ |

### 出力ファイル仕様

キーファイルの具体的なパスとフォーマットはAbstractVaultの実装に依存する。

## 処理フロー

### 処理シーケンス

```
1. 対象Vault決定
   └─ --local指定時はlocalVault、それ以外はメインVault
2. localVaultの有効性チェック
   └─ --local指定でlocalVaultがnullの場合はエラー終了
3A. 通常モード（--rotateなし）
   └─ vault->generateKeys() を実行
   └─ 成功時：成功メッセージ表示 + 復号キーコミット警告（メインVaultの場合）
   └─ 失敗時：警告メッセージ表示（既にキーが存在する等）
3B. ローテーションモード（--rotate指定）
   └─ 全シークレットを復号して読み出し（vault->list(true)）
   └─ 復号失敗のシークレットがあればエラー終了
   └─ vault->generateKeys(true) で新しいキーを強制生成
   └─ 全シークレットを新しいキーで再暗号化（vault->seal）
   └─ 復号キーコミット警告（メインVaultの場合）
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{--local オプション?}
    B -->|はい| C[ローカルVaultを選択]
    B -->|いいえ| D[メインVaultを選択]
    C --> E{ローカルVaultが有効?}
    E -->|いいえ| F[エラー: ローカルVault無効]
    E -->|はい| G{--rotate オプション?}
    D --> G
    G -->|いいえ| H[generateKeys 実行]
    H --> I{キー生成成功?}
    I -->|はい| J[成功メッセージ表示]
    I -->|いいえ| K[警告メッセージ表示]
    G -->|はい| L[全シークレットを復号して読み出し]
    L --> M{全て復号成功?}
    M -->|いいえ| N[エラー終了]
    M -->|はい| O[generateKeys で強制キー生成]
    O --> P{キー生成成功?}
    P -->|いいえ| K
    P -->|はい| Q[全シークレットを新キーで再暗号化]
    Q --> R[ローテーション完了メッセージ]
    J --> S{メインVault?}
    R --> S
    S -->|はい| T[復号キーコミット警告表示]
    S -->|いいえ| U[正常終了]
    T --> U
    K --> V[異常終了]
    F --> V
    N --> V
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。本コマンドはファイルシステム上のVaultストレージに対して操作を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ローカルVault無効 | --local指定時にlocalVaultがnull | ローカルVaultの設定を確認する |
| 1 | キー生成失敗 | generateKeysがfalseを返した場合（既存キーが存在等） | --rotateオプションを使用して既存キーをローテーションする |
| 1 | 復号失敗 | --rotate時にシークレットの復号に失敗（値がnull） | 復号キーの配置を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

キーローテーション中にエラーが発生した場合、既存の暗号化キーとシークレットの整合性を確認する必要がある。generateKeysが成功した後にsealが失敗した場合は、シークレットの一部が旧キーのまま残る可能性があるため、手動での復旧が必要となる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | キーローテーション時は全シークレットの再暗号化が一括処理 |
| コミットタイミング | 各シークレットのseal実行時に即時書き込み |
| ロールバック条件 | アトミックなロールバック機構はなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | キーローテーション時はVault内の全シークレット数 |
| 目標処理時間 | 数秒以内（シークレット数に依存） |
| メモリ使用量上限 | 通常のCLIコマンド範囲（数十MB以内） |

## 排他制御

同一Vaultに対する同時キー生成・ローテーションは想定されていない。手動実行のため同時実行の制御は運用上で管理する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | キー生成成功時 | vault->getLastMessage() の内容 |
| 警告ログ | キー生成失敗時 | vault->getLastMessage() の内容 |
| 警告ログ | メインVaultキー生成後 | 「DO NOT COMMIT THE DECRYPTION KEY FOR THE PROD ENVIRONMENT」 |
| コメントログ | ローテーション完了時 | 「Existing secrets have been rotated to the new keys.」 |
| エラーログ | 復号失敗時 | vault->getLastMessage() の内容 |
| エラーログ | ローカルVault無効時 | 「The local vault is disabled.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- キーローテーション時はアトミック性が保証されないため、途中失敗時は手動復旧が必要
- メインVaultのキー生成後には復号キーをバージョン管理にコミットしないよう警告が表示される
- ローカルVaultはオプションであり、DI設定によりnullとなる場合がある
- generateKeys(true) の引数trueはキーの強制上書きを意味する
