# バッチ設計書 13-secrets:decrypt-to-local

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `secrets:decrypt-to-local` コマンドのバッチ設計書である。このコマンドは、メインVaultに保存された全シークレットを復号し、ローカルVaultにコピーするためのCLIツールである。

### 本バッチの処理概要

`secrets:decrypt-to-local` コマンドは、メインVault内の暗号化シークレットを全て復号し、ローカルVaultに保存する一括処理を行う。開発環境やステージング環境でシークレットをローカルにオーバーライドする際の基盤となる。

**業務上の目的・背景**：本番環境用のVaultに保存されたシークレットを、開発やテスト目的でローカル環境にコピーする必要がある。ローカルVaultを使用することで、本番用の暗号化キーなしでもアプリケーションを動作させることが可能となる。これはチーム開発において、復号キーを持たない開発者でもシークレットを利用できるようにするための仕組みである。

**バッチの実行タイミング**：随時実行（手動）。開発環境のセットアップ時や、本番シークレットの更新後にローカル環境を同期する際に実行する。

**主要な処理内容**：
1. ローカルVaultの有効性を確認する
2. メインVaultから全シークレットを復号付きで一覧取得する
3. `--force` オプションが未指定の場合、ローカルVaultに既に存在するシークレットをスキップする
4. 各シークレットをローカルVaultにseal（保存）する
5. 復号に失敗したシークレットがある場合はエラーを報告する

**前後の処理との関連**：`secrets:set` や `secrets:generate-keys` で構築されたVaultの内容をローカルに展開する。逆方向の操作は `secrets:encrypt-from-local` コマンドで行う。

**影響範囲**：ローカルVaultのシークレットデータが更新される。メインVaultは読み取りのみで変更されない。

## バッチ種別

シークレット管理 / データ同期

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ローカルVaultが有効 | localVaultがnullでないこと |
| メインVaultの復号キー | メインVaultのシークレットを復号するための復号キーが利用可能であること |
| メインVaultにシークレットが存在 | コピー元のシークレットが登録済みであること |

### 実行可否判定

ローカルVaultがnullの場合は「The local vault is disabled.」エラーで終了する。メインVaultに復号キーがない場合はシークレットごとに復号エラーが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --force (-f) | bool | No | false | ローカルVaultに既に存在するシークレットを上書きする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| AbstractVault（メインVault） | 暗号化ファイル | コピー元の暗号化シークレットストア |
| AbstractVault（ローカルVault） | 暗号化ファイル | コピー先のローカルシークレットストア（既存データの重複チェック用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ローカルVault | 暗号化ファイル | 復号されたシークレットがローカルVaultに保存される |
| 標準エラー出力 | テキスト | 処理状況メッセージ、エラーメッセージ |

### 出力ファイル仕様

出力ファイルの具体的なパスとフォーマットはAbstractVaultのローカルVault実装に依存する。

## 処理フロー

### 処理シーケンス

```
1. ローカルVaultの有効性チェック
   └─ localVaultがnullの場合はエラー終了
2. メインVaultの全シークレットを復号付きで取得
   └─ vault->list(true) で全シークレットの名前と復号値を取得
3. シークレット数のコメント出力
   └─ 「X secret(s) found in the vault.」を表示
4. 重複チェック（--forceが未指定の場合）
   └─ ローカルVaultの既存シークレットと照合
   └─ 重複するシークレットをスキップリストに追加
   └─ スキップ数がある場合は警告メッセージを表示
5. シークレットの個別コピー
   └─ 各シークレットについて：
      └─ 復号値がnullの場合はエラー出力してスキップ
      └─ localVault->seal(name, value) でローカルVaultに保存
      └─ localVault->getLastMessage() をnoteとして出力
6. 結果返却
   └─ 復号エラーがあった場合は戻り値1、それ以外は0
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{ローカルVaultが有効?}
    B -->|いいえ| C[エラー: ローカルVault無効]
    B -->|はい| D[メインVaultから全シークレットを復号取得]
    D --> E[シークレット数をコメント出力]
    E --> F{--force オプション?}
    F -->|いいえ| G[ローカルVault既存シークレットと照合]
    G --> H{重複あり?}
    H -->|はい| I[重複シークレットをスキップ + 警告表示]
    H -->|いいえ| J[各シークレットをループ処理]
    F -->|はい| J
    I --> J
    J --> K{復号値がnull?}
    K -->|はい| L[エラー出力してスキップ]
    K -->|いいえ| M[localVault->seal でローカルに保存]
    M --> N[note メッセージ出力]
    L --> O{次のシークレット?}
    N --> O
    O -->|はい| K
    O -->|いいえ| P{復号エラーあり?}
    P -->|はい| Q[戻り値 1 で終了]
    P -->|いいえ| R[戻り値 0 で終了]
    C --> S[戻り値 1 で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。本コマンドはファイルシステム上のVaultストレージに対して操作を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ローカルVault無効 | localVaultがnull | ローカルVaultの設定を確認する |
| 1 | 復号失敗 | シークレットの復号値がnull | メインVaultの復号キーが正しく配置されているか確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

復号に失敗したシークレットがある場合でも、他のシークレットのコピーは継続される（部分成功）。失敗したシークレットについては、復号キーの配置を確認した上で再実行する。`--force` オプションを付けて再実行すれば、既にコピー済みのシークレットも含めて全て上書きされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各シークレットごとに個別にseal処理 |
| コミットタイミング | 各シークレットのseal実行時に即時書き込み |
| ロールバック条件 | アトミックなロールバック機構はなし（部分成功が発生しうる） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | メインVault内の全シークレット数 |
| 目標処理時間 | 数秒以内（シークレット数に依存） |
| メモリ使用量上限 | 通常のCLIコマンド範囲（数十MB以内） |

## 排他制御

同一ローカルVaultに対する同時書き込みは想定されていない。手動実行のため同時実行の制御は運用上で管理する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コメントログ | シークレット一覧取得後 | 「X secret(s) found in the vault.」 |
| 警告ログ | 重複スキップ時 | 「X secret(s) already overridden in the local vault and will be skipped. Use the --force flag to override these.」 |
| ノートログ | 各シークレットコピー時 | localVault->getLastMessage() の内容 |
| エラーログ | 復号失敗時 | vault->getLastMessage() またはデフォルトエラーメッセージ |
| エラーログ | ローカルVault無効時 | 「The local vault is disabled.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- `--force` 未指定時はローカルVaultに既存のシークレットをスキップし、安全にマージ的な動作をする
- 復号エラーがあっても処理を中断せず、他のシークレットのコピーは継続する（hadErrorsフラグで最終戻り値に反映）
- メインVaultは読み取り専用でアクセスされ、データは変更されない
