# バッチ設計書 14-secrets:encrypt-from-local

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `secrets:encrypt-from-local` コマンドのバッチ設計書である。このコマンドは、ローカルVaultでオーバーライドされた全シークレットをメインVaultに暗号化して反映するためのCLIツールである。

### 本バッチの処理概要

`secrets:encrypt-from-local` コマンドは、ローカルVaultに保存されたシークレット値がメインVaultの値と異なる場合に、ローカルの値でメインVaultを更新する処理を行う。

**業務上の目的・背景**：開発環境でローカルVaultを使用してシークレット値を変更・テストした後、その変更を本番用のメインVaultに反映する必要がある。このコマンドにより、ローカルでの変更を安全にメインVaultに同期できる。`secrets:decrypt-to-local` の逆方向の操作に相当する。

**バッチの実行タイミング**：随時実行（手動）。ローカルVaultでシークレット値を変更した後、メインVaultに反映する際に実行する。

**主要な処理内容**：
1. ローカルVaultの有効性を確認する
2. メインVaultの全シークレットを復号付きで一覧取得する
3. 各シークレットについてローカルVaultの値を取得し、メインVaultの値と比較する
4. 値が異なる場合のみメインVaultにseal（再暗号化・保存）する

**前後の処理との関連**：`secrets:decrypt-to-local` でローカルに展開した後、値を変更し、本コマンドでメインVaultに反映する。`secrets:set` による個別設定の代替としても利用可能。

**影響範囲**：メインVaultのシークレットデータが更新される。ローカルVaultは読み取りのみで変更されない。

## バッチ種別

シークレット管理 / データ同期

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ローカルVaultが有効 | localVaultがnullでないこと |
| メインVaultの暗号化キー | メインVaultへのseal操作に必要な暗号化キーが利用可能であること |
| メインVaultの復号キー | メインVaultのシークレットを復号して比較するための復号キーが必要 |

### 実行可否判定

ローカルVaultがnullの場合は「The local vault is disabled.」エラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本コマンドには入力パラメータはない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| AbstractVault（メインVault） | 暗号化ファイル | 比較元・更新先の暗号化シークレットストア |
| AbstractVault（ローカルVault） | 暗号化ファイル | 比較元のローカルシークレットストア |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| メインVault | 暗号化ファイル | ローカルVaultと値が異なるシークレットが更新される |
| 標準エラー出力 | テキスト | 処理状況メッセージ |

### 出力ファイル仕様

出力ファイルの具体的なパスとフォーマットはAbstractVaultの実装に依存する。

## 処理フロー

### 処理シーケンス

```
1. ローカルVaultの有効性チェック
   └─ localVaultがnullの場合はエラー終了
2. メインVaultの全シークレットを復号付きで取得
   └─ vault->list(true) で全シークレットの名前と復号値を取得
3. 各シークレットの差分チェックと更新
   └─ 各シークレットについて：
      └─ localVault->reveal(name) でローカル値を取得
      └─ ローカル値がnullの場合はスキップ（ローカルに存在しない）
      └─ メインVault値とローカル値を比較
      └─ 値が異なる場合のみ vault->seal(name, localValue) でメインVaultを更新
      └─ vault->getLastMessage() をnoteとして出力
4. 正常終了（戻り値0）
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{ローカルVaultが有効?}
    B -->|いいえ| C[エラー: ローカルVault無効]
    B -->|はい| D[メインVaultから全シークレットを復号取得]
    D --> E[各シークレットをループ処理]
    E --> F[localVault->reveal で該当シークレットのローカル値を取得]
    F --> G{ローカル値がnull?}
    G -->|はい| H[スキップ]
    G -->|いいえ| I{メイン値とローカル値が異なる?}
    I -->|いいえ| H
    I -->|はい| J[vault->seal でメインVaultを更新]
    J --> K[note メッセージ出力]
    H --> L{次のシークレット?}
    K --> L
    L -->|はい| F
    L -->|いいえ| M[戻り値 0 で終了]
    C --> N[戻り値 1 で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。本コマンドはファイルシステム上のVaultストレージに対して操作を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ローカルVault無効 | localVaultがnull | ローカルVaultの設定を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ローカルVaultが無効な場合はDI設定を確認する。seal操作中のエラーはAbstractVaultの実装に依存するため、Vault実装のドキュメントを参照する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各シークレットごとに個別にseal処理 |
| コミットタイミング | 各シークレットのseal実行時に即時書き込み |
| ロールバック条件 | アトミックなロールバック機構はなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | メインVault内の全シークレット数（差分のあるもののみ更新） |
| 目標処理時間 | 数秒以内（シークレット数に依存） |
| メモリ使用量上限 | 通常のCLIコマンド範囲（数十MB以内） |

## 排他制御

同一メインVaultに対する同時書き込みは想定されていない。手動実行のため同時実行の制御は運用上で管理する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ノートログ | シークレット更新時 | vault->getLastMessage() の内容 |
| エラーログ | ローカルVault無効時 | 「The local vault is disabled.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- 値が同一のシークレットはsealされず、不要な再暗号化を回避する
- ローカルVaultに存在しないシークレット（reveal結果がnull）はスキップされる
- メインVaultの全シークレットを基準にイテレーションするため、ローカルVaultにのみ存在するシークレットはメインVaultに反映されない
- 本コマンドは常に戻り値0（成功）を返す（ローカルVault無効時を除く）
