# バッチ設計書 15-debug:config

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `debug:config` コマンドのバッチ設計書である。このコマンドは、指定した拡張機能（Extension）やバンドルの現在の設定値をダンプ表示するためのデバッグ用CLIツールである。

### 本バッチの処理概要

`debug:config` コマンドは、SymfonyのDIコンテナを構築・コンパイルし、指定された拡張機能の現在有効な設定値を取得して、YAML/JSON形式で出力する。設定のパスを指定して特定の設定項目のみを表示することも可能である。

**業務上の目的・背景**：Symfonyアプリケーションの設定は、複数の設定ファイル、環境変数、パラメータの組み合わせで決定される。開発者が現在有効な設定値を正確に把握するためには、全ての設定ソースがマージ・処理された後の最終的な値を確認する必要がある。このコマンドにより、アプリケーションの実際の動作設定をデバッグ・検証できる。

**バッチの実行タイミング**：随時実行（手動）。設定の確認・デバッグが必要な際に開発者が任意のタイミングで実行する。

**主要な処理内容**：
1. 引数なしの場合、利用可能なバンドルと非バンドル拡張機能の一覧を表示する
2. 拡張機能名が指定された場合、DIコンテナをビルド・コンパイルし、該当拡張機能の設定を取得する
3. 設定パスが指定された場合、設定ツリーを辿って該当パスの値のみを抽出する
4. 指定されたフォーマット（txt/yaml/json）で設定値を出力する

**前後の処理との関連**：`config:dump-reference` コマンドがデフォルト設定のリファレンスを表示するのに対し、本コマンドは実際に適用されている設定値を表示する。

**影響範囲**：読み取り専用の操作であり、アプリケーションの設定やデータを変更しない。ただし、内部的にDIコンテナのビルドとコンパイルを行うため、一定の処理時間とメモリを消費する。

## バッチ種別

デバッグ / 設定情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyカーネルが有効 | アプリケーションのカーネルが正常にブートできること |
| 拡張機能の存在 | 指定した拡張機能がコンテナに登録されていること |

### 実行可否判定

引数なしの場合は常に実行可能。拡張機能名が指定された場合、該当する拡張機能がコンテナに登録されている必要がある。YAML出力にはSymfony Yamlコンポーネントが必要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | null | バンドル名または拡張機能のエイリアス |
| path | string | No | null | 設定オプションのパス（ドット区切り、例: serializer.enabled） |
| --resolve-env | bool | No | false | 環境変数プレースホルダの代わりに解決済みの値を表示する |
| --format | string | No | txt | 出力フォーマット（txt, yaml, json） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| DIコンテナ設定 | PHP/YAML/XML | アプリケーションの設定ファイル群 |
| 環境変数 | 文字列 | DIコンテナで参照される環境変数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | YAML/JSON/テキスト | 設定値のダンプ結果 |
| 標準エラー出力 | テキスト | バンドル一覧、ヒントメッセージ、エラーメッセージ |

### 出力ファイル仕様

ファイル出力はなし。標準出力にフォーマットされた設定値が出力される。

## 処理フロー

### 処理シーケンス

```
1. 引数の確認
   └─ name引数がnullの場合：
      └─ バンドル一覧を表示（listBundles）
      └─ 非バンドル拡張機能一覧を表示（listNonBundleExtensions）
      └─ 使い方のヒントを表示して正常終了
2. 拡張機能の解決
   └─ findExtension(name) で拡張機能オブジェクトを取得
   └─ 拡張機能のエイリアスを取得
3. DIコンテナのビルド・コンパイル
   └─ カーネルをクローンしてブート
   └─ buildContainerメソッド（リフレクション経由）でコンテナビルダーを取得
   └─ コンパイラでコンテナをコンパイル
4. 設定値の取得
   └─ ValidateEnvPlaceholdersPassから拡張機能設定を取得
   └─ 環境変数プレースホルダの解決（--resolve-env指定時は実値表示）
5. パス指定時の絞り込み
   └─ path引数が指定されている場合、ドット区切りパスで設定ツリーを辿る
   └─ パスが存在しない場合はLogicExceptionでエラー
6. フォーマット変換と出力
   └─ txt/yaml形式：Yaml::dump で変換
   └─ json形式：json_encode で変換
   └─ 標準出力に結果を表示
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{name引数あり?}
    B -->|いいえ| C[バンドル一覧・拡張機能一覧を表示]
    C --> D[使い方ヒントを表示]
    D --> E[正常終了]
    B -->|はい| F[findExtensionで拡張機能を取得]
    F --> G[DIコンテナをビルド・コンパイル]
    G --> H[拡張機能の設定値を取得]
    H --> I{format が txt/yml で Yaml未インストール?}
    I -->|はい| J[エラー: Yamlコンポーネントが必要]
    I -->|いいえ| K{path引数あり?}
    K -->|いいえ| L[全設定をフォーマットして出力]
    K -->|はい| M[パスで設定ツリーを辿る]
    M --> N{パスが存在?}
    N -->|いいえ| O[エラー: 設定が見つからない]
    N -->|はい| P[該当パスの設定をフォーマットして出力]
    L --> E
    P --> E
    J --> Q[エラー終了]
    O --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。本コマンドはDIコンテナの設定情報を読み取り専用でアクセスする。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Yamlコンポーネント未インストール | txt/yaml形式指定時にSymfony Yamlが未インストール | `composer require symfony/yaml` を実行するか `--format=json` を使用 |
| 1 | 設定パス不正 | path引数で指定したパスが設定ツリーに存在しない | 正しいパスを指定する。パスなしで全設定を確認する |
| LogicException | 拡張機能に設定がない | 指定した拡張機能がConfigurationInterfaceを持たない | 設定を持つ拡張機能を指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

設定エラーによりDIコンテナのコンパイルが失敗する場合は、アプリケーションの設定ファイルを修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1拡張機能の設定ツリー |
| 目標処理時間 | 数秒以内（コンテナコンパイル時間に依存） |
| メモリ使用量上限 | DIコンテナのビルドに必要なメモリ（アプリケーション規模に依存） |

## 排他制御

読み取り専用操作のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイトルログ | 設定表示前 | 「Current configuration for {name}」 |
| コメントログ | ドキュメントURL存在時 | 「Documentation at {url}」 |
| エラーログ | Yaml未インストール時 | フォーマットエラーメッセージ |
| エラーログ | パス不正時 | 「Unable to find configuration for {alias}.{path}」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- AbstractConfigCommandを継承しており、findExtension/listBundles/listNonBundleExtensionsなどのメソッドは親クラスで定義されている
- DIコンテナのビルド時にカーネルをクローンして使用するため、実行中のアプリケーションには影響しない
- --resolve-envオプションにより環境変数の実際の値を表示可能だが、セキュリティ上の注意が必要
- シェル補完機能があり、name引数とpath引数の両方で候補が表示される
- 出力フォーマットはtxt, yaml, jsonの3種類に対応（txtとyamlはYaml::dumpで同一処理）
