# バッチ設計書 16-debug:container

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `debug:container` コマンドのバッチ設計書である。このコマンドは、アプリケーションに設定された現在のサービス、パラメータ、環境変数、タグ等の情報を表示するための包括的なデバッグ用CLIツールである。

### 本バッチの処理概要

`debug:container` コマンドは、SymfonyのDIコンテナをビルドし、サービス定義、パラメータ、環境変数、タグ、型情報、非推奨情報など、コンテナに関する多角的な情報を様々な切り口で表示する。

**業務上の目的・背景**：Symfonyアプリケーションの中核であるDIコンテナには数百から数千のサービスが登録される。開発者がサービスの登録状況、依存関係、タグの設定状況、パラメータの値を把握するためにはこのコマンドが不可欠である。デバッグ、設定確認、サービスIDの検索など幅広い用途で使用される。

**バッチの実行タイミング**：随時実行（手動）。開発・デバッグ時に任意のタイミングで実行する。

**主要な処理内容**：
1. 引数・オプションに応じてコンテナ情報の表示モードを決定する
2. DIコンテナをビルドしてContainerBuilderを取得する
3. DescriptorHelperを使用して、指定されたフォーマットで情報を出力する
4. サービス名検索、タグ検索、パラメータ検索などのインタラクティブ機能を提供する

**前後の処理との関連**：`debug:autowiring` コマンドはオートワイヤリング可能な型に特化した表示を行う。`debug:config` コマンドは拡張機能の設定に特化した表示を行う。

**影響範囲**：読み取り専用の操作であり、アプリケーションの状態を変更しない。DIコンテナのビルドによりメモリを消費する。

## バッチ種別

デバッグ / コンテナ情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyカーネルが有効 | アプリケーションのカーネルが正常にブートできること |

### 実行可否判定

常に実行可能。ただし、指定したサービス名やタグが見つからない場合は適切なエラーメッセージが表示される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | null | サービス名（部分一致検索可能） |
| --show-hidden | bool | No | false | 内部（隠し）サービスを表示する |
| --tag | string | No | null | 特定のタグを持つサービスを表示する |
| --tags | bool | No | false | タグ別にグループ化してサービスを表示する |
| --parameter | string | No | null | 特定のパラメータの値を表示する |
| --parameters | bool | No | false | 全パラメータを表示する |
| --types | bool | No | false | オートワイヤリング可能な型を表示する |
| --env-var | string | No | null | 特定の環境変数を表示する |
| --env-vars | bool | No | false | コンテナで使用される環境変数を表示する |
| --format | string | No | txt | 出力フォーマット（DescriptorHelperの対応フォーマット） |
| --raw | bool | No | false | 生の説明を出力する |
| --deprecations | bool | No | false | コンテナコンパイル時の非推奨警告を表示する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| DIコンテナ | ContainerBuilder | アプリケーションのサービスコンテナ |
| パラメータバッグ | ParameterBag | コンテナに登録されたパラメータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | txt/json/xml/md | サービス情報、パラメータ情報等 |
| 標準エラー出力 | テキスト | 非推奨警告、ヒントメッセージ |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. 入力バリデーション
   └─ tags/tag/parameters/parameterオプションの排他チェック
   └─ name引数と上記オプションの併用チェック
2. DIコンテナのビルド
   └─ BuildDebugContainerTraitを使用してContainerBuilderを取得
3. 表示モードの決定
   └─ --env-vars: 環境変数一覧表示
   └─ --env-var: 特定環境変数表示
   └─ --types: オートワイヤリング型フィルタ表示
   └─ --parameters: 全パラメータ表示
   └─ --parameter: 特定パラメータ表示
   └─ --tags: タグ別グループ表示
   └─ --tag: 特定タグのサービス表示
   └─ name引数: 特定サービス詳細表示
   └─ --deprecations: 非推奨情報表示
   └─ デフォルト: 全サービス一覧表示
4. DescriptorHelperによる出力
   └─ describe メソッドで対象オブジェクトを指定フォーマットで出力
5. 追加情報の表示
   └─ 特定サービス表示時：非推奨警告、削除済みサービスの注記
   └─ インタラクティブモード時：検索ヒントの表示
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B[入力バリデーション]
    B --> C[DIコンテナをビルド]
    C --> D{表示モード判定}
    D -->|env-vars| E[環境変数一覧]
    D -->|env-var| F[特定環境変数]
    D -->|types| G[オートワイヤリング型]
    D -->|parameters| H[全パラメータ]
    D -->|parameter| I[特定パラメータ]
    D -->|tags| J[タグ別グループ]
    D -->|tag| K[特定タグのサービス]
    D -->|name| L[特定サービス詳細]
    D -->|deprecations| M[非推奨情報]
    D -->|デフォルト| N[全サービス一覧]
    E --> O[DescriptorHelperで出力]
    F --> O
    G --> O
    H --> O
    I --> O
    J --> O
    K --> O
    L --> O
    M --> O
    N --> O
    O --> P[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgumentException | オプション排他違反 | tags/tag/parameters/parameterの併用 | 1つのオプションのみ指定する |
| InvalidArgumentException | 引数・オプション併用 | name引数とtags/tag/parameters/parameterの併用 | どちらか一方のみ指定する |
| InvalidArgumentException | サービス未検出 | 指定したサービス名に一致するものがない | 正しいサービス名を指定する |
| ServiceNotFoundException | サービス未登録 | サービスIDがコンテナに存在しない | `debug:container` で一覧を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

サービスが見つからない場合は部分一致検索の候補が表示される（インタラクティブモード時はchoiceで選択可能）。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コンテナ内の全サービス数（数百〜数千） |
| 目標処理時間 | 数秒以内（コンテナビルド時間に依存） |
| メモリ使用量上限 | DIコンテナのビルドに必要なメモリ（アプリケーション規模に依存） |

## 排他制御

読み取り専用操作のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | 非推奨サービス表示時 | サービスの非推奨メッセージ |
| ノートログ | 削除済みサービス表示時 | サービスが削除/インライン化された旨の注記 |
| コメントログ | インタラクティブモード終了時 | 検索ヒントメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- BuildDebugContainerTraitを使用してデバッグ用のContainerBuilderを取得する
- サービスID検索時はバックスラッシュを除去した部分一致検索にも対応する
- タグ名の部分一致検索にも対応し、インタラクティブモードでは候補選択が可能
- --show-hiddenオプションを使用しない限り、ドット始まりのサービスIDとcontainer.excludedタグ付きサービスは非表示
- DescriptorHelperが対応するフォーマットに依存する（txt, json, xml, md等）
- @始まりのサービスIDがServiceNotFoundExceptionの場合、@なしのIDで再検索を試みる
- --parametersオプション時はParameterBag全体が出力対象となり、非推奨パラメータも含まれる
