# バッチ設計書 17-debug:autowiring

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `debug:autowiring` コマンドのバッチ設計書である。このコマンドは、オートワイヤリングでタイプヒントとして使用可能なクラスとインターフェースの一覧を表示するためのデバッグ用CLIツールである。

### 本バッチの処理概要

`debug:autowiring` コマンドは、DIコンテナに登録されたサービスの中からオートワイヤリングのタイプヒントとして利用可能なクラスやインターフェースを抽出し、エイリアス情報やターゲット情報とともに一覧表示する。

**業務上の目的・背景**：Symfonyのオートワイヤリング機能では、コンストラクタのタイプヒントに基づいて自動的にサービスが注入される。開発者が「どのクラス/インターフェースをタイプヒントとして使用すればどのサービスが注入されるか」を把握するために、利用可能な型の一覧と対応するサービスの情報が必要となる。このコマンドによりオートワイヤリングの設定状況を確認・デバッグできる。

**バッチの実行タイミング**：随時実行（手動）。オートワイヤリングの設定確認やデバッグが必要な際に実行する。

**主要な処理内容**：
1. DIコンテナをビルドし、全サービスIDを取得する
2. サービスIDを型名（クラス/インターフェース）としてフィルタリングする
3. 検索キーワードが指定されている場合はさらにフィルタリングする
4. 各型についてエイリアス情報、ターゲット情報、非推奨情報を付加して表示する

**前後の処理との関連**：`debug:container` コマンドの `--types` オプションと類似の機能を持つが、本コマンドはエイリアス情報やターゲット情報などのより詳細な情報を表示する。`debug:container --types` は型のフィルタリングのみを行う。

**影響範囲**：読み取り専用の操作であり、アプリケーションの状態を変更しない。

## バッチ種別

デバッグ / オートワイヤリング情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyカーネルが有効 | アプリケーションのカーネルが正常にブートできること |

### 実行可否判定

常に実行可能。検索キーワード指定時に該当する型が見つからない場合はエラーを表示する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| search | string | No | null | フィルタリング用の検索キーワード |
| --all | bool | No | false | エイリアスされていないサービスも表示する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| DIコンテナ | ContainerBuilder | アプリケーションのサービスコンテナ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | オートワイヤリング可能な型の一覧（エイリアス・ターゲット情報付き） |
| 標準エラー出力 | テキスト | エラーメッセージ |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. DIコンテナのビルド
   └─ getContainerBuilder でContainerBuilderを取得
2. サービスIDの型フィルタリング
   └─ filterToServiceTypes で有効なクラス/インターフェース名のみを抽出
3. 検索キーワードによるフィルタリング（search引数指定時）
   └─ 検索文字列を正規化（非英数字・非ASCII文字を除去）
   └─ バックスラッシュを除去した部分一致検索（大文字小文字無視）
   └─ ドット始まりのサービスを除外
   └─ 一致なしの場合はエラー終了
4. 逆エイリアスマップの構築
   └─ コンテナのエイリアスからドット始まりIDの逆引きマップを生成
5. サービスIDの自然順ソート
6. 各型の情報出力
   └─ クラス説明（Descriptor::getClassDescription）の表示
   └─ ファイルリンク（FileLinkFormatter）の生成
   └─ エイリアス情報の表示（alias:xxx）
   └─ ターゲット情報の表示（target:xxx）
   └─ 非推奨フラグの表示
   └─ container.excludedタグ付きサービスのスキップ
7. 追加情報の表示
   └─ --allなしの場合、非表示サービス数の表示
   └─ --all指定時、インターフェース使用推奨のヒント表示
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B[DIコンテナをビルド]
    B --> C[全サービスIDを型名でフィルタ]
    C --> D{search引数あり?}
    D -->|はい| E[検索文字列で部分一致フィルタ]
    E --> F{一致する型あり?}
    F -->|いいえ| G[エラー: 一致する型なし]
    F -->|はい| H[逆エイリアスマップ構築]
    D -->|いいえ| H
    H --> I[サービスIDを自然順ソート]
    I --> J[各型の情報を出力]
    J --> K{--all オプション?}
    K -->|いいえ| L[非表示サービス数を表示]
    K -->|はい| M[インターフェース推奨ヒント表示]
    L --> N[正常終了]
    M --> N
    G --> O[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検索結果なし | search引数に一致するオートワイヤリング型がない | 検索キーワードを変更して再実行する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

検索結果がない場合はキーワードを変更するか、引数なしで全型一覧を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コンテナ内のオートワイヤリング可能な型数（数十〜数百） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | DIコンテナのビルドに必要なメモリ |

## 排他制御

読み取り専用操作のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイトルログ | 一覧表示前 | 「Autowirable Types」 |
| テキストログ | 一覧表示前 | 「The following classes & interfaces can be used as type-hints when autowiring:」 |
| テキストログ | 検索時 | 検索キーワードの表示 |
| テキストログ | 一覧後 | 非表示サービス数 or インターフェース推奨ヒント |
| エラーログ | 検索結果なし | 「No autowirable classes or interfaces found matching "{search}"」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- ContainerDebugCommandを継承しており、filterToServiceTypesメソッドは親クラスで定義されている
- FileLinkFormatterが設定されている場合、クラス名にファイルリンクが付加される（IDEとの連携用）
- 逆エイリアスマップはドット始まりのエイリアスID（内部ID）から元のサービスIDへの対応を構築する
- container.excludedタグ付きのサービスは表示から除外される
- container.decoratorタグを持つサービスのエイリアスは、デコレータの元IDで表示される
- --allオプションなしの場合、エイリアスされていない具体的なサービスは非表示（カウント数のみ表示）
- シェル補完機能があり、search引数で型名の候補が表示される
