# バッチ設計書 18-debug:event-dispatcher

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `debug:event-dispatcher` コマンドのバッチ設計書である。このコマンドは、アプリケーションに設定されたイベントリスナーの情報を表示するためのデバッグ用CLIツールである。

### 本バッチの処理概要

`debug:event-dispatcher` コマンドは、EventDispatcherに登録された全てのイベントリスナーを一覧表示する。特定のイベント名やイベント名の部分一致検索にも対応し、複数のディスパッチャーの切り替え表示も可能である。

**業務上の目的・背景**：Symfonyアプリケーションではイベント駆動アーキテクチャが広く使用され、様々なイベントリスナーやサブスクライバーが登録される。開発者が「どのイベントにどのリスナーが登録されているか」「リスナーの優先度はどうなっているか」を把握するために、登録状況を可視化する必要がある。このコマンドによりイベントリスナーの設定を確認・デバッグできる。

**バッチの実行タイミング**：随時実行（手動）。イベントリスナーの設定確認やデバッグが必要な際に実行する。

**主要な処理内容**：
1. 指定されたディスパッチャーサービスを取得する
2. イベント名が指定された場合、直接一致または部分一致でイベントを検索する
3. DescriptorHelperを使用してリスナー情報を指定フォーマットで出力する

**前後の処理との関連**：`debug:container` コマンドはサービス全般の情報を表示するが、本コマンドはイベントリスナーに特化した詳細表示を行う。

**影響範囲**：読み取り専用の操作であり、アプリケーションの状態を変更しない。

## バッチ種別

デバッグ / イベントリスナー情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| EventDispatcherが登録されている | 指定されたディスパッチャーサービスがDIコンテナに存在すること |

### 実行可否判定

指定されたディスパッチャーサービスがコンテナに存在しない場合はエラーを返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| event | string | No | null | イベント名またはイベント名の一部（部分一致検索） |
| --dispatcher | string | No | event_dispatcher | 対象のイベントディスパッチャーサービス名 |
| --format | string | No | txt | 出力フォーマット（DescriptorHelperの対応フォーマット） |
| --raw | bool | No | false | 生の説明を出力する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| EventDispatcher | EventDispatcherInterface | 指定されたイベントディスパッチャー |
| ContainerInterface | ServiceLocator | ディスパッチャーサービスの取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | txt/json/xml/md | イベントリスナーの一覧情報 |
| 標準エラー出力 | テキスト | エラーメッセージ、警告メッセージ |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. ディスパッチャーの取得
   └─ --dispatcherオプションで指定されたサービス名をコンテナから取得
   └─ サービスが存在しない場合はエラー終了
2. イベント名の解決
   └─ event引数が指定された場合：
      └─ ディスパッチャーにリスナーが登録されている場合は直接一致として処理
      └─ 登録されていない場合は部分一致検索（searchForEvent）
         └─ 結果0件：警告メッセージ表示、正常終了
         └─ 結果1件：そのイベントを対象に設定
         └─ 結果複数件：複数イベントの一覧として設定
3. DescriptorHelperによる出力
   └─ describe メソッドでディスパッチャーオブジェクトを出力
   └─ オプション（format, raw_text, event/events, dispatcher_service_name）を設定
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{ディスパッチャーサービスが存在?}
    B -->|いいえ| C[エラー: ディスパッチャー不在]
    B -->|はい| D[ディスパッチャーを取得]
    D --> E{event引数あり?}
    E -->|いいえ| F[全リスナー一覧表示]
    E -->|はい| G{直接一致するリスナーあり?}
    G -->|はい| H[該当イベントのリスナー表示]
    G -->|いいえ| I[部分一致検索]
    I --> J{一致件数?}
    J -->|0件| K[警告: リスナーなし]
    J -->|1件| L[該当イベントのリスナー表示]
    J -->|複数件| M[複数イベントの一覧表示]
    F --> N[DescriptorHelperで出力]
    H --> N
    K --> O[正常終了]
    L --> N
    M --> N
    N --> O
    C --> P[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ディスパッチャー不在 | 指定されたディスパッチャーサービスがコンテナに存在しない | 正しいディスパッチャー名を指定する |
| 0（警告） | リスナー未登録 | 指定イベントにリスナーが登録されていない | イベント名を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ディスパッチャーサービスが見つからない場合は、DI設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 登録されたイベント数・リスナー数（数十〜数百） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 通常のCLIコマンド範囲 |

## 排他制御

読み取り専用操作のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | ディスパッチャー不在時 | 「Event dispatcher "{name}" is not available.」 |
| 警告ログ | リスナー未登録時 | 「The event "{event}" does not have any registered listeners.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- デフォルトのディスパッチャーは `event_dispatcher` サービス（DEFAULT_DISPATCHER定数）
- --dispatcherオプションでデフォルト以外のディスパッチャーを指定した場合、出力にdispatcher_service_nameが含まれる
- 部分一致検索はstrtolowerによる大文字小文字無視の部分文字列検索
- リスナーが登録されていないイベントの場合は警告を表示するが、戻り値は0（正常終了）
- シェル補完機能があり、event引数でイベント名候補、--dispatcherオプションでディスパッチャー名候補、--formatオプションでフォーマット候補が表示される
- dispatchersはServiceProviderInterface経由で提供されるため、動的なディスパッチャー候補の取得が可能
