# バッチ設計書 19-debug:router

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する `debug:router` コマンドのバッチ設計書である。このコマンドは、アプリケーションに設定された現在のルート情報を表示するためのデバッグ用CLIツールである。

### 本バッチの処理概要

`debug:router` コマンドは、Symfonyルーターに登録された全ルートの一覧を表示する。特定のルート名を指定した詳細表示、コントローラー表示、エイリアス表示、HTTPメソッドによるフィルタリングにも対応する。

**業務上の目的・背景**：Symfonyアプリケーションのルーティング設定は、アノテーション、YAML、XML、PHP等の複数のソースから構成され、最終的なルート定義を把握するのは容易ではない。開発者がURLパターン、対応するコントローラー、HTTPメソッド制約、ルートパラメータ等の情報を確認するためにこのコマンドが必要となる。URLの設計確認、ルーティングの重複検出、デバッグに幅広く使用される。

**バッチの実行タイミング**：随時実行（手動）。ルーティングの設定確認やデバッグが必要な際に実行する。

**主要な処理内容**：
1. RouterInterfaceからRouteCollectionを取得する
2. ルート名が指定された場合、完全一致または部分一致でルートを検索する
3. DescriptorHelperを使用して、ルート情報を指定フォーマットで出力する
4. HTTPメソッドによるフィルタリングを適用する

**前後の処理との関連**：`router:match` コマンドはURLパスからルートのマッチングをシミュレートするのに対し、本コマンドはルート定義自体の情報を表示する。

**影響範囲**：読み取り専用の操作であり、アプリケーションのルーティング設定を変更しない。

## バッチ種別

デバッグ / ルーティング情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| RouterInterfaceが登録されている | ルーターサービスがDIコンテナに存在すること |

### 実行可否判定

常に実行可能。指定したルート名が見つからない場合はInvalidArgumentExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | null | ルート名（部分一致検索可能） |
| --show-controllers | bool | No | false | 一覧にコントローラー情報を表示する |
| --show-aliases | bool | No | false | 一覧にエイリアス情報を表示する |
| --format | string | No | txt | 出力フォーマット（DescriptorHelperの対応フォーマット） |
| --raw | bool | No | false | 生のルート情報を出力する |
| --method | string | No | 空文字列 | HTTPメソッドでフィルタリングする（GET, POST, PUT, DELETE, PATCH） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| RouterInterface | RouteCollection | アプリケーションのルートコレクション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | txt/json/xml/md | ルート情報の一覧または詳細 |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. ルートコレクションの取得
   └─ router->getRouteCollection() で全ルートを取得
2. コンテナビルダーの準備（FileLinkFormatter設定時のみ）
   └─ 遅延ロードのクロージャとして準備
3A. ルート名指定時の処理
   └─ routes->get(name) で完全一致を検索
   └─ findRouteNameContaining で部分一致を検索（HTTPメソッドフィルタ付き）
   └─ 非インタラクティブかつ完全一致なしかつ複数一致：部分一致ルート一覧を表示
   └─ 完全一致なしかつ部分一致あり：choice で選択（1件なら自動選択）
   └─ ルートが見つからない場合：InvalidArgumentException
   └─ 単一ルートの詳細をDescriptorHelperで出力
3B. ルート名未指定時の処理
   └─ 全ルートをDescriptorHelperで一覧出力
   └─ --show-controllers, --show-aliases, --method オプションを適用
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B[RouteCollectionを取得]
    B --> C{name引数あり?}
    C -->|いいえ| D[全ルート一覧をDescriptorHelperで出力]
    C -->|はい| E[完全一致ルートを検索]
    E --> F[部分一致ルートを検索]
    F --> G{完全一致あり?}
    G -->|はい| H[該当ルートの詳細を出力]
    G -->|いいえ| I{部分一致あり?}
    I -->|いいえ| J[InvalidArgumentException]
    I -->|はい| K{非インタラクティブ+複数一致?}
    K -->|はい| L[部分一致ルート一覧を出力]
    K -->|いいえ| M{1件のみ?}
    M -->|はい| N[自動選択して詳細を出力]
    M -->|いいえ| O[choice で選択して詳細を出力]
    D --> P[正常終了]
    H --> P
    L --> P
    N --> P
    O --> P
    J --> Q[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベースへの操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgumentException | ルート未検出 | 指定したルート名に完全一致も部分一致もしない | 正しいルート名を指定する。引数なしで一覧を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ルートが見つからない場合は引数なしで全ルート一覧を確認し、正しいルート名を把握する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 登録ルート数（数十〜数百） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 通常のCLIコマンド範囲 |

## 排他制御

読み取り専用操作のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 該当なし | - | DescriptorHelper経由で直接出力される |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

手動実行コマンドのため、定常的な監視・アラートは設定しない。

## 備考

- ContainerDebugCommandとは異なり、Commandを直接継承している（ただしBuildDebugContainerTraitを使用）
- RouterInterfaceとFileLinkFormatterをコンストラクタで受け取る
- FileLinkFormatterが設定されている場合、コンテナビルダーは遅延ロード（クロージャ）で準備される
- 部分一致検索はstriposによる大文字小文字無視で、ルート名に対して行われる
- --methodオプションによるフィルタリングは部分一致検索時にもルートのHTTPメソッド制約と照合される
- HTTPメソッドが未設定のルート（全メソッド許可）はメソッドフィルタの対象外
- インタラクティブモードでは部分一致の候補からchoiceで選択可能
- シェル補完機能があり、name引数でルート名候補、--formatオプションでフォーマット候補が表示される
