# バッチ設計書 2-cache:warmup

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:warmup` コンソールコマンドのバッチ設計書である。空のキャッシュディレクトリに対してキャッシュのウォームアップ（事前生成）処理を実行する仕様を定義する。

### 本バッチの処理概要

`cache:warmup` コマンドは、空のキャッシュに対してキャッシュウォーマーを順次実行し、アプリケーション起動時に必要なキャッシュファイルを事前に生成する。

**業務上の目的・背景**：アプリケーションの初回リクエスト時にキャッシュ生成が発生するとレスポンスが大幅に遅延するため、事前にキャッシュを生成しておくことでユーザー体験を向上させる。デプロイ後の初回アクセスで発生するパフォーマンス低下（コールドスタート問題）を回避するための重要なコマンドである。`cache:clear` 内部でも呼び出されるが、単独での実行も可能である。

**バッチの実行タイミング**：デプロイ後、`cache:clear` の後に実行される。または `cache:clear --no-warmup` 実行後に個別に実行されることがある。CI/CDパイプラインにおいてキャッシュクリア後のステップとして組み込まれるケースが多い。

**主要な処理内容**：
1. 現在の環境とデバッグモードの情報をコメントとして出力
2. `--no-optional-warmers` が指定されていない場合、オプショナルウォーマーを有効化
3. カーネルの `warmUp()` メソッドを実行（カーネルがWarmableInterfaceを実装している場合）
4. CacheWarmerAggregateを通じて全登録済みキャッシュウォーマーを順次実行
5. プリロードファイルが存在する場合、ウォーマーが返すプリロードクラスリストを追記

**前後の処理との関連**：通常は `cache:clear` の後に実行される。`cache:clear` コマンドは内部でウォームアップ処理を含むが、本コマンドは単独で空のキャッシュに対してウォームアップを行う目的で使用される。実行前にキャッシュが空であることが前提条件である。

**影響範囲**：アプリケーション全体のキャッシュファイル（DIコンテナ、ルーティング、テンプレート、バリデーション、シリアライザメタデータ等）が生成される。ビルドディレクトリとキャッシュディレクトリの両方に影響する。

## バッチ種別

キャッシュ管理 / メンテナンスコマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / デプロイスクリプト / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| キャッシュが空であること | コマンド実行前にキャッシュディレクトリが空である必要がある |
| キャッシュディレクトリの書き込み権限 | `kernel.cache_dir` に書き込み権限が必要 |
| ビルドディレクトリの書き込み権限 | `kernel.build_dir` に書き込み権限が必要 |

### 実行可否判定

キャッシュが空であることが前提条件であるが、コマンド自体が空であるかどうかの厳密なチェックは行わない。既存のキャッシュがある場合は上書きされる形で再生成が行われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --no-optional-warmers | bool | No | false | オプショナルキャッシュウォーマーをスキップする（高速化） |
| --env | string | No | dev | 対象環境（dev/prod/test等） |
| --no-debug | bool | No | false | デバッグモードを無効にする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| kernel.cache_dir | ファイルシステム | キャッシュファイルの出力先ディレクトリ |
| kernel.build_dir | ファイルシステム | ビルドファイルの出力先ディレクトリ |
| 登録済みCacheWarmer | サービスコンテナ | DIコンテナに登録されたキャッシュウォーマーサービス群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| kernel.cache_dir | ファイルシステム | 生成されたキャッシュファイル群 |
| kernel.build_dir | ファイルシステム | 生成されたビルドファイル群 |
| preload.php | PHPファイル | プリロード対象クラスリスト（該当する場合） |
| stdout | テキスト | 処理進捗メッセージおよび成功メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | コンテナクラス名に基づくPHPファイル群、preload.php等 |
| 出力先 | kernel.cache_dir / kernel.build_dir |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（PHPファイル） |

## 処理フロー

### 処理シーケンス

```
1. 環境情報の出力
   └─ 環境名とデバッグモード状態をコメントとして出力
2. オプショナルウォーマーの有効化判定
   └─ --no-optional-warmers が未指定の場合、オプショナルウォーマーを有効化
3. カーネルウォームアップ
   └─ カーネルがWarmableInterfaceを実装している場合、kernel.warmUp()を実行
4. CacheWarmerAggregate実行
   └─ 登録済み全キャッシュウォーマーを順次実行し、キャッシュファイルを生成
5. プリロードファイル更新
   └─ プリロード対象クラスリストが返された場合、preload.phpに追記
6. 成功メッセージ出力
   └─ キャッシュウォームアップ完了のメッセージを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境情報出力]
    B --> C{--no-optional-warmers?}
    C -->|No| D[オプショナルウォーマー有効化]
    C -->|Yes| E[オプショナルウォーマー無効のまま]
    D --> F{カーネルがWarmableInterface実装?}
    E --> F
    F -->|Yes| G[kernel.warmUp実行]
    F -->|No| H[CacheWarmerAggregate実行]
    G --> H
    H --> I{preloadファイル存在 かつ cache_dir==build_dir?}
    I -->|Yes| J[preload.phpにクラスリスト追記]
    I -->|No| K[成功メッセージ出力]
    J --> K
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースに対する直接的な操作を行わない。ただし、個別のキャッシュウォーマーがデータベースメタデータを読み取ってキャッシュ化する可能性がある。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Exception | ウォーマーエラー | 個別のキャッシュウォーマーが例外をスローした場合 | エラー原因のウォーマーを特定し、関連する設定やリソースを修正する |
| IOException | ファイル書き込みエラー | キャッシュディレクトリへの書き込みに失敗 | ディレクトリ権限を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. キャッシュウォームアップに失敗した場合、キャッシュディレクトリを手動で削除し、`cache:clear` コマンドから再実行する。
2. 特定のウォーマーに起因するエラーの場合、`--no-optional-warmers` オプションを使用して必須ウォーマーのみで実行を試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 登録されたキャッシュウォーマーの数に依存 |
| 目標処理時間 | 環境依存（通常数秒〜数十秒） |
| メモリ使用量上限 | アプリケーション全体のメタデータ量に依存 |

## 排他制御

同時実行は推奨されない。複数プロセスから同時にウォームアップを実行した場合、ファイル書き込みが競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | `Warming up the cache for the {env} environment with debug {debug}` |
| 終了ログ | バッチ終了時 | `Cache for the "{env}" environment (debug={debug}) was successfully warmed.` |
| エラーログ | エラー発生時 | 例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 環境依存 | デプロイ監視システム |
| 終了コード | 0以外 | デプロイ監視システム |

## 備考

- 本コマンドの実行前にキャッシュが空であることがドキュメント上の前提条件として記載されている（ヘルプテキスト: "Before running this command, the cache must be empty."）。
- プリロードファイルへの追記は、`cache_dir` と `build_dir` が同一の場合にのみ行われる（L76の条件分岐）。
- `CacheWarmerAggregate` はSymfony DIコンテナを通じて注入される。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CacheWarmupCommand.php`
