# バッチ設計書 21-router:match

## 概要

本ドキュメントは、Symfonyフレームワークの`router:match`コンソールコマンドのバッチ設計書である。このコマンドは、指定されたパス情報に対してルーティングのマッチングをシミュレートし、どのルートがマッチするか、あるいはなぜマッチしないかをデバッグ目的で表示するものである。

### 本バッチの処理概要

`router:match`コマンドは、Symfonyアプリケーションに定義されたルーティング設定に対して、指定されたURLパスのマッチングをシミュレーションし、その結果を開発者に提示するデバッグ用ユーティリティである。

**業務上の目的・背景**：Webアプリケーション開発において、URLルーティングの設定は複雑になりがちであり、期待するルートにリクエストがマッチしない問題が頻繁に発生する。本コマンドは、実際のHTTPリクエストを送信せずにルーティングマッチングの過程を可視化し、開発者がルーティング設定の問題を迅速に特定・修正できるようにする。

**バッチの実行タイミング**：開発者が任意のタイミングで手動実行する。ルーティング設定の変更後やデバッグ時に随時使用される。

**主要な処理内容**：
1. 入力されたパス情報とオプション（HTTPメソッド、スキーム、ホスト）を取得する
2. RouterInterfaceからルートコレクションとリクエストコンテキストを取得し、TraceableUrlMatcherを構築する
3. ExpressionLanguageプロバイダーが登録されている場合はマッチャーに追加する
4. 全ルートに対してマッチングをトレースし、各ルートのマッチ結果（完全一致、部分一致、不一致）を表示する
5. 完全一致するルートが見つかった場合は`debug:router`コマンドを呼び出してルートの詳細情報を表示する

**前後の処理との関連**：`debug:router`コマンド（No.19）と連携して動作する。マッチしたルートが見つかった場合、`debug:router`コマンドを内部的に呼び出してルートの詳細情報を表示する。

**影響範囲**：読み取り専用の操作であり、ルーティング設定やアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

デバッグ / ルーティング診断

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（開発者による任意実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyアプリケーションが構成済み | Kernelおよびルーティング設定がロード可能であること |
| RouterInterfaceの実装が利用可能 | DIコンテナにルーターサービスが登録されていること |

### 実行可否判定

引数`path_info`が必須であり、指定されていない場合はコマンドが実行されない。ルーターサービスがDIコンテナに存在しない場合はエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| path_info | string | Yes | なし | マッチングをシミュレートするURLパス |
| --method | string | No | null（現在のコンテキストから取得） | HTTPメソッド（GET, POST等）を設定 |
| --scheme | string | No | null（現在のコンテキストから取得） | URIスキーム（http, https）を設定 |
| --host | string | No | null（現在のコンテキストから取得） | URIホストを設定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ルートコレクション | RouterInterface | DIコンテナから取得したルーター内のルート定義一覧 |
| ExpressionLanguageProviders | iterable | ルート条件評価用のExpressionLanguageプロバイダー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テキスト | マッチング結果（成功・部分一致・不一致の情報） |

### 出力ファイル仕様

ファイル出力なし。コンソールへの標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ取得
   └─ path_info引数、method/scheme/hostオプションを取得
2. リクエストコンテキスト設定
   └─ オプションが指定されている場合、ルーターのコンテキストに反映
3. TraceableUrlMatcher構築
   └─ ルートコレクションとコンテキストからトレース可能なマッチャーを生成
4. ExpressionLanguageプロバイダー登録
   └─ 利用可能なプロバイダーをマッチャーに追加
5. マッチングトレース実行
   └─ 全ルートに対してpath_infoのマッチングを実行し、トレース結果を取得
6. 結果出力
   └─ ROUTE_ALMOST_MATCHES: 部分一致ルートの情報を表示
   └─ ROUTE_MATCHES: 完全一致ルートの成功メッセージとdebug:routerの詳細を表示
   └─ 不一致（verbose時）: マッチしなかったルートと理由を表示
7. 終了コード返却
   └─ マッチあり: 0、マッチなし: 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力パラメータ取得]
    B --> C[リクエストコンテキスト設定]
    C --> D[TraceableUrlMatcher構築]
    D --> E[ExpressionLanguageプロバイダー登録]
    E --> F[マッチングトレース実行]
    F --> G{トレース結果ループ}
    G -->|ROUTE_ALMOST_MATCHES| H[部分一致情報表示]
    G -->|ROUTE_MATCHES| I[成功メッセージ表示]
    I --> J[debug:routerコマンド実行]
    G -->|不一致 and verbose| K[不一致理由表示]
    H --> G
    J --> G
    K --> G
    G -->|ループ終了| L{マッチあり?}
    L -->|Yes| M[終了コード 0]
    L -->|No| N[エラーメッセージ表示]
    N --> O[終了コード 1]
    M --> P[バッチ終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドは読み取り専用であり、ルーティング設定のインメモリ解析のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | マッチ失敗 | 指定されたpath_infoにマッチするルートが存在しない | ルーティング設定を確認し、path_infoの値を修正する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

本コマンドはデバッグ用ユーティリティのため、障害時のリカバリは不要。ルーティング設定に問題がある場合は、`debug:router`コマンドで全ルートを確認し、設定を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | アプリケーション定義のルート数（通常数十〜数百件） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | マッチ成功時 | マッチしたルート名 |
| 部分一致ログ | 部分一致検出時 | ルート名とマッチしなかった理由 |
| エラーログ | マッチ失敗時 | マッチするルートが存在しない旨のエラーメッセージ |
| 詳細ログ | verbose時 | 各ルートの不一致理由 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

開発時デバッグ用コマンドのため、監視・アラートは不要。

## 備考

- `TraceableUrlMatcher`はSymfony Routingコンポーネントが提供するデバッグ用マッチャーであり、通常の`UrlMatcher`と異なり各ルートのマッチング過程をトレースする
- `--verbose`オプションを使用することで、マッチしなかった全ルートの理由も表示可能
- マッチしたルートが見つかった場合、内部的に`debug:router`コマンドを呼び出して詳細情報を表示する
