# バッチ設計書 22-config:dump-reference

## 概要

本ドキュメントは、Symfonyフレームワークの`config:dump-reference`コンソールコマンドのバッチ設計書である。このコマンドは、バンドルや拡張機能のデフォルト設定をYAMLまたはXML形式でダンプし、開発者が設定可能なオプションとそのデフォルト値を確認できるようにする。

### 本バッチの処理概要

`config:dump-reference`コマンドは、Symfonyアプリケーションに登録されたバンドルや拡張機能の設定ツリーを解析し、デフォルト値を含む設定リファレンスを出力するユーティリティコマンドである。

**業務上の目的・背景**：Symfonyアプリケーションの設定は多数のバンドルと拡張機能にまたがり、利用可能な設定オプションを把握することが困難な場合がある。本コマンドは、各バンドルが公開する設定スキーマとデフォルト値を一覧形式で出力することで、開発者が正確な設定キーやデフォルト値を迅速に確認できるようにする。`debug:config`（No.15）が現在のアクティブな設定値を表示するのに対し、本コマンドはデフォルト設定のリファレンスを表示する。

**バッチの実行タイミング**：開発者が任意のタイミングで手動実行する。設定ファイルの編集時やバンドルの設定オプションを調査する際に使用される。

**主要な処理内容**：
1. 引数が未指定の場合、利用可能なバンドルと非バンドル拡張のリストを表示する
2. 引数でバンドル名またはエイリアスが指定された場合、対応する拡張機能を検索する
3. 拡張機能からConfigurationInterfaceを取得し、設定ツリーを構築する
4. 指定されたフォーマット（yaml/xml）に応じたダンパーでデフォルト設定を出力する
5. `path`引数が指定された場合、特定の設定パスのみを出力する（YAML形式のみ対応）

**前後の処理との関連**：`debug:config`（No.15）と補完的な関係にある。`debug:config`が実行時の設定値を表示するのに対し、本コマンドはデフォルト設定のリファレンスを表示する。両方とも`AbstractConfigCommand`を基底クラスとして共有している。

**影響範囲**：読み取り専用の操作であり、設定ファイルやアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

デバッグ / 設定リファレンス出力

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（開発者による任意実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyアプリケーションが構成済み | Kernelおよびバンドル設定がロード可能であること |
| 対象バンドル/拡張がConfigurationInterfaceを実装 | 設定ツリーをダンプ可能であること |

### 実行可否判定

引数`name`が未指定の場合は、利用可能なバンドル/拡張の一覧を表示して正常終了する。指定されたバンドル/拡張が見つからない場合はLogicExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | null | バンドル名または拡張エイリアス |
| path | string | No | null | 設定オプションパス（YAML形式のみ対応） |
| --format | string | No | yaml | 出力フォーマット（yaml, xml） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| バンドル設定 | ConfigurationInterface | カーネルに登録されたバンドルの設定定義 |
| 拡張機能 | ExtensionInterface | DIコンテナに登録された拡張機能 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | YAML/XML | デフォルト設定リファレンス |

### 出力ファイル仕様

ファイル出力なし。コンソールへの標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. 引数name取得
   └─ 未指定の場合、バンドル/拡張リストを表示して終了
2. 拡張機能検索
   └─ findExtensionメソッドでバンドル名/エイリアスから拡張を検索
3. Configuration取得
   └─ ConfigurationInterface実装またはgetConfiguration()で設定ツリーを取得
4. 設定バリデーション
   └─ ConfigurationInterfaceが正しく実装されているか検証
5. フォーマット判定
   └─ yaml/xmlのいずれかを選択、pathオプションはyamlのみ対応
6. ダンパー生成・実行
   └─ YamlReferenceDumperまたはXmlReferenceDumperで設定をダンプ
7. 結果出力
   └─ ダンプ結果をコンソールに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{name引数あり?}
    B -->|No| C[バンドルリスト表示]
    C --> D[非バンドル拡張リスト表示]
    D --> E[終了コード 0]
    B -->|Yes| F[拡張機能検索]
    F --> G[Configuration取得]
    G --> H[設定バリデーション]
    H --> I{format判定}
    I -->|yaml| J[YamlReferenceDumper]
    I -->|xml| K[XmlReferenceDumper]
    I -->|その他| L[InvalidArgumentException]
    J --> M[設定ダンプ出力]
    K --> M
    M --> E
    L --> N[終了コード 1]
    E --> O[バッチ終了]
    N --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドは読み取り専用であり、設定ツリーのインメモリ解析のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | フォーマットエラー | yamlでないフォーマットでpathオプションを使用 | --format=yaml を指定するかpathオプションを削除 |
| 1 | Yamlコンポーネント未インストール | format=yamlだがYamlクラスが存在しない | `composer require symfony/yaml`を実行 |
| LogicException | 拡張機能未発見 | 指定されたバンドル/エイリアスが見つからない | 正しいバンドル名/エイリアスを指定 |
| LogicException | Configuration未実装 | getConfiguration()がnullを返す | バンドルのConfiguration実装を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

デバッグ用ユーティリティのため、リカバリ手順は不要。エラーメッセージに従って入力パラメータを修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 設定ツリーのノード数に依存（通常数十〜数百ノード） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 正常終了時 | デフォルト設定のYAML/XMLダンプ |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

開発時デバッグ用コマンドのため、監視・アラートは不要。

## 備考

- `AbstractConfigCommand`を継承しており、バンドル検索やConfiguration取得のロジックは基底クラスに実装されている
- `path`引数はYAML形式でのみサポートされ、特定の設定パスのみをダンプする機能を提供する
- 拡張機能に`docUrl`属性が設定されている場合、ドキュメントURLも出力に含まれる
- オートコンプリート機能により、バンドル名、拡張エイリアス、フォーマットオプションの補完が可能
