# バッチ設計書 25-lint:container

## 概要

本ドキュメントは、Symfonyフレームワークの`lint:container`コンソールコマンドのバッチ設計書である。このコマンドは、DIコンテナに登録されたサービスに注入される引数が、各サービスクラスの型宣言と一致することを検証する静的解析ツールである。

### 本バッチの処理概要

`lint:container`コマンドは、SymfonyのDIコンテナ定義を解析し、サービスに注入される値がサービスクラスのコンストラクタやメソッドの型宣言と矛盾しないことを検証するリントツールである。

**業務上の目的・背景**：SymfonyのDIコンテナは設定ファイルやPHPコードでサービス定義を行うが、型の不一致はランタイムエラーの原因となる。本コマンドは、アプリケーション起動前にコンテナ定義の型安全性を静的に検証することで、デプロイ前に潜在的な設定エラーを検出し、本番環境での障害を予防する。CI/CDパイプラインに組み込むことで継続的な品質保証が可能となる。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド時、デプロイ前の検証時、サービス定義変更後のローカル検証時に手動または自動で実行される。

**主要な処理内容**：
1. ContainerBuilderを取得する（キャッシュからの復元またはカーネルからの再構築）
2. コンパイラパスを設定する（CheckAliasValidityPass, CheckTypeDeclarationsPass）
3. コンテナをコンパイルし、型宣言の整合性を検証する
4. エラーがあれば報告し、なければ成功メッセージを表示する

**前後の処理との関連**：`debug:container`（No.16）がサービスの一覧を表示するのに対し、本コマンドはサービス定義の型安全性を検証する。`cache:clear`（No.1）実行後にキャッシュされたコンテナ定義を使用して検証を行う場合がある。

**影響範囲**：読み取り専用の操作であり、コンテナ定義やアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

リント / 静的解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDパイプライン、デプロイ前検証） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CD自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyアプリケーションが構成済み | カーネルおよびDIコンテナが構築可能であること |
| デバッグモードまたはコンテナダンプファイルの存在 | キャッシュからの復元またはコンテナ再構築が可能であること |

### 実行可否判定

カーネルが`Symfony\Component\HttpKernel\Kernel`を継承していない場合、かつキャッシュからの復元もできない場合はRuntimeExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --resolve-env-vars | bool | No | false | 環境変数を解決し、未定義の場合はエラーとする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コンテナダンプファイル | シリアライズされたContainerBuilder | キャッシュされたコンテナ定義 |
| カーネル | Kernel | コンテナの再構築元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テキスト | 検証成功メッセージ |
| コンソール（stderr） | テキスト | 型不一致エラーメッセージ |

### 出力ファイル仕様

ファイル出力なし。コンソールへの出力のみ。

## 処理フロー

### 処理シーケンス

```
1. ContainerBuilder取得
   └─ キャッシュファイルが有効な場合: シリアライズされたContainerBuilderを復元
   └─ キャッシュ無効または存在しない場合: カーネルからコンテナを再構築
2. コンパイラパス設定
   └─ --resolve-env-vars時: ResolveParameterPlaceHoldersPass + ResolveFactoryClassPass
   └─ 通常時: parameterBagのresolved=trueに設定 + ResolveFactoryClassPass
   └─ CheckAliasValidityPass追加（TYPE_BEFORE_REMOVING）
   └─ CheckTypeDeclarationsPass追加（TYPE_AFTER_REMOVING）
3. ビルドパラメータ設定
   └─ container.build_time, container.build_hash, container.build_id, container.runtime_modeを設定
4. コンテナコンパイル
   └─ compile()メソッドで全コンパイラパスを実行
5. 結果出力
   └─ 成功: 成功メッセージを表示
   └─ 失敗: InvalidArgumentExceptionのメッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{キャッシュファイル有効?}
    B -->|Yes| C[シリアライズされたContainerBuilder復元]
    B -->|No| D{Kernelクラス継承?}
    D -->|Yes| E[カーネルからコンテナ再構築]
    D -->|No| F[RuntimeException]
    C --> G[コンパイラパス設定]
    E --> G
    G --> H[ビルドパラメータ設定]
    H --> I[コンテナコンパイル]
    I --> J{コンパイル成功?}
    J -->|Yes| K[成功メッセージ表示]
    J -->|No| L[エラーメッセージ表示]
    K --> M[終了コード 0]
    L --> N[終了コード 1]
    F --> O[終了コード 2]
    M --> P[バッチ終了]
    N --> P
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはDIコンテナ定義のインメモリ解析のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 型不一致 | サービスに注入される値が型宣言と一致しない | サービス定義の引数を修正 |
| 2 | ランタイムエラー | ContainerBuilderの取得に失敗 | カーネルの構成を確認、cache:clearを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

コンテナ取得エラー（終了コード2）の場合は`cache:clear`を実行してキャッシュを再構築する。型不一致エラー（終了コード1）の場合はエラーメッセージに基づいてサービス定義を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | DIコンテナのサービス定義数（数百〜数千件） |
| 目標処理時間 | 数秒〜数十秒（コンテナサイズに依存） |
| メモリ使用量上限 | コンテナ全体をメモリに展開するため、大規模アプリケーションでは数百MB必要な場合あり |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。ただし、キャッシュファイルの同時更新が行われている場合は不整合が生じる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 終了ログ | 成功時 | "The container was linted successfully: all services are injected with values that are compatible with their type declarations." |
| エラーログ | 型不一致検出時 | InvalidArgumentExceptionのメッセージ |
| エラーログ | コンテナ取得失敗時 | RuntimeExceptionのメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI/CDパイプライン終了コード | 0以外 | CI/CD通知先 |

CI/CDパイプラインでの実行時は終了コードを監視し、0以外の場合はビルド失敗として扱う。

## 備考

- `final`クラスとして宣言されており、継承不可
- `--resolve-env-vars`オプションを使用すると環境変数プレースホルダーが実際の値に解決され、未定義の環境変数がある場合はエラーとなる
- キャッシュされたコンテナダンプファイルが存在する場合はそれを使用し、存在しない場合はカーネルからコンテナを再構築する
- `CheckTypeDeclarationsPass`がコンパイラパスとして追加され、型宣言の整合性を検証する
- `container.runtime_mode`パラメータは`web=0`に設定され、CLI環境として実行される
