# バッチ設計書 26-lint:xliff

## 概要

本ドキュメントは、Symfonyフレームワークの`lint:xliff`コンソールコマンドのバッチ設計書である。このコマンドは、XLIFFファイルの構文を検証し、発見されたエラーを出力するリントツールである。基盤実装はSymfony Translationコンポーネントに含まれる。

### 本バッチの処理概要

`lint:xliff`コマンドは、XLIFF（XML Localization Interchange File Format）翻訳ファイルの構文バリデーションを行い、XMLスキーマ違反やファイル名とtarget-language属性の不一致を検出するリントツールである。

**業務上の目的・背景**：XLIFFファイルはXMLベースの翻訳ファイル形式であり、構文エラーがあるとアプリケーション実行時に翻訳の読み込みに失敗する。本コマンドは、XLIFFファイルの構文を事前に検証することで、翻訳ファイルの品質を保証し、本番環境での翻訳エラーを予防する。CI/CDパイプラインに組み込むことで継続的な翻訳ファイルの品質保証が可能となる。

**バッチの実行タイミング**：翻訳ファイルの編集後、デプロイ前の検証時、CI/CDパイプラインでの自動実行時に使用される。

**主要な処理内容**：
1. 入力ファイルまたはディレクトリ、またはSTDINから対象を特定する
2. XLIFFファイル（.xlf, .xliff拡張子）を再帰的に収集する
3. 各ファイルのXML構文をDOMDocumentで解析する
4. target-language属性とファイル名の一致を検証する
5. XliffUtils::validateSchemaでXMLスキーマバリデーションを実行する
6. 結果をテキスト、JSON、またはGitHub Actions形式で出力する

**前後の処理との関連**：`lint:yaml`（No.27）と同様のリント機能を提供するが、対象がXLIFFファイルに特化している。`translation:extract`（No.24）で生成されたXLIFFファイルの検証に使用できる。

**影響範囲**：読み取り専用の操作であり、XLIFFファイルやアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

リント / ファイル構文検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDパイプライン、翻訳ファイル更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CD自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 対象ファイルまたはディレクトリが存在 | 指定されたパスが読み取り可能であること |
| libxml PHP拡張 | XMLパーサーが利用可能であること |

### 実行可否判定

ファイル名引数もSTDIN入力も提供されない場合はRuntimeExceptionがスローされる。指定されたファイル/ディレクトリが読み取り不可の場合もRuntimeExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| filename | string[] | No | なし | ファイル、ディレクトリ、または"-"（STDIN） |
| --format | string | No | 自動検出（GitHub Actions環境ならgithub、それ以外はtxt） | 出力フォーマット（txt, json, github） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| XLIFFファイル | XML（.xlf, .xliff） | 検証対象の翻訳ファイル |
| STDIN | テキスト | パイプ入力されたXLIFFコンテンツ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テキスト/JSON/GitHub Annotations | バリデーション結果 |

### 出力ファイル仕様

ファイル出力なし。コンソールへの出力のみ。

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ取得
   └─ filename引数、formatオプションを取得
   └─ format未指定時はGitHub Actions環境を自動検出
2. 入力判定
   └─ STDIN（"-"）の場合: php://stdinからコンテンツを読み取り
   └─ ファイル/ディレクトリの場合: 再帰的に.xlf/.xliffファイルを収集
3. 各ファイルのバリデーション
   └─ 空ファイルチェック
   └─ DOMDocumentでXMLをロード
   └─ target-language属性とファイル名の一致チェック
   └─ XliffUtils::validateSchemaでスキーマバリデーション
4. 結果出力
   └─ txt: テキスト形式でOK/ERRORを表示
   └─ json: JSON形式で出力
   └─ github: GitHub Actions annotations形式で出力
5. 終了コード返却
   └─ エラーなし: 0、エラーあり: 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{入力タイプ}
    B -->|STDIN| C[STDINからコンテンツ読み取り]
    B -->|ファイル/ディレクトリ| D[.xlf/.xliffファイル収集]
    B -->|未指定| E[RuntimeException]
    C --> F[バリデーション実行]
    D --> G[各ファイルループ]
    G --> H{ファイル読み取り可能?}
    H -->|No| I[RuntimeException]
    H -->|Yes| F
    F --> J[XML構文チェック]
    J --> K[target-language/ファイル名一致チェック]
    K --> L[XMLスキーマバリデーション]
    L --> M{出力フォーマット}
    M -->|txt| N[テキスト形式出力]
    M -->|json| O[JSON形式出力]
    M -->|github| P[GitHub Annotations出力]
    N --> Q{エラーあり?}
    O --> Q
    P --> Q
    Q -->|No| R[成功メッセージ]
    Q -->|Yes| S[警告メッセージ]
    R --> T[終了コード 0]
    S --> U[終了コード 1]
    T --> V[バッチ終了]
    U --> V
    E --> V
    I --> V
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはファイルの読み取りとXMLバリデーションのみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | バリデーションエラー | XLIFFファイルに構文エラーまたはスキーマ違反がある | エラーメッセージに基づいてXLIFFファイルを修正 |
| RuntimeException | 入力なし | ファイル名もSTDIN入力も提供されない | ファイル名を引数に指定するかSTDINから入力 |
| RuntimeException | 読み取り不可 | ファイル/ディレクトリが読み取り不可 | パーミッションを確認 |
| InvalidArgumentException | 不正フォーマット | サポートされていない出力フォーマット | txt, json, githubのいずれかを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

バリデーションエラーは翻訳ファイルの修正で対応する。エラーメッセージには行番号・カラム番号が含まれるため、問題箇所の特定が容易である。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 翻訳ファイル数（数十〜数百ファイル） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 各ファイル検証後 | OK またはエラー詳細（行番号、カラム番号、メッセージ） |
| 終了ログ | バッチ終了時 | 全ファイルの検証結果サマリー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI/CDパイプライン終了コード | 0以外 | CI/CD通知先 |

## 備考

- 基盤実装は`src/Symfony/Component/Translation/Command/XliffLintCommand.php`に配置されている
- `XliffUtils::validateSchema`を使用してXLIFF 1.2/2.0のスキーマバリデーションを行う
- target-language属性とファイル名のロケール部分の一致を検証する機能を持つ（大文字小文字非区別）
- `requireStrictFileNames`フラグにより、ファイル名のパターンマッチングの厳密さを制御できる
- GitHub Actions環境では自動的にgithubフォーマットが選択され、PRコメントにエラー箇所が表示される
- ディレクトリイテレータとis_readableのカスタムプロバイダーをコンストラクタで注入可能
