# バッチ設計書 27-lint:yaml

## 概要

本ドキュメントは、Symfonyフレームワークの`lint:yaml`コンソールコマンドのバッチ設計書である。このコマンドは、YAMLファイルの構文を検証し、発見されたパースエラーを出力するリントツールである。基盤実装はSymfony Yamlコンポーネントに含まれる。

### 本バッチの処理概要

`lint:yaml`コマンドは、YAMLファイルの構文バリデーションを行い、パースエラーを検出してレポートするリントツールである。Symfony Yamlコンポーネントの`Parser`クラスを使用してYAMLファイルをパースし、構文の正当性を検証する。

**業務上の目的・背景**：YAMLはSymfonyアプリケーションの設定ファイル、ルーティング定義、サービス定義、翻訳ファイルなど、多くの場面で使用される。YAML構文エラーはアプリケーションの起動失敗やランタイムエラーの原因となるため、事前検証が重要である。本コマンドは、YAMLファイルの構文を検証することで、設定ファイルの品質を保証し、デプロイ前に問題を検出する。

**バッチの実行タイミング**：設定ファイルの編集後、デプロイ前の検証時、CI/CDパイプラインでの自動実行時に使用される。

**主要な処理内容**：
1. 入力ファイルまたはディレクトリ、またはSTDINから対象を特定する
2. YAMLファイル（.yml, .yaml拡張子）を再帰的に収集する
3. 除外パスを適用してファイルをフィルタリングする
4. Symfony Yaml Parserで各ファイルをパースし構文を検証する
5. カスタムタグのパースオプションに対応する
6. 結果をテキスト、JSON、またはGitHub Actions形式で出力する

**前後の処理との関連**：`lint:xliff`（No.26）と同様のリント機能を提供するが、対象がYAMLファイルに特化している。Symfony設定ファイル（services.yaml, routes.yaml等）の検証に日常的に使用される。

**影響範囲**：読み取り専用の操作であり、YAMLファイルやアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

リント / ファイル構文検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDパイプライン、設定ファイル更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CD自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 対象ファイルまたはディレクトリが存在 | 指定されたパスが読み取り可能であること |
| Symfony Yamlコンポーネント | Yaml Parserが利用可能であること |

### 実行可否判定

ファイル名引数もSTDIN入力も提供されない場合はRuntimeExceptionがスローされる。指定されたファイル/ディレクトリが読み取り不可の場合もRuntimeExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| filename | string[] | No | なし | ファイル、ディレクトリ、または"-"（STDIN） |
| --format | string | No | 自動検出（GitHub Actions環境ならgithub、それ以外はtxt） | 出力フォーマット（txt, json, github） |
| --exclude | string[] | No | なし | 除外するファイルパス（複数指定可） |
| --parse-tags | bool/null | No | null | カスタムタグをパースする（--no-parse-tagsで無効化） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| YAMLファイル | YAML（.yml, .yaml） | 検証対象のYAMLファイル |
| STDIN | テキスト | パイプ入力されたYAMLコンテンツ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テキスト/JSON/GitHub Annotations | バリデーション結果 |

### 出力ファイル仕様

ファイル出力なし。コンソールへの出力のみ。

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ取得
   └─ filename引数、format/exclude/parse-tagsオプションを取得
   └─ format未指定時はGitHub Actions環境を自動検出
2. パースフラグ設定
   └─ --parse-tags時: Yaml::PARSE_CUSTOM_TAGSフラグを追加
3. 入力判定
   └─ STDIN（"-"）の場合: php://stdinからコンテンツを読み取り
   └─ ファイル/ディレクトリの場合: 再帰的に.yml/.yamlファイルを収集
4. 除外パス適用
   └─ --excludeで指定されたパスをスキップ
5. 各ファイルのバリデーション
   └─ Yaml Parserでパース実行（PARSE_CONSTANTフラグ付き）
   └─ ParseException発生時はエラー情報を記録
   └─ E_USER_DEPRECATED発生時もParseExceptionに変換して記録
6. 結果出力
   └─ txt: テキスト形式でOK/ERRORを表示
   └─ json: JSON形式で出力
   └─ github: GitHub Actions annotations形式で出力
7. 終了コード返却
   └─ エラーなし: 0、エラーあり: 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{入力タイプ}
    B -->|STDIN| C[STDINからコンテンツ読み取り]
    B -->|ファイル/ディレクトリ| D[.yml/.yamlファイル収集]
    B -->|未指定| E[RuntimeException]
    C --> F[バリデーション実行]
    D --> G[除外パス適用]
    G --> H[各ファイルループ]
    H --> I{読み取り可能?}
    I -->|No| J[RuntimeException]
    I -->|Yes| F
    F --> K{パース成功?}
    K -->|Yes| L[valid: true記録]
    K -->|No| M[エラー情報記録]
    L --> H
    M --> H
    H -->|ループ終了| N{出力フォーマット}
    N -->|txt| O[テキスト形式出力]
    N -->|json| P[JSON形式出力]
    N -->|github| Q[GitHub Annotations出力]
    O --> R{エラーあり?}
    P --> R
    Q --> R
    R -->|No| S[成功メッセージ]
    R -->|Yes| T[警告メッセージ]
    S --> U[終了コード 0]
    T --> V[終了コード 1]
    U --> W[バッチ終了]
    V --> W
    E --> W
    J --> W
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはファイルの読み取りとYAMLパースのみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パースエラー | YAMLファイルに構文エラーがある | エラーメッセージの行番号を参照してYAMLファイルを修正 |
| RuntimeException | 入力なし | ファイル名もSTDIN入力も提供されない | ファイル名を引数に指定するかSTDINから入力 |
| RuntimeException | 読み取り不可 | ファイル/ディレクトリが読み取り不可 | パーミッションを確認 |
| InvalidArgumentException | 不正フォーマット | サポートされていない出力フォーマット | txt, json, githubのいずれかを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

パースエラーはYAMLファイルの構文修正で対応する。エラーメッセージにはパース失敗の行番号が含まれるため、問題箇所の特定が容易である。カスタムタグに起因するエラーの場合は`--parse-tags`オプションの使用が推奨される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | YAMLファイル数（数十〜数百ファイル） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 各ファイル検証後 | OK またはエラー詳細（行番号、メッセージ） |
| 終了ログ | バッチ終了時 | 全ファイルの検証結果サマリー |
| 提案ログ | カスタムタグエラー時 | --parse-tagsオプションの使用提案 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI/CDパイプライン終了コード | 0以外 | CI/CD通知先 |

## 備考

- 基盤実装は`src/Symfony/Component/Yaml/Command/LintCommand.php`に配置されている
- `Yaml::PARSE_CONSTANT`フラグが常に適用され、PHPの定数がYAML内で使用可能
- `--parse-tags`オプションを使用すると`Yaml::PARSE_CUSTOM_TAGS`フラグが追加され、カスタムタグ（`!tagged`等）がエラーにならない
- `--no-parse-tags`でカスタムタグパースを明示的に無効化可能（negatable option）
- E_USER_DEPRECATED警告はParseExceptionに変換されてエラーとして報告される
- `--exclude`オプションでファイルパスを指定して特定ファイルを除外可能（複数指定可）
- GitHub Actions環境では自動的にgithubフォーマットが選択される
- ディレクトリイテレータとis_readableのカスタムプロバイダーをコンストラクタで注入可能
