# バッチ設計書 28-about

## 概要

本ドキュメントは、Symfonyフレームワークの`about`コンソールコマンドのバッチ設計書である。このコマンドは、現在のSymfonyプロジェクトに関するシステム情報（Symfonyバージョン、カーネル設定、PHP環境）をテーブル形式で表示する情報表示ユーティリティである。

### 本バッチの処理概要

`about`コマンドは、現在実行中のSymfonyプロジェクトの環境情報を収集し、Symfony情報、カーネル設定、PHP環境の3セクションに分けてテーブル形式で出力するコマンドである。

**業務上の目的・背景**：Symfonyアプリケーションの運用・保守において、現在のフレームワークバージョン、PHP環境設定、キャッシュ・ログディレクトリのサイズなどのシステム情報を素早く確認する必要がある。特に、サポート期限の確認やデバッグ時の環境情報収集に有用である。本コマンドは、これらの情報を一元的に表示することで、運用担当者や開発者がプロジェクトの状態を即座に把握できるようにする。

**バッチの実行タイミング**：開発者や運用担当者が任意のタイミングで手動実行する。トラブルシューティング時やバージョン確認時に使用される。

**主要な処理内容**：
1. Symfonyフレームワーク情報（バージョン、LTSステータス、メンテナンス終了日、EOL）を収集する
2. カーネル情報（クラス名、環境、デバッグモード、文字セット、各種ディレクトリとサイズ）を収集する
3. PHP環境情報（バージョン、アーキテクチャ、Intlロケール、タイムゾーン、OPcache/APCu/Xdebugステータス）を収集する
4. 全情報をSymfonyStyleのテーブル形式で出力する

**前後の処理との関連**：独立したユーティリティコマンドであり、他のコマンドとの直接的な依存関係はない。トラブルシューティング時に`debug:container`（No.16）や`debug:router`（No.19）と併用されることがある。

**影響範囲**：読み取り専用の操作であり、アプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

情報表示 / システム診断

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（開発者/運用担当者による任意実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Symfonyアプリケーションが構成済み | カーネルが初期化可能であること |

### 実行可否判定

特別な実行条件はなし。Symfonyアプリケーションとして正常に起動できれば実行可能。

## 入力仕様

### 入力パラメータ

入力パラメータなし。本コマンドは引数やオプションを持たない。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Kernel | KernelInterface | カーネルの環境情報、ディレクトリパス等 |
| Kernel定数 | PHP定数 | VERSION, MINOR_VERSION, END_OF_MAINTENANCE, END_OF_LIFE |
| PHP環境 | PHP関数/定数 | PHP_VERSION, PHP_INT_SIZE, ini_get, extension_loaded等 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テーブル | Symfony/Kernel/PHP環境情報 |

### 出力ファイル仕様

ファイル出力なし。コンソールへの出力のみ。

## 処理フロー

### 処理シーケンス

```
1. カーネル情報取得
   └─ KernelInterfaceからプロジェクト情報を取得
2. Symfonyセクション出力
   └─ バージョン、LTSステータス、メンテナンス終了日、EOL
   └─ 日付の期限切れチェックと残日数計算
3. Kernelセクション出力
   └─ クラス名、環境、デバッグモード、文字セット
   └─ キャッシュ/ビルド/シェア/ログディレクトリとサイズ
4. PHPセクション出力
   └─ バージョン、アーキテクチャ（ビット数）
   └─ Intlロケール、タイムゾーン
   └─ OPcache、APCu、Xdebugのステータス
5. テーブル表示
   └─ 全情報をSymfonyStyleテーブルとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[カーネル情報取得]
    B --> C[Symfonyバージョン情報収集]
    C --> D[LTSステータス判定]
    D --> E[メンテナンス/EOL日付計算]
    E --> F[Kernel環境情報収集]
    F --> G[ディレクトリサイズ計算]
    G --> H[PHP環境情報収集]
    H --> I[拡張機能ステータス確認]
    I --> J[テーブル出力]
    J --> K[終了コード 0]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドは環境情報の読み取りのみを行う。

## エラー処理

### エラーケース一覧

本コマンドは通常エラーを発生させない。常に終了コード0を返す。

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

特に対応不要。カーネルの初期化に失敗する場合は、Symfonyアプリケーションの設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 固定（環境情報の収集） |
| 目標処理時間 | 1秒以内（ディレクトリサイズ計算除く） |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | バッチ終了時 | Symfony/Kernel/PHP環境情報テーブル |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

## 備考

- Symfonyの`END_OF_MAINTENANCE`と`END_OF_LIFE`の日付を解析し、期限切れかどうかと残日数を表示する
- `MINOR_VERSION`が4の場合にLTS（Long-Term Support）リリースとして表示される
- ディレクトリサイズ計算はRecursiveDirectoryIteratorで再帰的にファイルサイズを合算して算出される
- キャッシュ、ビルド、シェア、ログの4つのディレクトリ情報を表示する（シェアディレクトリはnullの場合"none"と表示）
- PHP拡張機能（OPcache, APCu, Xdebug）の有効/無効/未インストール状態を表示する
- Xdebugのモード設定（`XDEBUG_MODE`環境変数または`xdebug.mode`設定）も表示する
- パスはプロジェクトディレクトリからの相対パスで表示される
