# バッチ設計書 29-debug:firewall

## 概要

本ドキュメントは、Symfonyフレームワークの`debug:firewall`コンソールコマンドのバッチ設計書である。このコマンドは、SecurityBundleで設定されたセキュリティファイアウォールの情報を表示するデバッグユーティリティである。

### 本バッチの処理概要

`debug:firewall`コマンドは、Symfonyアプリケーションに設定されたセキュリティファイアウォールの一覧表示、および個別ファイアウォールの詳細情報（設定、ユーザースイッチング、イベントリスナー、認証器）を表示するデバッグコマンドである。

**業務上の目的・背景**：Symfonyのセキュリティシステムは複数のファイアウォールを持つことができ、各ファイアウォールには認証方法、ユーザープロバイダー、アクセス制御などの設定が含まれる。これらの設定は複雑になりがちで、期待通りのセキュリティ動作が行われているかを確認する必要がある。本コマンドは、ファイアウォールの設定内容を可視化し、セキュリティ設定の問題を特定・デバッグする手段を提供する。

**バッチの実行タイミング**：セキュリティ設定の変更後やセキュリティ問題のデバッグ時に開発者が手動で実行する。

**主要な処理内容**：
1. 引数なしの場合、設定済みファイアウォール名の一覧を表示する
2. ファイアウォール名が指定された場合、FirewallContextから詳細情報を取得する
3. ファイアウォールサマリー（名前、コンテキスト、Lazy/Stateless設定、プロバイダー等）を表示する
4. ユーザースイッチング設定が存在する場合はその詳細を表示する
5. `--events`オプション指定時、ファイアウォール固有のイベントリスナーを表示する
6. ファイアウォールに登録された認証器（Authenticator）の一覧を表示する

**前後の処理との関連**：`debug:event-dispatcher`（No.18）がアプリケーション全体のイベントリスナーを表示するのに対し、本コマンドはファイアウォール固有のイベントディスパッチャーのリスナーを表示する。`debug:security:role-hierarchy`（No.30）と併用してセキュリティ設定全体を確認する。

**影響範囲**：読み取り専用の操作であり、セキュリティ設定やアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

デバッグ / セキュリティ診断

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（開発者による任意実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SecurityBundleが有効 | セキュリティバンドルが登録・設定されていること |
| ファイアウォールが設定済み | 少なくとも1つのファイアウォールが定義されていること |

### 実行可否判定

指定されたファイアウォール名が存在しない場合はエラーメッセージと利用可能なファイアウォール名を表示して終了コード1を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | null | ファイアウォール名 |
| --events | bool | No | false | イベントリスナーのリストを含める |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| FirewallContext | サービスコンテナ | ファイアウォール設定情報 |
| EventDispatcherInterface | サービスコンテナ | ファイアウォール固有のイベントディスパッチャー |
| AuthenticatorInterface[] | 配列 | ファイアウォールに登録された認証器 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テーブル/リスト | ファイアウォール情報（一覧または詳細） |

### 出力ファイル仕様

ファイル出力なし。コンソールへの出力のみ。

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ取得
   └─ name引数、eventsオプションを取得
2. モード判定
   └─ name未指定: ファイアウォール一覧表示モード
   └─ name指定: ファイアウォール詳細表示モード
3. 一覧表示モード
   └─ 全ファイアウォール名をリスト形式で表示
4. 詳細表示モード
   a. ファイアウォール存在確認
      └─ 指定名のFirewallContextが存在するか確認
   b. サマリー表示
      └─ Name, Context, Lazy, Stateless, UserChecker, Provider, EntryPoint, AccessDeniedURL/Handler
   c. ユーザースイッチング表示
      └─ SwitchUser設定がある場合、Parameter/Provider/UserRoleを表示
   d. イベントリスナー表示（--events時）
      └─ ファイアウォール固有EventDispatcherのリスナーをイベント別に表示
   e. 認証器一覧表示
      └─ ファイアウォールに登録されたAuthenticatorのクラス名を表示
5. 終了コード返却
   └─ 正常: 0、ファイアウォール未発見: 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{name引数あり?}
    B -->|No| C[ファイアウォール一覧表示]
    C --> D[終了コード 0]
    B -->|Yes| E{ファイアウォール存在?}
    E -->|No| F[エラーメッセージ表示]
    F --> G[終了コード 1]
    E -->|Yes| H[FirewallContext取得]
    H --> I[サマリーテーブル表示]
    I --> J[ユーザースイッチング表示]
    J --> K{--events指定?}
    K -->|Yes| L[イベントリスナー表示]
    K -->|No| M[認証器一覧表示]
    L --> M
    M --> D
    D --> N[バッチ終了]
    G --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはセキュリティ設定のインメモリ情報のみを読み取る。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ファイアウォール未発見 | 指定されたファイアウォール名が存在しない | 利用可能なファイアウォール名を確認して再指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

デバッグ用ユーティリティのため、リカバリ手順は不要。ファイアウォール名が見つからない場合は、引数なしで実行して利用可能なファイアウォール名を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイアウォール数（通常1〜数個） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 一覧表示時 | ファイアウォール名リスト |
| 結果ログ | 詳細表示時 | ファイアウォール設定情報テーブル |
| エラーログ | ファイアウォール未発見時 | エラーメッセージと利用可能なファイアウォール名 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

開発時デバッグ用コマンドのため、監視・アラートは不要。

## 備考

- `final`クラスとして宣言されており、継承不可
- `FirewallContext`がnullのconfigを持つ場合、サマリー表示はスキップされる
- `LazyFirewallContext`のインスタンスかどうかでLazy設定の判定を行う
- `TraceableAuthenticator`でラップされている場合は内部のAuthenticatorクラス名を表示する
- `--events`オプションは`name`引数と組み合わせてのみ有効
- イベントリスナーのCallable表示はクロージャ、メソッド参照、__invoke等に対応
- オートコンプリート機能によりファイアウォール名の補完が可能
