# バッチ設計書 3-cache:pool:clear

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:pool:clear` コンソールコマンドのバッチ設計書である。指定されたキャッシュプールまたはキャッシュプールクリアラーのキャッシュをクリアする処理の仕様を定義する。

### 本バッチの処理概要

`cache:pool:clear` コマンドは、PSR-6準拠のキャッシュプールを個別または一括でクリアする機能を提供する。`cache:clear` がアプリケーション全体のキャッシュを対象とするのに対し、本コマンドは特定のキャッシュプールを選択的にクリアできる。

**業務上の目的・背景**：アプリケーション全体のキャッシュクリアはオーバーヘッドが大きいため、特定のキャッシュプールのみをクリアしたい場合に使用する。例えば、特定のAPIレスポンスキャッシュのみをクリアしたい場合や、セッションキャッシュのみをリセットしたい場合に有用である。運用中のアプリケーションへの影響を最小限に抑えながら、必要なキャッシュのみをリフレッシュすることが可能となる。

**バッチの実行タイミング**：特定のキャッシュプールに関連するデータが更新された場合、運用メンテナンス時、障害対応時など随時実行される。`--all` オプションを使用することで全プールを一括クリアすることも可能。

**主要な処理内容**：
1. 引数または `--all` オプションからクリア対象のプール名リストを取得
2. `--exclude` オプションで除外するプールをフィルタリング
3. 各プール名について、Psr6CacheClearerに登録されたプールか、DIコンテナのサービスかを判定
4. CacheItemPoolInterfaceのプールは `clear()` メソッドでクリア
5. Psr6CacheClearerのプールは `clearPool()` メソッドでクリア
6. Psr6CacheClearer型のサービスは `clear()` メソッドでキャッシュディレクトリ全体をクリア

**前後の処理との関連**：`cache:pool:list` コマンドで利用可能なプール名を確認した上で実行されることが多い。`cache:clear` コマンドとは独立して動作するが、両方実行すると重複クリアとなる。

**影響範囲**：指定されたキャッシュプールに格納されたデータのみが影響を受ける。アプリケーション全体のキャッシュではなく、選択したプールに限定される。

## バッチ種別

キャッシュ管理 / メンテナンスコマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プール名の指定 | 少なくとも1つのプール名を引数で指定するか、`--all` オプションを指定する必要がある |
| プールの存在 | 指定されたプール名がPsr6CacheClearerに登録されているか、DIコンテナに存在する必要がある |

### 実行可否判定

引数にプール名が指定されておらず `--all` オプションも未指定の場合、`InvalidArgumentException` をスローして処理を中断する。`--all` 指定時にプール名リストが空（nullまたは空配列）の場合も同様にエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| pools | string[] | No（--allと排他） | なし | クリア対象のキャッシュプール名またはクリアラー名のリスト |
| --all | bool | No | false | 全キャッシュプールをクリアする |
| --exclude | string[] | No | [] | クリアから除外するプール名またはクリアラー名のリスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Psr6CacheClearer | サービス | 登録済みキャッシュプールの管理サービス |
| DIコンテナ | サービス | CacheItemPoolInterfaceまたはPsr6CacheClearer型のサービス |
| poolNames | 配列 | コンストラクタで注入される利用可能プール名リスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | 各プールのクリア進捗メッセージおよび成功/警告メッセージ |

### 出力ファイル仕様

該当なし（ファイル出力はない。キャッシュストレージ内のデータが削除される）

## 処理フロー

### 処理シーケンス

```
1. 引数・オプション解析
   └─ pools引数、--allオプション、--excludeオプションを取得
2. プール名リスト構築
   └─ --all指定時は全プール名を使用し、excludeで除外
3. プール分類
   └─ 各プール名をCacheItemPoolInterface、Psr6CacheClearer、Psr6CacheClearer登録プールに分類
4. クリアラー実行
   └─ Psr6CacheClearer型のサービスに対してclear()を実行
5. プールクリア実行
   └─ 各プールに対してclear()またはclearPool()を実行
6. 結果出力
   └─ 成功メッセージまたは警告メッセージを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{--all指定?}
    B -->|Yes| C[全プール名を取得]
    B -->|No| D{pools引数あり?}
    D -->|No| E[InvalidArgumentException]
    D -->|Yes| F[指定プール名を取得]
    C --> G[--excludeでフィルタリング]
    F --> G
    G --> H[各プールを分類]
    H --> I[クリアラー型サービスのclear実行]
    I --> J[各プールのclear/clearPool実行]
    J --> K{全プール成功?}
    K -->|Yes| L[成功メッセージ出力]
    K -->|No| M[警告メッセージ出力・終了コード1]
    L --> N[バッチ終了 コード0]
    M --> O[バッチ終了 コード1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースに対する直接的な操作を行わない。ただし、キャッシュバックエンドとしてデータベースが使用されている場合は、対応するテーブルのレコードが削除される可能性がある。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | キャッシュバックエンド依存 |

### テーブル別操作詳細

該当なし（キャッシュバックエンドの実装に依存）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgumentException | 引数エラー | プール名未指定かつ--allも未指定 | 少なくとも1つのプール名を指定するか--allを使用する |
| InvalidArgumentException | 引数エラー | --all指定時にプール名リストが取得不可 | プール名の設定を確認する |
| InvalidArgumentException | 型エラー | 指定サービスがCacheItemPoolInterfaceでもPsr6CacheClearerでもない | 正しいプール名を指定する |
| 終了コード1 | クリア失敗 | プールのclear()がfalseを返した | プールの実装・設定を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 特定のプールのクリアに失敗した場合、警告メッセージが出力されるが処理は継続される。
2. 全プールの処理が完了した後、1つ以上のプールが失敗していた場合は終了コード1が返される。
3. プール名が不正な場合は `InvalidArgumentException` がスローされ、処理が中断される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各プール単位で独立 |
| コミットタイミング | 各プールのclear()完了時 |
| ロールバック条件 | 該当なし（各プールは独立して処理される） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 指定されたプール数に依存 |
| 目標処理時間 | プール数とキャッシュサイズに依存 |
| メモリ使用量上限 | 通常低い（プールのclear()呼び出しのみ） |

## 排他制御

各プールのclear()メソッドの排他制御は、キャッシュアダプターの実装に依存する。コマンド自体には排他制御機構はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | --all指定時 | `Clearing all cache pools...` |
| 進捗ログ | クリアラー実行時 | `Calling cache clearer: {id}` |
| 進捗ログ | プールクリア時 | `Clearing cache pool: {id}` |
| 警告ログ | クリア失敗時 | `Cache pool "{pool}" could not be cleared.` |
| 終了ログ | 全成功時 | `Cache was successfully cleared.` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 運用監視システム |

## 備考

- シェル補完機能をサポートしており、プール名の入力時に候補が表示される。
- `--all` と `--exclude` を組み合わせることで、特定のプールを除いた全プールクリアが可能。
- プール名はコンストラクタで注入される `$poolNames` 配列から取得される。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolClearCommand.php`
