# バッチ設計書 30-debug:security:role-hierarchy

## 概要

本ドキュメントは、Symfonyフレームワークの`debug:security:role-hierarchy`コンソールコマンドのバッチ設計書である。このコマンドは、セキュリティ設定で定義されたロール階層をMermaidフローチャート形式でダンプし、ロール間の継承関係を視覚的に確認できるようにする。

### 本バッチの処理概要

`debug:security:role-hierarchy`コマンドは、Symfonyアプリケーションのセキュリティ設定に定義されたロール階層（role_hierarchy）をMermaidフローチャート構文で出力するデバッグコマンドである。出力はMermaidレンダラーで視覚化可能なテキスト形式である。

**業務上の目的・背景**：Symfonyのセキュリティシステムではロール階層（role_hierarchy）を設定でき、あるロールが別のロールを含む（継承する）関係を定義できる。複雑なロール階層は設定ファイルだけでは全体像を把握しにくい。本コマンドは、ロール階層をMermaidフローチャート形式で出力することで、ロール間の関係をグラフとして視覚化し、セキュリティ設計の確認やドキュメント作成に活用できるようにする。

**バッチの実行タイミング**：セキュリティ設定の変更後、ロール設計の確認時、ドキュメント作成時に開発者が手動で実行する。

**主要な処理内容**：
1. `--direction`オプションからフローチャートの方向を決定する
2. `RoleHierarchyInterface`からロール階層情報を取得する
3. `MermaidDumper`を使用してMermaidフローチャート構文を生成する
4. 生成されたMermaid構文を標準出力にRAW出力する

**前後の処理との関連**：`debug:firewall`（No.29）と併用してセキュリティ設定全体の確認に使用される。ロール階層はファイアウォールのアクセス制御と連携して動作する。

**影響範囲**：読み取り専用の操作であり、セキュリティ設定やアプリケーション状態に影響を与えない。コンソール出力のみを行う。

## バッチ種別

デバッグ / セキュリティ設定可視化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（開発者による任意実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SecurityBundleが有効 | セキュリティバンドルが登録・設定されていること |
| RoleHierarchyInterfaceが利用可能 | ロール階層サービスがDIコンテナに登録されていること |

### 実行可否判定

不正な方向（direction）値が指定された場合はエラーメッセージを表示して終了コード1（FAILURE）を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --direction (-d) | string | No | TB（Top to Bottom） | フローチャートの方向（TB, BT, LR, RL） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| RoleHierarchyInterface | サービス | ロール階層定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | Mermaidフローチャート構文（RAW出力） | ロール階層のグラフ表現 |

### 出力ファイル仕様

ファイル出力なし。コンソールへのRAW出力のみ。リダイレクト（`> roles.mmd`）でファイルに保存可能。

| 項目 | 内容 |
|-----|------|
| ファイル名 | リダイレクト先による（例: roles.mmd） |
| 出力先 | 標準出力（リダイレクトで任意のパスに保存可能） |
| 文字コード | UTF-8 |
| フォーマット | Mermaid flowchart構文 |

## 処理フロー

### 処理シーケンス

```
1. 方向パラメータ取得
   └─ --directionオプションからMermaidDirection enumを解決
2. 方向バリデーション
   └─ MermaidDirection::tryFromで有効な方向か検証
   └─ 無効な場合はエラーメッセージを表示して終了
3. MermaidDumper生成
   └─ MermaidDumperインスタンスを作成
4. ロール階層ダンプ
   └─ dump()メソッドでRoleHierarchyInterfaceからMermaid構文を生成
5. 出力
   └─ 行ごとにRAW出力モードで標準出力に書き出し
6. 終了コード返却
   └─ 成功: 0（SUCCESS）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[方向パラメータ取得]
    B --> C{方向が有効?}
    C -->|No| D[エラーメッセージ表示]
    D --> E[終了コード FAILURE]
    C -->|Yes| F[MermaidDumper生成]
    F --> G[ロール階層ダンプ実行]
    G --> H[行ごとにRAW出力]
    H --> I[終了コード SUCCESS]
    I --> J[バッチ終了]
    E --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはメモリ内のロール階層設定のみを読み取る。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FAILURE(1) | 不正方向 | サポートされていない方向値が指定された | TB, BT, LR, RLのいずれかを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

デバッグ用ユーティリティのため、リカバリ手順は不要。不正な方向値の場合はエラーメッセージに従って有効な値を指定する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ロール階層のエントリ数（通常数個〜数十個） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 標準的なCLIメモリ制限内 |

## 排他制御

排他制御なし。読み取り専用操作であり、同時実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | バッチ終了時 | Mermaidフローチャート構文 |
| エラーログ | 不正方向指定時 | 不正な方向値と利用可能なオプションのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

開発時デバッグ用コマンドのため、監視・アラートは不要。

## 備考

- `MermaidDirection` enumの有効値: TB（Top to Bottom）、BT（Bottom to Top）、LR（Left to Right）、RL（Right to Left）
- 出力は`OutputInterface::OUTPUT_RAW`モードで行われ、Symfonyのフォーマットタグが適用されない
- `MermaidDumper`クラスは`Symfony\Component\Security\Core\Dumper`名前空間に配置されている
- 出力はファイルにリダイレクト（`> roles.mmd`）して保存し、Mermaidレンダラーで視覚化することが推奨される
- `-d`ショートオプションで方向を簡潔に指定可能
- `RoleHierarchyInterface`はコンストラクタでreadonly依存として注入される
