# バッチ設計書 31-lint:twig

## 概要

本ドキュメントは、Symfony TwigBundleが提供する `lint:twig` コマンドのバッチ設計書である。Twigテンプレートファイルの構文検証を行い、エラーや非推奨項目を報告するリントコマンドの仕様を定義する。

### 本バッチの処理概要

`lint:twig` コマンドは、Twigテンプレートファイルの構文を検証し、テンプレート内の構文エラーや非推奨機能の使用を検出・報告するCLIコマンドである。

**業務上の目的・背景**：Twigテンプレートはアプリケーションのビュー層を構成する重要なファイルであり、構文エラーがあるとランタイムでレンダリングに失敗する。デプロイ前やCI/CDパイプラインの中でテンプレートの構文を事前検証することで、本番環境での障害を防止する。また、非推奨機能の使用を検出することで、将来のバージョンアップに備えたコード品質の維持に貢献する。

**バッチの実行タイミング**：随時実行（手動）。一般的にはCI/CDパイプラインの一部として、コミット時やプルリクエスト作成時に自動実行される。また、開発者がローカル環境で手動実行することもある。

**主要な処理内容**：
1. 入力引数（ファイルパス、ディレクトリパス、またはSTDIN）からリント対象を決定
2. Twigテンプレートファイルの探索（Finder使用、除外パターン適用）
3. 各テンプレートのトークン化・パース・コンパイルによる構文検証
4. 非推奨機能の検出（`--show-deprecations`オプション有効時）
5. 検証結果をテキスト、JSON、またはGitHub Actions形式で出力

**前後の処理との関連**：独立したリントコマンドであり、他のバッチとの直接的な依存関係はない。CI/CDパイプラインでは `lint:yaml`、`lint:xliff`、`lint:container` 等の他のリントコマンドと並列実行されることが多い。

**影響範囲**：読み取り専用の検証処理であり、テンプレートファイルやシステム状態を変更しない。出力は標準出力（STDOUT）またはエラー出力（STDERR）に対して行われる。

## バッチ種別

リント検証（テンプレート構文チェック）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Twig環境 | Twig Environmentが正しく設定されていること |
| テンプレートファイル | リント対象のTwigテンプレートファイルが存在すること（ファイル指定時） |
| FilesystemLoader | ファイル名未指定時、FilesystemLoaderが設定されている必要がある |

### 実行可否判定

ファイル名引数が指定されている場合は即座に実行する。ファイル名未指定の場合、TwigのFilesystemLoaderから登録済みパスを取得し、対象ファイルが存在する場合にのみ実行する。対象が見つからない場合はRuntimeExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| filename | string[] | No | なし（FilesystemLoaderから自動取得） | リント対象のファイルパスまたはディレクトリパス。`-`でSTDINから読み取り |
| --format | string | No | txt（GitHub Actions環境では`github`） | 出力フォーマット。txt / json / github |
| --show-deprecations | bool | No | false | 非推奨機能をエラーとして表示する |
| --excludes | string[] | No | [] | 除外するディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Twigテンプレートファイル | .twig ファイル | リント対象となるTwigテンプレートファイル |
| STDIN | テキスト | `-` 引数指定時の標準入力からのテンプレート内容 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | txt / json / github | リント結果（正常時はサクセスメッセージ、エラー時はエラー詳細） |
| STDERR | テキスト | エラー情報・警告情報 |

### 出力ファイル仕様

ファイル出力は行わない。全ての結果は標準出力に出力される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ Twig Environment・オプション・引数の取得
2. 出力フォーマット決定
   └─ --format指定値、またはGitHub Actions環境検出による自動設定
3. リント対象ファイル決定
   ├─ STDIN指定（`-`）の場合: php://stdinからテンプレート内容を読み取り
   ├─ ファイル/ディレクトリ指定の場合: Finderで*.twigファイルを探索
   └─ 未指定の場合: FilesystemLoaderの登録パスからファイルを探索
4. テンプレート検証（各ファイルに対して）
   ├─ ArrayLoaderで一時的にテンプレートを設定
   ├─ tokenize() → parse() → compile() の順で構文検証
   ├─ 非推奨検出（--show-deprecations有効時）
   └─ エラー発生時はError例外をキャッチして結果に記録
5. 結果出力
   ├─ txt形式: SymfonyStyle経由でテキスト出力
   ├─ json形式: JSON形式で出力
   └─ github形式: GitHub Actionsアノテーション付きテキスト出力
6. 終了コード返却
   └─ エラー・非推奨なし: 0、エラーまたは非推奨あり: 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{入力ソース判定}
    B -->|STDIN| C[STDINからテンプレート読み取り]
    B -->|ファイル/ディレクトリ指定| D[Finderでファイル探索]
    B -->|未指定| E[FilesystemLoaderからパス取得]
    C --> F[テンプレート検証]
    D --> F
    E --> F
    F --> G[tokenize - parse - compile]
    G --> H{構文エラー?}
    H -->|あり| I[エラー情報記録]
    H -->|なし| J[正常結果記録]
    I --> K{全ファイル処理完了?}
    J --> K
    K -->|未完了| F
    K -->|完了| L[フォーマットに応じた結果出力]
    L --> M[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはファイルシステム上のテンプレートファイルの読み取り・検証のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | ファイル未指定かつFilesystemLoaderが未設定 | テンプレートファイルのパスを引数で指定する |
| - | RuntimeException | 指定ファイル・ディレクトリが読み取り不可 | ファイルパスを確認する |
| - | InvalidArgumentException | 不正な出力フォーマット指定 | txt / json / github のいずれかを指定する |
| - | Twig\Error\Error | テンプレート構文エラー | テンプレートを修正する（エラー内容を参照） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（リトライ不要の読み取り専用処理） |

### 障害時対応

構文エラー検出はコマンドの正常動作であり、エラーがあるテンプレートの情報が出力される。コマンド自体の障害（RuntimeExceptionなど）の場合は、引数・設定を確認して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト内のTwigテンプレート数に依存（数十〜数千ファイル） |
| 目標処理時間 | テンプレート数に依存（1ファイルあたり数ミリ秒） |
| メモリ使用量上限 | 特に制限なし（大量ファイル時はPHPメモリ制限に依存） |

## 排他制御

排他制御なし。読み取り専用の処理であり、同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ファイル検証完了時（-v指定時） | 「OK in {ファイル名}」 |
| エラーログ | 構文エラー検出時 | エラー箇所（ファイル名、行番号）とエラーメッセージ |
| 非推奨ログ | 非推奨検出時（--show-deprecations指定時） | 非推奨メッセージとファイル名・行番号 |
| 終了ログ | 処理完了時 | 検証結果サマリー（正常ファイル数/エラーファイル数） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |

## 備考

- 基盤実装は `src/Symfony/Bridge/Twig/Command/LintCommand.php` に存在する
- TwigBundle経由で `lint:twig` としてSymfonyアプリケーションに登録される
- GitHub Actions環境（`GITHUB_ACTIONS` 環境変数が設定されている場合）では、自動的に `github` フォーマットが選択され、アノテーション形式でエラーが報告される
- `GithubActionReporter` を使用してGitHub Actionsのエラーアノテーションを出力可能
