# バッチ設計書 32-server:dump

## 概要

本ドキュメントは、Symfony DebugBundleが提供する `server:dump` コマンドのバッチ設計書である。VarDumperコンポーネントのダンプサーバーを起動し、アプリケーションから送信されるダンプデータを一元的に収集・表示する常駐型サーバーコマンドの仕様を定義する。

### 本バッチの処理概要

`server:dump` コマンドは、Symfony VarDumperコンポーネントのダンプサーバーを起動し、アプリケーション内で `dump()` 関数を通じて送信されるデバッグデータを収集・表示するコマンドである。

**業務上の目的・背景**：開発中のアプリケーションにおいて、`dump()` 関数の出力はデフォルトでHTTPレスポンスに埋め込まれるが、APIレスポンスやコンソールコマンド、非同期処理などHTTPレスポンスが利用できないコンテキストではダンプ出力の確認が困難である。`server:dump` はダンプデータを専用サーバーに集約し、一箇所で確認可能にすることで開発効率を向上させる。また、本番レスポンスへのダンプ出力混入を防ぐ効果もある。

**バッチの実行タイミング**：開発時に随時実行（手動）。開発者がデバッグを行う際にバックグラウンドプロセスとして起動し、開発セッション中は常駐する。

**主要な処理内容**：
1. コマンドオプションから出力フォーマット（cli / html）を決定
2. DumpServerを起動し、指定ホスト・ポートでリスニングを開始
3. アプリケーションから送信されるダンプデータを受信
4. 受信データを指定フォーマットのDescriptorで整形して出力

**前後の処理との関連**：独立した開発支援ツールであり、他のバッチとの依存関係はない。アプリケーション側でVarDumperのダンプクライアントが設定されている必要がある。

**影響範囲**：開発環境限定のデバッグツールであり、アプリケーションのデータやシステム状態を変更しない。ネットワークソケットを使用してダンプデータを受信する。

## バッチ種別

開発支援（デバッグサーバー / 常駐型プロセス）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| DumpServer | DumpServerインスタンスが正しく設定されていること |
| ポート空き | リスニングポートが使用可能であること |
| 開発環境 | 開発環境での使用を想定 |

### 実行可否判定

DumpServerインスタンスと出力フォーマットに対応するDescriptorが存在すれば実行可能。不正なフォーマット指定時はInvalidArgumentExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --format | string | No | cli | 出力フォーマット。cli / html |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ネットワークソケット | TCP | アプリケーションから送信されるダンプデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | cli / html | 受信したダンプデータの整形出力 |
| STDERR | テキスト | サーバー起動メッセージ・ステータス情報 |

### 出力ファイル仕様

html形式の場合、標準出力をファイルにリダイレクトしてブラウザで閲覧可能。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力、リダイレクトで任意のファイルに出力可能） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ 出力フォーマットオプションの取得
2. Descriptor選択
   └─ cli形式: CliDescriptor、html形式: HtmlDescriptor
3. DumpServer起動
   └─ server->start() でリスニング開始
4. 起動メッセージ出力
   └─ "Server listening on {host}" をSTDERRに表示
5. ダンプデータ受信ループ
   ├─ server->listen() でコールバック登録
   ├─ ダンプデータ (Data) 受信
   └─ Descriptorで整形して出力
6. 終了（CONTROL-Cで手動停止）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[フォーマットオプション取得]
    B --> C{Descriptor存在?}
    C -->|なし| D[InvalidArgumentException]
    C -->|あり| E[DumpServer起動]
    E --> F[起動メッセージ出力]
    F --> G[ダンプデータ受信待機]
    G --> H[データ受信]
    H --> I[Descriptorで整形出力]
    I --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはネットワーク経由でダンプデータを受信・表示するのみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | 不正な出力フォーマット指定 | cli / html のいずれかを指定する |
| - | ソケットエラー | ポートが使用中 | 他のプロセスを停止するか別のポートを使用する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

サーバーが起動できない場合は、ポートの使用状況を確認する。プロセスが予期せず終了した場合は再起動する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 開発時のダンプ呼び出し回数に依存 |
| 目標処理時間 | リアルタイム（受信即表示） |
| メモリ使用量上限 | 特に制限なし（長時間稼働時はPHPメモリ制限に依存） |

## 排他制御

同一ポートでの複数起動は不可（ソケットバインドによる自然な排他制御）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サーバー起動時 | 「Symfony Var Dumper Server」タイトルと「Server listening on {host}」 |
| 進捗ログ | ダンプデータ受信時 | ダンプデータの整形出力（変数内容・コンテキスト情報） |
| 終了ログ | なし | CONTROL-Cで強制終了のため終了ログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

開発支援ツールのため、監視・アラートは不要。

## 備考

- 基盤実装は `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` に存在する
- DebugBundle経由で `server:dump` としてSymfonyアプリケーションに登録される
- デフォルトのDescriptorはcli（CliDescriptor）とhtml（HtmlDescriptor）の2種類
- html形式は `php bin/console server:dump --format=html > dump.html` のようにリダイレクトしてブラウザで閲覧可能
- 常駐型のサーバープロセスであり、CONTROL-Cで手動停止する
