# バッチ設計書 33-debug:twig

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供する `debug:twig` コマンドのバッチ設計書である。Twig環境に登録されている関数、フィルタ、グローバル変数、テストの一覧を表示し、テンプレートの解決パスを確認するデバッグコマンドの仕様を定義する。

### 本バッチの処理概要

`debug:twig` コマンドは、現在のTwig環境に登録されているすべての関数・フィルタ・グローバル変数・テストを一覧表示し、またテンプレート名を指定することでテンプレートファイルの解決パスを確認できるデバッグ支援コマンドである。

**業務上の目的・背景**：Twigテンプレートの開発において、利用可能な関数やフィルタの確認、テンプレートファイルがどのパスから読み込まれるかの確認は頻繁に必要となる。特にバンドルのテンプレートオーバーライド機能を使用する場合、どのファイルが優先されるかを把握することが重要である。本コマンドはTwig環境の内部状態を可視化し、開発・デバッグ効率を向上させる。

**バッチの実行タイミング**：随時実行（手動）。テンプレート開発中やデバッグ時に開発者が必要に応じて実行する。

**主要な処理内容**：
1. テンプレート名引数の有無によりモードを判定（一覧表示 / パス表示）
2. 一覧表示モード：Twigの関数・フィルタ・テスト・グローバル変数を列挙
3. パス表示モード：指定テンプレート名の解決パスとオーバーライドファイルを表示
4. バンドルテンプレートオーバーライドの不整合を検出・警告
5. テキストまたはJSON形式で結果を出力

**前後の処理との関連**：独立したデバッグコマンドであり、他のバッチとの直接的な依存関係はない。

**影響範囲**：読み取り専用のデバッグツールであり、テンプレートファイルやシステム状態を変更しない。

## バッチ種別

デバッグ支援（Twig環境情報表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Twig Environment | Twig Environmentが正しく設定されていること |
| FilesystemLoader | テンプレート名引数使用時、FilesystemLoaderが設定されている必要がある |

### 実行可否判定

Twig Environmentが利用可能であれば実行可能。テンプレート名引数を指定する場合はFilesystemLoaderが存在する必要があり、存在しない場合はInvalidArgumentExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | なし | テンプレート名（指定時はパス解決モード） |
| --filter | string | No | なし | 表示結果をフィルタリングする文字列 |
| --format | string | No | txt | 出力フォーマット。txt / json |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Twig Environment | オブジェクト | 登録済み関数・フィルタ・テスト・グローバル変数 |
| FilesystemLoader | オブジェクト | テンプレートパス情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | txt / json | Twig環境情報またはテンプレートパス情報 |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ Twig Environment・オプション・引数の取得
2. モード判定
   ├─ テンプレート名引数あり → パス表示モード
   └─ テンプレート名引数なし → 一覧表示モード
3a. 一覧表示モード
   ├─ 関数一覧取得・表示（メタデータ付き）
   ├─ フィルタ一覧取得・表示（メタデータ付き）
   ├─ テスト一覧取得・表示
   ├─ グローバル変数一覧取得・表示（値付き）
   ├─ ローダーパス一覧表示
   └─ バンドルオーバーライド不整合チェック・警告表示
3b. パス表示モード
   ├─ テンプレート名のパース（namespace/shortname分離）
   ├─ マッチしたファイルの表示
   ├─ オーバーライドファイルの表示
   └─ 設定済みパスの表示
4. フォーマットに応じた出力
   ├─ txt形式: SymfonyStyle経由でテキスト出力
   └─ json形式: JSON形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{テンプレート名引数?}
    B -->|あり| C[パス表示モード]
    B -->|なし| D[一覧表示モード]
    C --> E[テンプレート名パース]
    E --> F[マッチファイル検索]
    F --> G[パス情報出力]
    D --> H[関数一覧取得]
    H --> I[フィルタ一覧取得]
    I --> J[テスト一覧取得]
    J --> K[グローバル変数取得]
    K --> L[ローダーパス表示]
    L --> M[バンドルオーバーライドチェック]
    M --> N[結果出力]
    G --> N
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはTwig環境のメタデータ表示のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | テンプレート名引数使用時にFilesystemLoaderが未設定 | FilesystemLoaderを設定するか、引数なしで実行する |
| - | InvalidArgumentException | 不正なテンプレート名フォーマット（`@namespace/`で終わる等） | 正しいテンプレート名を指定する |
| - | InvalidArgumentException | 不正な出力フォーマット指定 | txt / json のいずれかを指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

デバッグコマンドであり、障害時は引数・設定を確認して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | Twig環境に登録された拡張機能数に依存 |
| 目標処理時間 | 即時（メモリ内のメタデータ取得のため） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御なし。読み取り専用の処理であり、同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 処理完了時 | 関数・フィルタ・テスト・グローバル変数一覧またはテンプレートパス情報 |
| 警告ログ | バンドルオーバーライド不整合検出時 | 不正なバンドルオーバーライドパスと候補の表示 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

デバッグ支援ツールのため、監視・アラートは不要。

## 備考

- 基盤実装は `src/Symfony/Bridge/Twig/Command/DebugCommand.php` に存在する
- TwigBundle経由で `debug:twig` としてSymfonyアプリケーションに登録される
- 関数・フィルタのメタデータにはPHPリフレクションを使用してパラメータ情報を取得する
- `--filter` オプションにより、名前に特定文字列を含む項目のみを表示可能
- バンドルテンプレートオーバーライドの不整合（存在しないバンドル名のディレクトリ）を検出して警告する
- テンプレートパス表示モードでは、Levenshtein距離を使用した類似名候補の提示機能がある
