# バッチ設計書 34-server:log

## 概要

本ドキュメントは、Symfony Monolog Bridgeが提供する `server:log` コマンドのバッチ設計書である。TCPソケットベースのログサーバーを起動し、アプリケーションから送信されるログメッセージをリアルタイムで受信・表示する常駐型サーバーコマンドの仕様を定義する。

### 本バッチの処理概要

`server:log` コマンドは、TCPソケットサーバーを起動してアプリケーションのログメッセージをリアルタイムで受信・表示するコマンドである。

**業務上の目的・背景**：アプリケーション開発中にログをリアルタイムで確認したい場面は多い。ログファイルを `tail -f` で監視する方法もあるが、`server:log` はネットワーク経由でログを収集するため、複数のアプリケーションインスタンスや非同期ワーカーからのログも一元的に確認できる。また、ExpressionLanguageによるフィルタリング機能により、特定のログレベルやチャネルのみを表示するなど、柔軟なログ監視が可能である。

**バッチの実行タイミング**：開発時に随時実行（手動）。開発者がログ監視を行う際にバックグラウンドプロセスとして起動し、開発セッション中は常駐する。

**主要な処理内容**：
1. ログサーバーの起動（TCPソケットバインド）
2. クライアント接続の受け入れ
3. ログメッセージの受信・デシリアライズ
4. ExpressionLanguageによるフィルタリング（オプション）
5. ConsoleFormatterで整形してコンソール出力

**前後の処理との関連**：独立した開発支援ツールであり、他のバッチとの依存関係はない。アプリケーション側でMonologのSocketHandlerまたは同等の送信設定が必要。

**影響範囲**：開発環境限定のデバッグツールであり、アプリケーションのデータやシステム状態を変更しない。ネットワークソケットを使用してログデータを受信する。

## バッチ種別

開発支援（ログサーバー / 常駐型プロセス）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ConsoleFormatter | Monolog Bridge の ConsoleFormatter クラスが利用可能であること |
| FormatterInterface | monolog/monolog の FormatterInterface が利用可能であること |
| ポート空き | リスニングポート（デフォルト: 9911）が使用可能であること |
| ExpressionLanguage | --filter オプション使用時は symfony/expression-language が必要 |

### 実行可否判定

`isEnabled()` メソッドにより、ConsoleFormatterクラスとFormatterInterfaceの存在を確認する。いずれかが存在しない場合、コマンドは無効化される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --host | string | No | 0.0.0.0:9911 | サーバーのホスト:ポート |
| --format | string | No | ConsoleFormatter::SIMPLE_FORMAT | ログ行のフォーマット文字列 |
| --date-format | string | No | ConsoleFormatter::SIMPLE_DATE | 日付のフォーマット文字列 |
| --filter | string | No | なし | ExpressionLanguage式によるフィルタ条件 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TCPソケット | base64エンコード+シリアライズ | アプリケーションから送信されるログレコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | テキスト | ConsoleFormatterで整形されたログメッセージ |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   ├─ --filter指定時: ExpressionLanguageインスタンス生成
   └─ ConsoleHandler / ConsoleFormatter設定
2. TCPソケットサーバー起動
   └─ stream_socket_server()でリスニング開始
3. クライアント接続受け入れループ
   ├─ stream_select()で読み取り可能ストリーム検出
   ├─ 新規接続: stream_socket_accept()で受け入れ
   ├─ データ受信: fgets()でログメッセージ読み取り
   └─ 切断: feof()検出でソケットクローズ
4. ログメッセージ処理
   ├─ base64デコード + unserialize()でログレコード復元
   ├─ フィルタ条件適用（--filter指定時）
   └─ ConsoleHandler経由でフォーマット・出力
5. 終了（CONTROL-Cで手動停止）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ソケットサーバー起動]
    B --> C[接続待機 stream_select]
    C --> D{イベント種別}
    D -->|新規接続| E[stream_socket_accept]
    D -->|データ受信| F[fgets でログ読み取り]
    D -->|切断| G[ソケットクローズ]
    E --> C
    F --> H[base64デコード + unserialize]
    H --> I{デコード成功?}
    I -->|失敗| C
    I -->|成功| J{フィルタ条件あり?}
    J -->|あり| K{フィルタ通過?}
    J -->|なし| L[ログ表示]
    K -->|不通過| C
    K -->|通過| L
    L --> C
    G --> C
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはネットワーク経由でログデータを受信・表示するのみである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | LogicException | --filter使用時にsymfony/expression-languageが未インストール | `composer require symfony/expression-language` を実行 |
| - | RuntimeException | ソケットサーバー起動失敗（ポート使用中等） | 他のプロセスを停止するか別のポートを使用する |
| - | デシリアライズ失敗 | 不正なログメッセージ受信 | スキップして次のメッセージを処理（自動対応） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

ソケットサーバーが起動できない場合は、ポートの使用状況を確認する。不正なメッセージは自動的にスキップされるため、個別対応は不要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | アプリケーションのログ出力量に依存 |
| 目標処理時間 | リアルタイム（受信即表示） |
| メモリ使用量上限 | 特に制限なし（長時間稼働時はPHPメモリ制限に依存） |

## 排他制御

同一ポートでの複数起動は不可（ソケットバインドによる自然な排他制御）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 受信ログ | ログメッセージ受信時 | クライアント識別色付きログブロック + ConsoleFormatter整形済みログメッセージ |
| 終了ログ | なし | CONTROL-Cで強制終了のため終了ログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

開発支援ツールのため、監視・アラートは不要。

## 備考

- 基盤実装は `src/Symfony/Bridge/Monolog/Command/ServerLogCommand.php` に存在する
- デフォルトリスニングアドレスは `0.0.0.0:9911`
- クライアント識別のため、各接続に色付きブロック（8色のバックグラウンドカラー）が割り当てられる
- ログレコードに `log_id` が含まれる場合、それをクライアント識別に使用する
- ログレコードはbase64エンコード + PHPシリアライズ形式で送信される
- `--filter` オプションでExpressionLanguage式を使用した柔軟なフィルタリングが可能（例: `level > 200 or channel in ['app', 'doctrine']`）
- VERBOSITYがDEBUG以上の場合、マルチライン表示が有効になる
