# バッチ設計書 36-messenger:setup-transports

## 概要

本ドキュメントは、Symfony Messengerコンポーネントが提供する `messenger:setup-transports` コマンドのバッチ設計書である。メッセージングトランスポートに必要なインフラストラクチャ（テーブル作成、キュー作成等）をセットアップするコマンドの仕様を定義する。

### 本バッチの処理概要

`messenger:setup-transports` コマンドは、設定されたメッセージングトランスポートに必要なインフラストラクチャを準備するコマンドである。

**業務上の目的・背景**：Symfony Messengerのトランスポート（Doctrine、AMQP、Redis等）はメッセージの送受信にインフラストラクチャ（データベーステーブル、キュー、ストリーム等）を必要とする。アプリケーションのデプロイ時や初回セットアップ時に、これらのインフラストラクチャを自動的に作成することで、手動でのテーブル作成やキュー設定の手間を省き、セットアップミスを防止する。

**バッチの実行タイミング**：デプロイ時またはインフラストラクチャ初期化時に手動またはデプロイスクリプトの一部として実行する。

**主要な処理内容**：
1. 対象トランスポートの決定（引数指定時は単一、未指定時は全トランスポート）
2. 各トランスポートがSetupableTransportInterfaceを実装しているか確認
3. setup()メソッドを呼び出してインフラストラクチャを作成
4. 結果（成功/スキップ）を出力

**前後の処理との関連**：`messenger:consume` の実行前に本コマンドでインフラストラクチャを準備しておく必要がある。デプロイパイプラインでは `cache:clear` や `doctrine:migrations:migrate` と同列に実行されることが多い。

**影響範囲**：トランスポートに応じて、データベーステーブルの作成、AMQPキュー/エクスチェンジの作成、Redisストリームの作成等が行われる。

## バッチ種別

インフラストラクチャ初期化（トランスポートセットアップ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（デプロイ時） |
| 実行時刻 | デプロイ時 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / デプロイスクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| トランスポート設定 | messenger.yamlでトランスポートが設定されていること |
| 接続情報 | トランスポートの接続先（DB、AMQP、Redis等）にアクセス可能であること |

### 実行可否判定

トランスポート引数が指定された場合、そのトランスポートがtransportLocatorに存在する必要がある。存在しない場合はRuntimeExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| transport | string | No | なし（全トランスポート対象） | セットアップ対象のトランスポート名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| トランスポート設定 | DI Container | ServiceLocator経由で登録済みトランスポートを取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | テキスト | セットアップ結果（成功メッセージまたはスキップノート） |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ 引数・オプションの取得
2. 対象トランスポート決定
   ├─ transport引数指定あり: 指定トランスポートのみ
   └─ transport引数指定なし: 全登録トランスポート
3. 各トランスポートに対してセットアップ実行
   ├─ transportLocatorからトランスポートインスタンス取得
   ├─ SetupableTransportInterface実装チェック
   │   ├─ 非実装: "does not support setup" ノート出力
   │   └─ 実装あり: setup() メソッド呼び出し
   └─ 成功メッセージ出力
4. エラー発生時
   └─ RuntimeExceptionとしてスロー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{transport引数指定?}
    B -->|あり| C[指定トランスポートのみ対象]
    B -->|なし| D[全トランスポート対象]
    C --> E{トランスポート存在?}
    E -->|なし| F[RuntimeException]
    E -->|あり| G[トランスポート処理ループ]
    D --> G
    G --> H{SetupableTransportInterface?}
    H -->|非実装| I[スキップノート出力]
    H -->|実装あり| J[setup実行]
    J --> K{成功?}
    K -->|成功| L[成功メッセージ出力]
    K -->|失敗| M[RuntimeException]
    I --> N{次のトランスポート?}
    L --> N
    N -->|あり| G
    N -->|なし| O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

Doctrineトランスポート使用時の例:

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テーブル作成 | messenger_messages | CREATE TABLE | メッセージキューテーブルの作成 |

### テーブル別操作詳細

#### messenger_messages（Doctrineトランスポート使用時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE TABLE | id, body, headers, queue_name, created_at, available_at, delivered_at | DDL実行 | トランスポート実装に依存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | 指定トランスポートが存在しない | 正しいトランスポート名を指定する |
| - | RuntimeException | setup()実行中にエラー発生 | 接続情報・権限を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

セットアップ失敗時は、エラーメッセージに含まれるトランスポート名と元の例外メッセージを確認し、接続情報・権限設定を見直して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | トランスポート単位（setup()メソッドの実装に依存） |
| コミットタイミング | setup()メソッドの実装に依存 |
| ロールバック条件 | setup()メソッドで例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | トランスポート数（通常1〜5程度） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御なし。ただし、setup()が冪等でないトランスポートの場合、同時実行により競合が発生する可能性がある。通常はデプロイ時に単一プロセスで実行する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | セットアップ成功時 | 「The "{name}" transport was set up successfully.」 |
| スキップログ | 非対応トランスポート時 | 「The "{name}" transport does not support setup.」 |
| エラーログ | セットアップ失敗時 | RuntimeExceptionメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | デプロイパイプライン |

## 備考

- 基盤実装は `src/Symfony/Component/Messenger/Command/SetupTransportsCommand.php` に存在する
- SetupableTransportInterfaceを実装するトランスポートのみがセットアップ対象となる
- 冪等な操作とは限らないため、既にセットアップ済みの環境で再実行する場合はトランスポートの実装に注意が必要
- Doctrineトランスポートの場合、`messenger_messages` テーブルが作成される
- AMQPトランスポートの場合、キューとエクスチェンジが作成される
