# バッチ設計書 37-messenger:stop-workers

## 概要

本ドキュメントは、Symfony Messengerコンポーネントが提供する `messenger:stop-workers` コマンドのバッチ設計書である。実行中の `messenger:consume` ワーカープロセスに対して停止シグナルを送信し、現在処理中のメッセージの完了後にワーカーを安全に停止させるコマンドの仕様を定義する。

### 本バッチの処理概要

`messenger:stop-workers` コマンドは、キャッシュベースのシグナリング機構を使用して、実行中のすべてのワーカープロセスに停止シグナルを送信するコマンドである。

**業務上の目的・背景**：`messenger:consume` ワーカーは長時間実行型のプロセスであり、コードの更新やデプロイ時にはワーカーの再起動が必要となる。プロセスを直接killすると処理中のメッセージが失われる可能性がある。`messenger:stop-workers` はキャッシュを介して停止シグナルを送信し、ワーカーが現在処理中のメッセージを完了してから安全に停止することを保証する。これはGraceful Shutdownパターンの実装である。

**バッチの実行タイミング**：デプロイ時やワーカー再起動が必要な場合に手動またはデプロイスクリプトの一部として実行する。

**主要な処理内容**：
1. CacheItemPoolから再起動シグナル用のキャッシュアイテムを取得
2. 現在のmicrotime(true)をタイムスタンプとしてキャッシュに保存
3. ワーカー側のStopWorkerOnRestartSignalListenerがこのタイムスタンプを検知して停止

**前後の処理との関連**：`messenger:consume` で起動されたワーカープロセスの停止に使用される。停止後、Supervisorなどのプロセスマネージャーがワーカーを再起動する。デプロイパイプラインでは `messenger:stop-workers` → コードデプロイ → ワーカー再起動の順序で実行される。

**影響範囲**：キャッシュプールへの書き込みのみ。実行中のワーカープロセスが停止シグナルを検知して自主的に停止する。

## バッチ種別

プロセス制御（ワーカー停止シグナル送信）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（デプロイ時） |
| 実行時刻 | デプロイ時 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / デプロイスクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| キャッシュプール | CacheItemPoolInterfaceが設定されていること |
| 共有キャッシュ | ワーカーと同一のキャッシュプールにアクセスできること |

### 実行可否判定

CacheItemPoolInterfaceが利用可能であれば即座に実行可能。ワーカーが実行中でなくても問題なく実行できる（キャッシュへの書き込みのみ）。

## 入力仕様

### 入力パラメータ

入力パラメータなし。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 入力データソースなし |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | テキスト | 「Signal successfully sent to stop any running workers.」 |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. キャッシュアイテム取得
   └─ restartSignalCachePool->getItem(RESTART_REQUESTED_TIMESTAMP_KEY)
2. タイムスタンプ設定
   └─ cacheItem->set(microtime(true))
3. キャッシュ保存
   └─ restartSignalCachePool->save(cacheItem)
4. 成功メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[キャッシュアイテム取得]
    B --> C[現在タイムスタンプ設定]
    C --> D[キャッシュ保存]
    D --> E[成功メッセージ出力]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。キャッシュプールへの書き込みのみ（キャッシュバックエンドがデータベースの場合は間接的にDB操作が発生）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャッシュ書き込みエラー | キャッシュプールへの書き込みに失敗 | キャッシュバックエンドの状態を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

キャッシュへの書き込みに失敗した場合は、キャッシュバックエンドの状態を確認する。ワーカーが停止しない場合は、プロセスマネージャー経由で直接停止する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（単一のキャッシュ書き込み） |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御なし。複数回実行しても問題ない（冪等な操作）。最新のタイムスタンプが常に有効。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | 処理完了時 | 「Signal successfully sent to stop any running workers.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | デプロイパイプライン |

## 備考

- 基盤実装は `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` に存在する
- StopWorkerOnRestartSignalListenerの `RESTART_REQUESTED_TIMESTAMP_KEY` をキャッシュキーとして使用する
- キャッシュに保存するのはmicrotime(true)の値で、ワーカーは起動時のタイムスタンプと比較して停止判定を行う
- ワーカーとこのコマンドが同一のキャッシュプールにアクセスできる必要がある（分散環境ではRedisなど共有キャッシュが必要）
- ワーカーは即座に停止するわけではなく、現在処理中のメッセージを完了してから停止する（Graceful Shutdown）
- ワーカーは自動的に再起動されない（Supervisorなどのプロセスマネージャーで管理する必要がある）
