# バッチ設計書 38-messenger:stats

## 概要

本ドキュメントは、Symfony Messengerコンポーネントが提供する `messenger:stats` コマンドのバッチ設計書である。1つ以上のメッセージングトランスポートに滞留しているメッセージ数を表示する統計情報確認コマンドの仕様を定義する。

### 本バッチの処理概要

`messenger:stats` コマンドは、設定された各トランスポートのメッセージ滞留数を取得・表示するコマンドである。

**業務上の目的・背景**：非同期メッセージング基盤の運用において、各トランスポートのメッセージ滞留数はシステムの健全性を示す重要な指標である。メッセージが滞留している場合はワーカーの処理能力不足やワーカーの停止を示す可能性がある。本コマンドにより、オペレーターはメッセージキューの状態を素早く確認し、適切な対応（ワーカーの増設や再起動等）を判断できる。

**バッチの実行タイミング**：随時実行（手動）。運用監視やトラブルシューティング時に使用する。

**主要な処理内容**：
1. 対象トランスポートの決定（引数指定時は指定のみ、未指定時は全トランスポート）
2. 各トランスポートのMessageCountAwareInterface実装確認
3. メッセージ数の取得
4. テキストまたはJSON形式で結果を出力

**前後の処理との関連**：独立した統計確認コマンドであり、他のバッチとの依存関係はない。`messenger:consume` の運用状況確認に使用される。

**影響範囲**：読み取り専用の統計確認処理であり、システム状態を変更しない。

## バッチ種別

運用監視（メッセージキュー統計情報表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| トランスポート設定 | 少なくとも1つのトランスポートが設定されていること |
| トランスポート接続 | 各トランスポートの接続先にアクセス可能であること |

### 実行可否判定

トランスポートが設定されていれば実行可能。存在しないトランスポート名を指定した場合は警告が表示される（txt形式の場合）。MessageCountAwareInterface非実装のトランスポートはカウント不可としてノートが表示される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| transport_names | string[] | No | なし（全トランスポート対象） | メッセージ数を確認するトランスポート名のリスト |
| --format | string | No | txt | 出力フォーマット。txt / json |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| トランスポート | MessageCountAwareInterface | 各トランスポートからメッセージ数を取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | txt / json | トランスポート名とメッセージ数のテーブルまたはJSON |
| STDERR | テキスト | 警告・ノート情報 |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ 引数・オプションの取得
2. 出力フォーマット検証
   └─ txt / json 以外はInvalidArgumentException
3. 対象トランスポート決定
   ├─ transport_names引数あり: 指定トランスポートのみ
   └─ 引数なし: 全登録トランスポート
4. 各トランスポートのメッセージ数取得
   ├─ トランスポート存在チェック（不在時は警告/スキップ）
   ├─ MessageCountAwareInterface実装チェック
   │   ├─ 非実装: uncountableTransportsに追加
   │   └─ 実装あり: getMessageCount() で件数取得
   └─ 結果テーブルに追加
5. 結果出力
   ├─ txt形式: テーブル形式で出力 + カウント不可トランスポートのノート
   └─ json形式: JSON形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[フォーマット検証]
    B --> C[対象トランスポート決定]
    C --> D[トランスポート処理ループ]
    D --> E{トランスポート存在?}
    E -->|なし| F[警告出力]
    E -->|あり| G{MessageCountAwareInterface?}
    G -->|非実装| H[uncountableリストに追加]
    G -->|実装あり| I[getMessageCount取得]
    I --> J[結果テーブルに追加]
    F --> K{次のトランスポート?}
    H --> K
    J --> K
    K -->|あり| D
    K -->|なし| L[フォーマットに応じた出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンド自体はデータベース操作を行わないが、Doctrineトランスポート使用時はgetMessageCount()でSELECT COUNT(*)が実行される。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メッセージ数取得 | messenger_messages（Doctrine使用時） | SELECT | メッセージ件数カウント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | 不正な出力フォーマット指定 | txt / json のいずれかを指定する |
| - | 警告 | 存在しないトランスポート名指定（txt形式時） | 正しいトランスポート名を指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

トランスポートへの接続に失敗した場合は、接続情報を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | トランスポート数（通常1〜5程度） |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御なし。読み取り専用の処理であり、同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 処理完了時 | Transport名とCount列のテーブル（txt）またはJSON |
| 警告ログ | 存在しないトランスポート指定時（txt形式） | 「The "{name}" transport does not exist.」 |
| ノート | カウント不可トランスポート存在時 | 「Unable to get message count for...」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| メッセージ滞留数 | 環境依存 | 監視スクリプトで定期実行 |

## 備考

- 基盤実装は `src/Symfony/Component/Messenger/Command/StatsCommand.php` に存在する
- MessageCountAwareInterfaceを実装するトランスポートのみがメッセージ数カウントに対応
- JSON形式出力時は存在しないトランスポートの警告は出力されない（formatSupportsWarningsメソッドで制御）
- JSON出力形式: `{"transports": {"transport_name": {"count": N}}, "uncountable_transports": ["transport_name"]}`
- 監視スクリプトからの利用時は `--format=json` で機械可読な出力が得られる
